/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;

public class ReagenchantConfig {
    private static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;

    static void registerConfigs() {
        FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve("reagenchant"), (String)"reagenchant config");
        FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve(Paths.get("reagenchant", "reagent_packs")), (String)"reagenchant reagent packs");
        ModLoadingContext loadingContext = ModLoadingContext.get();
        loadingContext.registerConfig(ModConfig.Type.COMMON, COMMON_SPEC, "reagenchant/common-config.toml");
    }

    static {
        Pair netherSpecPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)netherSpecPair.getRight();
        COMMON = (CommonConfig)netherSpecPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue reagentPackUseGlobalReagentPacks;
        public final ForgeConfigSpec.BooleanValue reagentPackUseReagenchantReagentPack;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configuration settings").push("common");
            builder.comment("Reagent pack configuration settings").push("reagent_packs");
            this.reagentPackUseGlobalReagentPacks = builder.comment("Use global reagent packs.").define("useGlobalReagentPacks", true);
            this.reagentPackUseReagenchantReagentPack = builder.comment("Use the Reagenchant reagent pack.").define("useReagenchantReagentPack", true);
            builder.pop();
            builder.pop();
        }
    }
}

