/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import logictechcorp.reagenchant.tileentity.ReagentTableTileEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.model.BookModel;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReagentTableTileEntityRenderer
extends TileEntityRenderer<ReagentTableTileEntity> {
    private static final Material BOOK_TEXTURE = new Material(AtlasTexture.field_110575_b, new ResourceLocation("entity/enchanting_table_book"));
    private final BookModel bookModel = new BookModel();

    public ReagentTableTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(ReagentTableTileEntity reagentTable, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderBuffer, int combinedLight, int combinedOverlay) {
        float bookRotation;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.75, 0.5);
        float ticks = (float)reagentTable.getTickCounter() + partialTicks;
        matrixStack.func_227861_a_(0.0, (double)(0.1f + MathHelper.func_76126_a((float)(ticks * 0.1f)) * 0.01f), 0.0);
        for (bookRotation = reagentTable.getBookRotation() - reagentTable.getBookRotationPrev(); bookRotation >= (float)Math.PI; bookRotation -= (float)Math.PI * 2) {
        }
        while (bookRotation < (float)(-Math.PI)) {
            bookRotation += (float)Math.PI * 2;
        }
        float previousBookRotation = reagentTable.getBookRotationPrev() + bookRotation * partialTicks;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-previousBookRotation));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(80.0f));
        float pageFlip = MathHelper.func_219799_g((float)partialTicks, (float)reagentTable.getPageFlipPrev(), (float)reagentTable.getPageFlip());
        float pageFlipOne = MathHelper.func_226164_h_((float)(pageFlip + 0.25f)) * 1.6f - 0.3f;
        float pageFlipTwo = MathHelper.func_226164_h_((float)(pageFlip + 0.75f)) * 1.6f - 0.3f;
        float bookSpread = MathHelper.func_219799_g((float)partialTicks, (float)reagentTable.getBookSpreadPrev(), (float)reagentTable.getBookSpread());
        this.bookModel.func_228247_a_(ticks, MathHelper.func_76131_a((float)pageFlipOne, (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)pageFlipTwo, (float)0.0f, (float)1.0f), bookSpread);
        IVertexBuilder vertexBuilder = BOOK_TEXTURE.func_229311_a_(renderBuffer, RenderType::func_228634_a_);
        this.bookModel.func_228249_b_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }
}

