/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.reagent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import logictechcorp.libraryex.utility.RandomHelper;
import logictechcorp.reagenchant.reagent.ReagentEnchantData;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;

public class Reagent {
    public static final Reagent EMPTY = new Reagent(Items.field_190931_a);
    protected final Item item;
    protected final Map<Enchantment, ReagentEnchantData> enchantments;

    public Reagent(Item item) {
        this.item = item;
        this.enchantments = new HashMap<Enchantment, ReagentEnchantData>();
    }

    public void addEnchantment(ReagentEnchantData reagentEnchantData) {
        if (!this.isEmpty()) {
            this.enchantments.put(reagentEnchantData.getEnchantment(), reagentEnchantData);
        }
    }

    public void removeEnchantment(Enchantment enchantment) {
        if (!this.isEmpty()) {
            this.enchantments.remove(enchantment);
        }
    }

    public List<EnchantmentData> compileEnchantmentList(ItemStack unenchantedStack, int enchantmentTier, int enchantabilityLevel, Random random) {
        int itemEnchantability = unenchantedStack.getItemEnchantability();
        if (itemEnchantability <= 0) {
            return new ArrayList<EnchantmentData>();
        }
        float enchantmentMultiplier = (random.nextFloat() + random.nextFloat() - 1.0f) * 0.15f;
        enchantabilityLevel = enchantabilityLevel + 1 + random.nextInt(itemEnchantability / 4 + 1) + random.nextInt(itemEnchantability / 4 + 1);
        enchantabilityLevel = MathHelper.func_76125_a((int)Math.round((float)enchantabilityLevel + enchantmentMultiplier * (float)enchantabilityLevel), (int)1, (int)Integer.MAX_VALUE);
        ArrayList<EnchantmentData> defaultEnchantments = new ArrayList<EnchantmentData>();
        for (Enchantment enchantment : this.getApplicableEnchantments(unenchantedStack)) {
            int enchantmentLevel;
            ReagentEnchantData reagentEnchantData = this.getReagentEnchantData(enchantment);
            int minimumEnchantmentLevel = reagentEnchantData.getMinimumEnchantmentLevel();
            int maximumEnchantmentLevel = reagentEnchantData.getMaximumEnchantmentLevel();
            if (minimumEnchantmentLevel == enchantment.func_77319_d() && maximumEnchantmentLevel == enchantment.func_77325_b()) {
                for (enchantmentLevel = maximumEnchantmentLevel; enchantmentLevel > minimumEnchantmentLevel - 1 && enchantabilityLevel < enchantment.func_77321_a(enchantmentLevel); --enchantmentLevel) {
                }
            } else {
                int oneThird = (maximumEnchantmentLevel - minimumEnchantmentLevel) / 3;
                if (enchantmentTier == 0) {
                    maximumEnchantmentLevel = minimumEnchantmentLevel + oneThird;
                } else if (enchantmentTier == 1) {
                    minimumEnchantmentLevel += oneThird;
                    maximumEnchantmentLevel -= oneThird;
                } else {
                    minimumEnchantmentLevel = maximumEnchantmentLevel - oneThird;
                }
                enchantmentLevel = RandomHelper.getNumberInRange((int)minimumEnchantmentLevel, (int)maximumEnchantmentLevel, (Random)random);
            }
            if (enchantmentLevel <= 0 || !(this.getEnchantmentProbability(enchantment) >= random.nextFloat())) continue;
            defaultEnchantments.add(new EnchantmentData(enchantment, enchantmentLevel));
        }
        ArrayList<EnchantmentData> refinedEnchantments = new ArrayList<EnchantmentData>();
        while (!defaultEnchantments.isEmpty()) {
            EnchantmentData removedEnchantment = (EnchantmentData)WeightedRandom.func_76271_a((Random)random, defaultEnchantments);
            refinedEnchantments.add((EnchantmentData)defaultEnchantments.remove(defaultEnchantments.indexOf(removedEnchantment)));
            EnchantmentHelper.func_185282_a(defaultEnchantments, (EnchantmentData)removedEnchantment);
        }
        return refinedEnchantments;
    }

    public boolean canApplyEnchantments(ItemStack unenchantedStack) {
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!enchantment.canApplyAtEnchantingTable(unenchantedStack) && (unenchantedStack.func_77973_b() != Items.field_151122_aG || !enchantment.isAllowedOnBooks())) continue;
            return true;
        }
        return false;
    }

    public boolean consumeReagent(ItemStack unenchantedStack, List<EnchantmentData> enchantments) {
        List<Enchantment> applicableEnchantments = this.getApplicableEnchantments(unenchantedStack);
        for (EnchantmentData enchantmentData : enchantments) {
            if (!applicableEnchantments.contains(enchantmentData.field_76302_b)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEnchantment(Enchantment enchantment) {
        return this.enchantments.containsKey(enchantment);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.item == Items.field_190931_a || this.item == null;
    }

    public Item getItem() {
        return this.item;
    }

    public Set<Enchantment> getEnchantments() {
        return Collections.unmodifiableSet(this.enchantments.keySet());
    }

    public ReagentEnchantData getReagentEnchantData(Enchantment enchantment) {
        return this.enchantments.getOrDefault(enchantment, ReagentEnchantData.EMPTY);
    }

    public List<Enchantment> getApplicableEnchantments(ItemStack unenchantedStack) {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        for (Enchantment enchantment : this.enchantments.keySet()) {
            if (!enchantment.canApplyAtEnchantingTable(unenchantedStack) && (unenchantedStack.func_77973_b() != Items.field_151122_aG || !enchantment.isAllowedOnBooks())) continue;
            enchantments.add(enchantment);
        }
        return enchantments;
    }

    public float getEnchantmentProbability(Enchantment enchantment) {
        return this.getReagentEnchantData(enchantment).getEnchantmentProbability();
    }

    public int getCost(Enchantment enchantment) {
        return this.getReagentEnchantData(enchantment).getReagentCost();
    }
}

