/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.reagenchant.reagent;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logictechcorp.reagenchant.Reagenchant;
import logictechcorp.reagenchant.reagent.Reagent;
import logictechcorp.reagenchant.reagent.ReagentEnchantData;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;

public class ReagentManager
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<ResourceLocation, Reagent> reagents = new HashMap<ResourceLocation, Reagent>();

    public ReagentManager(String folderName) {
        super(GSON, folderName);
    }

    public ReagentManager() {
        this("reagents");
    }

    protected void apply(Map<ResourceLocation, JsonObject> locations, IResourceManager resourceManager, IProfiler profiler) {
        locations.forEach((resourceLocation, object) -> {
            try {
                IResource resource = resourceManager.func_199002_a(this.getPreparedPath((ResourceLocation)resourceLocation));
                InputStream inputStream = resource.func_199027_b();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class));
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Closeable)resource);
                if (dynamic.getValue() == null) {
                    Reagenchant.LOGGER.error("Couldn't load {} reagent config from {} data pack.", (Object)resource.func_199029_a(), (Object)resource.func_199026_d());
                } else {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(dynamic.get("item").asString("")));
                    if (item != null && item != Items.field_190931_a) {
                        List enchantments = dynamic.get("enchantments").asList(ReagentEnchantData::deserialize);
                        Reagent reagent = this.createReagent(item);
                        for (ReagentEnchantData enchantmentData : enchantments) {
                            if (enchantmentData.isEmpty()) continue;
                            reagent.addEnchantment(enchantmentData);
                        }
                        this.reagents.put(item.getRegistryName(), reagent);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public Reagent createReagent(Item item) {
        return new Reagent(item);
    }

    public void registerReagent(Reagent reagent) {
        if (reagent.getItem() != Items.field_190931_a) {
            this.reagents.put(reagent.getItem().getRegistryName(), reagent);
        }
    }

    public void unregisterReagent(Reagent reagent) {
        if (reagent.getItem() != Items.field_190931_a) {
            this.reagents.remove(reagent.getItem().getRegistryName());
        }
    }

    public void cleanup() {
        this.reagents.clear();
    }

    public void syncClientReagents(Collection<Reagent> reagents) {
        this.cleanup();
        for (Reagent reagent : reagents) {
            this.reagents.put(reagent.getItem().getRegistryName(), reagent);
        }
    }

    public boolean isReagent(Item item) {
        return this.reagents.containsKey(item.getRegistryName());
    }

    public Reagent getReagent(Item item) {
        return this.reagents.getOrDefault(item.getRegistryName(), Reagent.EMPTY);
    }

    public Map<ResourceLocation, Reagent> getReagents() {
        return Collections.unmodifiableMap(this.reagents);
    }
}

