/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.client.gui;

import java.util.List;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScrollableButtonList
extends ExtendedList<Entry> {
    private final CreateWorldScreen createWorldScreen;
    private final List<ButtonData> buttonDataList;

    public ScrollableButtonList(CreateWorldScreen createWorldScreen, int width, int height, int top, int bottom, List<ButtonData> buttonDataList) {
        super(createWorldScreen.getMinecraft(), width, height, top, bottom, 25);
        this.createWorldScreen = createWorldScreen;
        this.buttonDataList = buttonDataList;
        this.centerListVertically = false;
        this.populateComponents();
    }

    private void populateComponents() {
        for (int i = 0; i < this.buttonDataList.size(); i += 2) {
            ButtonData buttonDataCurrent = this.buttonDataList.get(i);
            ButtonData buttonDataNext = i < this.buttonDataList.size() - 1 ? this.buttonDataList.get(i + 1) : null;
            this.addEntry(new Entry(this.createButton(buttonDataCurrent), this.createButton(buttonDataNext)));
        }
    }

    private Button createButton(ButtonData buttonData) {
        if (buttonData != null) {
            return new Button(this.width / 2 - 155 + buttonData.getHorizontalPlacement(), 0, 150, 20, buttonData.getText(), buttonData.getPressable());
        }
        return null;
    }

    protected boolean isFocused() {
        return this.createWorldScreen.getFocused() == this;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 130;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Entry
    extends AbstractList.AbstractListEntry<Entry> {
        private final Button firstButton;
        private final Button secondButton;

        private Entry(Button firstButton, Button secondButton) {
            this.firstButton = firstButton;
            this.secondButton = secondButton;
        }

        public void render(int slotIndex, int x, int y, int width, int height, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            this.renderButton(this.firstButton, y, mouseX, mouseY, partialTicks);
            this.renderButton(this.secondButton, y, mouseX, mouseY, partialTicks);
        }

        private void renderButton(Button button, int y, int mouseX, int mouseY, float partialTicks) {
            if (button != null) {
                button.y = y;
                button.render(mouseX, mouseY, partialTicks);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int index) {
            boolean pressedPrimaryButton = this.pressButton(this.firstButton, mouseX, mouseY, index);
            boolean pressedSecondaryButton = this.pressButton(this.secondButton, mouseX, mouseY, index);
            return pressedPrimaryButton || pressedSecondaryButton;
        }

        private boolean pressButton(Button button, double mouseX, double mouseY, int index) {
            if (button != null) {
                return button.mouseClicked(mouseX, mouseY, index);
            }
            return false;
        }

        public boolean mouseReleased(double mouseX, double mouseY, int index) {
            return this.releaseComponent(this.firstButton, mouseX, mouseY, index) | this.releaseComponent(this.secondButton, mouseX, mouseY, index);
        }

        private boolean releaseComponent(Button button, double mouseX, double mouseY, int index) {
            if (button != null) {
                return button.mouseReleased(mouseX, mouseY, index);
            }
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ButtonData {
        private final String text;
        private final int horizontalPlacement;
        private final Button.IPressable pressable;

        public ButtonData(String text, int horizontalPlacement, Button.IPressable pressable) {
            this.text = text;
            this.horizontalPlacement = horizontalPlacement;
            this.pressable = pressable;
        }

        public String getText() {
            return this.text;
        }

        public int getHorizontalPlacement() {
            return this.horizontalPlacement;
        }

        public Button.IPressable getPressable() {
            return this.pressable;
        }
    }
}

