/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.client.render.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import logictechcorp.libraryex.block.MimicBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;

public class MimicBakedModel
extends BakedModelWrapper<IBakedModel> {
    private final MimicBlock.MimicType mimicType;

    public MimicBakedModel(IBakedModel originalModel, MimicBlock.MimicType mimicType) {
        super(originalModel);
        this.mimicType = mimicType;
    }

    public TextureAtlasSprite getParticleTexture(IModelData modelData) {
        return super.getParticleTexture(modelData);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random random, IModelData modelData) {
        ArrayList<BakedQuad> retQuads;
        ArrayList<BakedQuad> originalQuads = new ArrayList<BakedQuad>(this.originalModel.getQuads(state, side, random, modelData));
        ArrayList mimickedQuads = new ArrayList(this.getMimickedModel((BlockState)modelData.getData(MimicBlock.MIMIC_PROP)).getQuads(state, side, random, modelData));
        if (this.mimicType == MimicBlock.MimicType.OVERLAY) {
            retQuads = originalQuads;
            retQuads.addAll(mimickedQuads);
        } else if (this.mimicType == MimicBlock.MimicType.UNDERLAY) {
            retQuads = mimickedQuads;
            retQuads.addAll(originalQuads);
        } else {
            retQuads = mimickedQuads;
        }
        return retQuads;
    }

    public IModelData getModelData(ILightReader reader, BlockPos pos, BlockState state, IModelData modelData) {
        return modelData;
    }

    private IBakedModel getMimickedModel(BlockState state) {
        if (state != null) {
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            BlockModelShapes shapes = dispatcher.func_175023_a();
            return shapes.func_178125_b(state);
        }
        return this.originalModel;
    }
}

