/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.data.loottable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.AlternativesLootEntry;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.MatchTool;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.ExplosionDecay;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;

public class ModLootTableProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final String modId;
    private final DataGenerator generator;
    private final Map<ResourceLocation, LootTable> lootTables;

    public ModLootTableProvider(String modId, DataGenerator generator) {
        this.modId = modId;
        this.generator = generator;
        this.lootTables = new HashMap<ResourceLocation, LootTable>();
    }

    public void func_200398_a(DirectoryCache cache) {
        this.lootTables.forEach((location, lootTable) -> {
            Path lootTablePath = this.generator.func_200391_b().resolve("data/" + location.func_110624_b() + "/loot_tables/" + location.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)lootTablePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public void addEmptyBlockLootTable(Block block) {
        this.lootTables.put(block.func_220068_i(), LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
    }

    public void addBasicBlockLootTable(Block block, IItemProvider itemProvider) {
        LootPool.Builder lootPool = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)itemProvider)).func_212840_b_(SurvivesExplosion.func_215968_b());
        LootTable.Builder lootTable = LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(lootPool);
        this.lootTables.put(block.func_220068_i(), lootTable.func_216038_b());
    }

    public void addBasicBlockLootTable(Block block) {
        this.addBasicBlockLootTable(block, (IItemProvider)block);
    }

    public void addOreBlockLootTable(Block block, IItemProvider itemProvider) {
        AlternativesLootEntry.Builder lootEntry = ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)))))).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)itemProvider).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t)).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()));
        LootPool.Builder lootPool = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)lootEntry);
        LootTable.Builder lootTable = LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(lootPool);
        this.lootTables.put(block.func_220068_i(), lootTable.func_216038_b());
    }

    public void addOreBlockLootTable(Block block) {
        this.addOreBlockLootTable(block, (IItemProvider)block);
    }

    public void addSilkBlockLootTable(Block block) {
        LootEntry.Builder lootEntry = ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)))));
        LootPool.Builder lootPool = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(lootEntry);
        LootTable.Builder lootTable = LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(lootPool);
        this.lootTables.put(block.func_220068_i(), lootTable.func_216038_b());
    }

    public void addSlabBlockLootTable(Block block) {
        LootEntry.Builder lootEntry = ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)))).func_212840_b_(SurvivesExplosion.func_215968_b());
        LootPool.Builder lootPool = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(lootEntry);
        LootTable.Builder lootTable = LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216267_h).func_216040_a(lootPool);
        this.lootTables.put(block.func_220068_i(), lootTable.func_216038_b());
    }

    public void addEmptyEntityLootTable(ResourceLocation lootTableLocation) {
        this.lootTables.put(lootTableLocation, LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216263_d).func_216038_b());
    }

    public void addEmptyEntityLootTable(EntityType<?> entityType) {
        this.addEmptyEntityLootTable(entityType.func_220348_g());
    }

    public void addBasicEntityLootTable(ResourceLocation lootTableLocation, IItemProvider ... itemProviders) {
        LootTable.Builder lootTable = LootTable.func_216119_b().func_216039_a(LootParameterSets.field_216263_d);
        for (IItemProvider itemProvider : itemProviders) {
            StandaloneLootEntry.Builder lootEntry = ItemLootEntry.func_216168_a((IItemProvider)itemProvider).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f)));
            LootPool.Builder lootPool = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)lootEntry);
            lootTable.func_216040_a(lootPool);
        }
        this.lootTables.put(lootTableLocation, lootTable.func_216038_b());
    }

    public void addBasicEntityLootTable(EntityType<?> entityType, IItemProvider ... itemProviders) {
        this.addBasicEntityLootTable(entityType.func_220348_g(), itemProviders);
    }

    public String func_200397_b() {
        return this.modId + " loot tables";
    }
}

