/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.data.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import logictechcorp.libraryex.data.recipe.CookedRecipeBuilder;
import logictechcorp.libraryex.data.recipe.ISerializableRecipe;
import logictechcorp.libraryex.data.recipe.ShapedRecipeBuilder;
import logictechcorp.libraryex.data.recipe.ShapelessRecipeBuilder;
import logictechcorp.libraryex.data.recipe.SingleItemRecipeBuilder;
import logictechcorp.libraryex.item.crafting.LibraryExRecipeSerializers;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;

public class ModRecipeProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final String modId;
    private final DataGenerator generator;
    private final List<ISerializableRecipe> serializableRecipes;

    public ModRecipeProvider(String modId, DataGenerator generator) {
        this.modId = modId;
        this.generator = generator;
        this.serializableRecipes = new ArrayList<ISerializableRecipe>();
    }

    public void func_200398_a(DirectoryCache cache) {
        this.serializableRecipes.stream().filter(ISerializableRecipe::isValid).forEach(recipe -> {
            Path recipePath = this.generator.func_200391_b().resolve("data/" + this.modId + "/recipes/").resolve(recipe.getName() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)recipe.serialize(), (Path)recipePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public ShapedRecipeBuilder addShapedRecipe(IItemProvider itemProvider, int count) {
        ShapedRecipeBuilder recipe = new ShapedRecipeBuilder(itemProvider, count);
        this.serializableRecipes.add(recipe);
        return recipe;
    }

    public ShapelessRecipeBuilder addShapelessRecipe(IItemProvider itemProvider, int count) {
        ShapelessRecipeBuilder recipe = new ShapelessRecipeBuilder(itemProvider, count);
        this.serializableRecipes.add(recipe);
        return recipe;
    }

    public CookedRecipeBuilder addFurnaceRecipe(IItemProvider itemProvider) {
        CookedRecipeBuilder recipe = new CookedRecipeBuilder(IRecipeSerializer.field_222171_o, itemProvider);
        this.serializableRecipes.add(recipe);
        return recipe;
    }

    public CookedRecipeBuilder addBlastFurnaceRecipe(IItemProvider itemProvider) {
        CookedRecipeBuilder recipe = new CookedRecipeBuilder(IRecipeSerializer.field_222172_p, itemProvider);
        this.serializableRecipes.add(recipe);
        return recipe;
    }

    public CookedRecipeBuilder addSmokerRecipe(IItemProvider itemProvider) {
        CookedRecipeBuilder recipe = new CookedRecipeBuilder(IRecipeSerializer.field_222173_q, itemProvider);
        this.serializableRecipes.add(recipe);
        return recipe;
    }

    public CookedRecipeBuilder addCampfireRecipe(IItemProvider itemProvider) {
        CookedRecipeBuilder recipe = new CookedRecipeBuilder(IRecipeSerializer.field_222174_r, itemProvider);
        this.serializableRecipes.add(recipe);
        return recipe;
    }

    public SingleItemRecipeBuilder addStonecutterRecipe(IItemProvider itemProvider, int count) {
        SingleItemRecipeBuilder recipe = new SingleItemRecipeBuilder(IRecipeSerializer.field_222175_s, itemProvider, count);
        this.serializableRecipes.add(recipe);
        return recipe;
    }

    public SingleItemRecipeBuilder addRepairRecipe(IItemProvider itemProvider, int count) {
        SingleItemRecipeBuilder recipe = new SingleItemRecipeBuilder((IRecipeSerializer)LibraryExRecipeSerializers.CRAFTING_REPAIR.get(), itemProvider, count);
        this.serializableRecipes.add(recipe);
        return recipe;
    }

    public String func_200397_b() {
        return this.modId + " recipes";
    }
}

