/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import logictechcorp.libraryex.data.recipe.ISerializableRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShapedRecipeBuilder
implements ISerializableRecipe {
    private final Item result;
    private final int count;
    private final List<String> patterns;
    private final Map<Character, Ingredient> keys;
    private String group;
    private String name;

    ShapedRecipeBuilder(IItemProvider itemProvider, int count) {
        this.result = itemProvider.func_199767_j();
        this.count = count;
        this.patterns = new ArrayList<String>();
        this.keys = new LinkedHashMap<Character, Ingredient>();
    }

    public ShapedRecipeBuilder pattern(String pattern) {
        if (!this.patterns.isEmpty() && pattern.length() != this.patterns.get(0).length()) {
            throw new IllegalArgumentException("The pattern \"" + pattern + "\" does not have a width of " + this.patterns.get(0).length());
        }
        this.patterns.add(pattern);
        return this;
    }

    public ShapedRecipeBuilder key(char key, IItemProvider itemProvider) {
        if (this.keys.containsKey(Character.valueOf(key))) {
            throw new IllegalArgumentException("The key '" + key + "' was already defined");
        }
        if (key == ' ') {
            throw new IllegalArgumentException("The key '(whitespace)' cannot be used");
        }
        this.keys.put(Character.valueOf(key), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemProvider}));
        return this;
    }

    public ShapedRecipeBuilder group(String group) {
        if (this.group != null) {
            throw new IllegalArgumentException("The group \"" + group + "\" cannot be set as it was already defined");
        }
        this.group = group;
        return this;
    }

    public ISerializableRecipe build(String name) {
        this.name = name;
        return this;
    }

    @Override
    public JsonObject serialize() {
        JsonObject jsonObject = ISerializableRecipe.super.serialize();
        if (this.group != null && !this.group.isEmpty()) {
            jsonObject.addProperty("group", this.group);
        }
        JsonArray patternArray = new JsonArray();
        for (String string : this.patterns) {
            patternArray.add(string);
        }
        jsonObject.add("pattern", (JsonElement)patternArray);
        JsonObject keyObject = new JsonObject();
        for (Map.Entry<Character, Ingredient> entry : this.keys.entrySet()) {
            keyObject.add(String.valueOf(entry.getKey()), entry.getValue().func_200304_c());
        }
        jsonObject.add("key", (JsonElement)keyObject);
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
        if (this.count > 1) {
            jsonObject2.addProperty("count", (Number)this.count);
        }
        jsonObject.add("result", (JsonElement)jsonObject2);
        return jsonObject;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRecipeSerializer<?> getRecipeSerializer() {
        return IRecipeSerializer.field_222157_a;
    }
}

