/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import logictechcorp.libraryex.data.recipe.ISerializableRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShapelessRecipeBuilder
implements ISerializableRecipe {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients;
    private String group;
    private String name;

    ShapelessRecipeBuilder(IItemProvider itemProvider, int count) {
        this.result = itemProvider.func_199767_j();
        this.count = count;
        this.ingredients = new ArrayList<Ingredient>();
    }

    public ShapelessRecipeBuilder ingredient(IItemProvider itemProvider, int amount) {
        Ingredient ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemProvider});
        for (int i = 0; i < amount; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ShapelessRecipeBuilder group(String group) {
        if (this.group != null) {
            throw new IllegalArgumentException("The group \"" + group + "\" cannot be set as it was already defined");
        }
        this.group = group;
        return this;
    }

    public ISerializableRecipe build(String name) {
        this.name = name;
        return this;
    }

    @Override
    public JsonObject serialize() {
        JsonObject jsonObject = ISerializableRecipe.super.serialize();
        if (this.group != null && !this.group.isEmpty()) {
            jsonObject.addProperty("group", this.group);
        }
        JsonArray ingredientArray = new JsonArray();
        for (Ingredient ingredient : this.ingredients) {
            ingredientArray.add(ingredient.func_200304_c());
        }
        jsonObject.add("ingredients", (JsonElement)ingredientArray);
        JsonObject resultObject = new JsonObject();
        resultObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
        if (this.count > 1) {
            resultObject.addProperty("count", (Number)this.count);
        }
        jsonObject.add("result", (JsonElement)resultObject);
        return jsonObject;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRecipeSerializer<?> getRecipeSerializer() {
        return IRecipeSerializer.field_222158_b;
    }
}

