/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.item.crafting;

import com.google.gson.JsonObject;
import logictechcorp.libraryex.item.crafting.LibraryExRecipeSerializers;
import logictechcorp.libraryex.utility.RandomHelper;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RepairRecipe
implements ICraftingRecipe {
    private ResourceLocation recipeId;
    private ItemStack brokenStack;
    private Ingredient repairIngredient;
    private int repairAmount;

    public RepairRecipe(ResourceLocation recipeId, ItemStack brokenStack, Ingredient repairIngredient, int repairAmount) {
        this.recipeId = recipeId;
        this.brokenStack = brokenStack;
        this.repairIngredient = repairIngredient;
        this.repairAmount = repairAmount;
    }

    public boolean matches(CraftingInventory inventory, World world) {
        ItemStack brokenStack = ItemStack.field_190927_a;
        ItemStack repairStack = ItemStack.field_190927_a;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_77973_b() == this.brokenStack.func_77973_b()) {
                if (!brokenStack.func_190926_b()) {
                    return false;
                }
                brokenStack = stack;
                continue;
            }
            if (!this.repairIngredient.test(stack)) continue;
            if (!repairStack.func_190926_b()) {
                return false;
            }
            repairStack = stack;
        }
        return !brokenStack.func_190926_b() && brokenStack.func_77952_i() > 0 && !repairStack.func_190926_b();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory inventory) {
        ItemStack brokenStack = ItemStack.field_190927_a;
        ItemStack repairStack = ItemStack.field_190927_a;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_77973_b() == this.brokenStack.func_77973_b()) {
                if (!brokenStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                brokenStack = stack;
                continue;
            }
            if (!this.repairIngredient.test(stack)) continue;
            if (!repairStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            repairStack = stack;
        }
        ItemStack output = brokenStack.func_77946_l();
        output.func_96631_a(-this.repairAmount, RandomHelper.getRandom(), null);
        return output;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)LibraryExRecipeSerializers.CRAFTING_REPAIR.get();
    }

    public ItemStack getBrokenStack() {
        return this.brokenStack;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient;
    }

    public int getRepairAmount() {
        return this.repairAmount;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RepairRecipe> {
        public RepairRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonObject repairObject = JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            String brokenObject = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            Ingredient ingredient = Ingredient.field_193370_a;
            ItemStack brokenStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(brokenObject)));
            int repairAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"count");
            if (repairObject.has("item")) {
                ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)repairObject, (String)"item"))))});
            }
            if (repairObject.has("tag")) {
                ingredient = Ingredient.func_199805_a((Tag)new ItemTags.Wrapper(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)repairObject, (String)"tag"))));
            }
            return new RepairRecipe(recipeId, brokenStack, ingredient, repairAmount);
        }

        public RepairRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ItemStack brokenStack = buffer.func_150791_c();
            ItemStack repairStack = buffer.func_150791_c();
            int repairAmount = buffer.func_150792_a();
            return new RepairRecipe(recipeId, brokenStack, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{repairStack}), repairAmount);
        }

        public void write(PacketBuffer buffer, RepairRecipe recipe) {
            buffer.func_150788_a(recipe.getBrokenStack());
            buffer.func_150788_a(recipe.getRepairIngredient().func_193365_a()[0]);
            buffer.func_150787_b(recipe.getRepairAmount());
        }
    }
}

