/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.resource;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;

public class BuiltinDataPack
extends ModFileResourcePack
implements IPackFinder {
    private ModFile modFile;
    private String modId;
    private String packName;

    public BuiltinDataPack(ModFile modFile, String packName) {
        super(modFile);
        this.modFile = modFile;
        this.modId = ((IModInfo)modFile.getModInfos().get(0)).getModId();
        this.packName = packName;
    }

    public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> packs, ResourcePackInfo.IFactory<T> packInfoFactory) {
        String fileName = this.modId + ":" + this.packName;
        ResourcePackInfo t = ResourcePackInfo.func_195793_a((String)fileName, (boolean)false, () -> this, packInfoFactory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.BOTTOM);
        if (t != null) {
            packs.put(fileName, t);
        }
    }

    public boolean func_195768_c(String name) {
        return Files.exists(this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{"datapacks", this.packName, name}), new LinkOption[0]);
    }

    public InputStream func_195766_a(String name) throws IOException {
        Path path = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{"datapacks", this.packName, name});
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String resourceNamespace, String path, int maxDepth, Predicate<String> filter) {
        try {
            Path root = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{"datapacks"}).toAbsolutePath();
            Path inputPath = root.getFileSystem().getPath(path, new String[0]);
            return Files.walk(root, new FileVisitOption[0]).map(currentPath -> root.relativize(currentPath.toAbsolutePath())).filter(currentPath -> currentPath.getNameCount() > 3 && currentPath.getNameCount() - 1 <= maxDepth).filter(currentPath -> !currentPath.toString().endsWith(".mcmeta")).filter(currentPath -> currentPath.startsWith(this.packName)).filter(currentPath -> currentPath.subpath(3, currentPath.getNameCount()).startsWith(inputPath)).filter(currentPath -> filter.test(currentPath.getFileName().toString())).map(currentPath -> new ResourceLocation(currentPath.getName(2).toString(), Joiner.on((char)'/').join((Iterable)currentPath.subpath(3, Math.min(maxDepth, currentPath.getNameCount()))))).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        try {
            Path root = this.modFile.getLocator().findPath((IModFile)this.modFile, new String[]{"datapacks"}).toAbsolutePath();
            return Files.walk(root, 3, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() == 3).map(path -> path.getName(2)).map(path -> path.toString().replaceAll("/$", "")).filter(path -> !path.isEmpty()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    public String func_195762_a() {
        return this.modId + ":" + this.packName;
    }
}

