/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.tileentity;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityInventory
extends TileEntity {
    protected LazyOptional<ItemStackHandler> optionalItemStackHandler = LazyOptional.of(() -> new ItemStackHandler(size));
    protected Random random = new Random();

    public TileEntityInventory(TileEntityType tileEntityType, int size) {
        super(tileEntityType);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.optionalItemStackHandler.ifPresent(itemStackHandler -> compound.func_218657_a("Items", (INBT)itemStackHandler.serializeNBT()));
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.optionalItemStackHandler.ifPresent(itemStackHandler -> itemStackHandler.deserializeNBT(compound.func_74775_l("Items")));
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.optionalItemStackHandler;
        }
        return LazyOptional.empty();
    }

    public void dropInventoryItems(World world, BlockPos pos) {
        this.optionalItemStackHandler.ifPresent(itemStackHandler -> {
            for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
                ItemStack stack = itemStackHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                this.spawnItemStack(world, pos, stack);
            }
        });
    }

    public void spawnItemStack(World world, BlockPos pos, ItemStack stack) {
        double offsetX = this.random.nextFloat() * 0.8f + 0.1f;
        double offsetY = this.random.nextFloat() * 0.8f + 0.1f;
        double offsetZ = this.random.nextFloat() * 0.8f + 0.1f;
        while (!stack.func_190926_b()) {
            ItemEntity entityItem = new ItemEntity(world, (double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ, stack.func_77979_a(this.random.nextInt(21) + 10));
            entityItem.func_213293_j(this.random.nextGaussian() * (double)0.05f, this.random.nextGaussian() * (double)0.05f + (double)0.2f, this.random.nextGaussian() * (double)0.05f);
            world.func_217376_c((Entity)entityItem);
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return (ItemStackHandler)this.optionalItemStackHandler.orElseThrow(NullPointerException::new);
    }

    public Random getRandom() {
        return this.random;
    }
}

