/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.feature;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class PoolFeature
extends Feature<Config> {
    public PoolFeature(Function<Dynamic<?>, ? extends Config> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, Config config) {
        int posY;
        int posX;
        while (pos.func_177956_o() > 5 && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177979_c(4).func_177956_o() <= world.func_181545_F()) {
            return false;
        }
        pos = pos.func_177979_c(4);
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!world.func_217348_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ChunkStatus.field_222607_c).func_201578_b(Feature.field_214550_p.func_143025_a()).isEmpty()) {
            return false;
        }
        if (pos.func_177956_o() + 8 >= world.func_201672_e().func_201675_m().getActualHeight()) {
            return false;
        }
        boolean[] positions = new boolean[2048];
        int i = random.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = random.nextDouble() * 6.0 + 3.0;
            double d1 = random.nextDouble() * 4.0 + 2.0;
            double d2 = random.nextDouble() * 6.0 + 3.0;
            double d3 = random.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = random.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = random.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int posX2 = 1; posX2 < 15; ++posX2) {
                for (int posZ = 1; posZ < 15; ++posZ) {
                    for (int posY2 = 1; posY2 < 7; ++posY2) {
                        double d6 = ((double)posX2 - d3) / (d0 / 2.0);
                        double d7 = ((double)posY2 - d4) / (d1 / 2.0);
                        double d8 = ((double)posZ - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        positions[(posX2 * 16 + posZ) * 8 + posY2] = true;
                    }
                }
            }
        }
        for (posX = 0; posX < 16; ++posX) {
            for (int posZ = 0; posZ < 16; ++posZ) {
                for (posY = 0; posY < 8; ++posY) {
                    boolean flag;
                    boolean bl = flag = !positions[(posX * 16 + posZ) * 8 + posY] && (posX < 15 && positions[((posX + 1) * 16 + posZ) * 8 + posY] || posX > 0 && positions[((posX - 1) * 16 + posZ) * 8 + posY] || posZ < 15 && positions[(posX * 16 + posZ + 1) * 8 + posY] || posZ > 0 && positions[(posX * 16 + (posZ - 1)) * 8 + posY] || posY < 7 && positions[(posX * 16 + posZ) * 8 + posY + 1] || posY > 0 && positions[(posX * 16 + posZ) * 8 + (posY - 1)]);
                    if (!flag) continue;
                    Material material = world.func_180495_p(pos.func_177982_a(posX, posY, posZ)).func_185904_a();
                    if (posY >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (posY >= 4 || material.func_76220_a() || world.func_180495_p(pos.func_177982_a(posX, posY, posZ)) == config.getLiquidState()) continue;
                    return false;
                }
            }
        }
        for (posX = 0; posX < 16; ++posX) {
            for (int posZ = 0; posZ < 16; ++posZ) {
                for (posY = 0; posY < 8; ++posY) {
                    if (!positions[(posX * 16 + posZ) * 8 + posY]) continue;
                    world.func_180501_a(pos.func_177982_a(posX, posY, posZ), posY >= 4 ? Blocks.field_201941_jj.func_176223_P() : config.getLiquidState(), 2);
                }
            }
        }
        for (posX = 0; posX < 16; ++posX) {
            for (int posZ = 0; posZ < 16; ++posZ) {
                for (posY = 0; posY < 8; ++posY) {
                    boolean flag1;
                    boolean bl = flag1 = !positions[(posX * 16 + posZ) * 8 + posY] && (posX < 15 && positions[((posX + 1) * 16 + posZ) * 8 + posY] || posX > 0 && positions[((posX - 1) * 16 + posZ) * 8 + posY] || posZ < 15 && positions[(posX * 16 + posZ + 1) * 8 + posY] || posZ > 0 && positions[(posX * 16 + (posZ - 1)) * 8 + posY] || posY < 7 && positions[(posX * 16 + posZ) * 8 + posY + 1] || posY > 0 && positions[(posX * 16 + posZ) * 8 + (posY - 1)]);
                    if (!flag1 || posY >= 4 && random.nextInt(2) == 0 || !world.func_180495_p(pos.func_177982_a(posX, posY, posZ)).func_185904_a().func_76220_a()) continue;
                    world.func_180501_a(pos.func_177982_a(posX, posY, posZ), config.getSurroundingState(), 2);
                }
            }
        }
        return true;
    }

    public static class Config
    implements IFeatureConfig {
        private final BlockState liquidState;
        private final BlockState surroundingState;

        public Config(BlockState liquidState, BlockState surroundingState) {
            this.liquidState = liquidState;
            this.surroundingState = surroundingState;
        }

        public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put(ops.createString("liquid_state"), BlockState.func_215689_a(ops, (BlockState)this.liquidState).getValue());
            map.put(ops.createString("surrounding_state"), BlockState.func_215689_a(ops, (BlockState)this.surroundingState).getValue());
            return new Dynamic(ops, ops.createMap(map));
        }

        public static <T> Config deserialize(Dynamic<T> dynamic) {
            BlockState liquidState = dynamic.get("liquid_state").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
            BlockState surroundingState = dynamic.get("surrounding_state").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
            return new Config(liquidState, surroundingState);
        }

        public BlockState getLiquidState() {
            return this.liquidState;
        }

        public BlockState getSurroundingState() {
            return this.surroundingState;
        }
    }
}

