/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.RegrowthEntitiesManager;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="regrowth", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static int aDebugLevel;
    public static double aEatingHeals;
    public static String[] defaultRegrowthMobs;
    public static String defaultRegrowthMobs6464;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == SERVER_SPEC) {
            MyConfig.bakeConfig();
            RegrowthEntitiesManager.regrowthMobInit();
        }
    }

    public static void pushValues() {
        MyConfig.SERVER.defaultRegrowthMobsActual.set((Object)RegrowthEntitiesManager.getRegrowthHashAsString());
    }

    public static void bakeConfig() {
        aDebugLevel = (Integer)MyConfig.SERVER.debugLevel.get();
        aEatingHeals = (Double)MyConfig.SERVER.eatingHeals.get();
        defaultRegrowthMobs6464 = (String)MyConfig.SERVER.defaultRegrowthMobsActual.get();
        if (aDebugLevel > 0) {
            System.out.println("Regrowth Debug Level: " + aDebugLevel);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.DoubleValue eatingHeals;
        public final ForgeConfigSpec.ConfigValue<String> defaultRegrowthMobsActual;
        public final String defaultRegrowthMobs6464 = "minecraft:cow,both,240.0;minecraft:horse,eat,360.0;minecraft:donkey,eat,360.0;minecraft:sheep,eat,240.0;minecraft:pig,grow,800.0;minecraft:bee,grow,1000.0;minecraft:chicken,grow,600.0;minecraft:villager,crwlvpt,5.0;minecraft:creeper,tall,60.0";

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Regrowth Control Values");
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("regrowth.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.eatingHeals = builder.comment("Eating Heals: 0-No, 1-yes").translation("regrowth.config.eatingHeals").defineInRange("eatingHeals", () -> 0.99, 0.0, 1.0);
            builder.pop();
            builder.push("Regrowth Mobs 6464");
            this.defaultRegrowthMobsActual = builder.comment("RegrowthMobs String 6464").translation("regrowth.configdefaultRegrowthMobsActual").define("defaultRegrowthMobsActual", (Object)"minecraft:cow,both,240.0;minecraft:horse,eat,360.0;minecraft:donkey,eat,360.0;minecraft:sheep,eat,240.0;minecraft:pig,grow,800.0;minecraft:bee,grow,1000.0;minecraft:chicken,grow,600.0;minecraft:villager,crwlvpt,5.0;minecraft:creeper,tall,60.0");
            builder.pop();
        }
    }
}

