/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.RegrowthEntitiesManager;
import com.mactso.regrowth.config.WallBiomeDataManager;
import com.mactso.regrowth.config.WallFoundationDataManager;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="regrowth", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static int aDebugLevel;
    public static double aEatingHeals;
    public static String[] defaultRegrowthMobs;
    public static String defaultRegrowthMobs6464;
    public static String[] defaultWallFoundations;
    public static String defaultWallFoundations6464;
    public static String[] defaultWallBiomeData;
    public static String defaultWallBiomeData6464;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == SERVER_SPEC) {
            if (aDebugLevel > 0) {
                System.out.println("Regrowth:onModConfigEvent Level: " + aDebugLevel);
            }
            MyConfig.bakeConfig();
            RegrowthEntitiesManager.regrowthMobInit();
            WallFoundationDataManager.wallFoundationsInit();
            WallBiomeDataManager.wallBiomeDataInit();
        }
    }

    public static void pushDebugLevel() {
        MyConfig.SERVER.debugLevel.set((Object)aDebugLevel);
    }

    public static void pushValues() {
        if (aDebugLevel > 0) {
            System.out.println("Regrowth:pushValues Level: " + aDebugLevel);
        }
        MyConfig.SERVER.defaultRegrowthMobsActual.set((Object)RegrowthEntitiesManager.getRegrowthHashAsString());
        MyConfig.SERVER.defaultWallFoundationsActual.set((Object)WallFoundationDataManager.getWallFoundationHashAsString());
        MyConfig.SERVER.defaultBiomeWallDataActual.set((Object)WallBiomeDataManager.getWallBiomeDataHashAsString());
    }

    public static void bakeConfig() {
        aDebugLevel = (Integer)MyConfig.SERVER.debugLevel.get();
        aEatingHeals = (Double)MyConfig.SERVER.eatingHeals.get();
        defaultRegrowthMobs6464 = (String)MyConfig.SERVER.defaultRegrowthMobsActual.get();
        defaultWallFoundations6464 = (String)MyConfig.SERVER.defaultWallFoundationsActual.get();
        defaultWallBiomeData6464 = (String)MyConfig.SERVER.defaultBiomeWallDataActual.get();
        if (aDebugLevel > 0) {
            System.out.println("Regrowth:BakeConfig Debug Level: " + aDebugLevel);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.DoubleValue eatingHeals;
        public final ForgeConfigSpec.ConfigValue<String> defaultRegrowthMobsActual;
        public final String defaultRegrowthMobs6464 = "minecraft:cow,both,240.0;minecraft:horse,eat,360.0;minecraft:donkey,eat,360.0;minecraft:sheep,eat,240.0;minecraft:pig,grow,800.0;minecraft:bee,grow,1000.0;minecraft:chicken,grow,600.0;minecraft:villager,crwlvt,5.0;minecraft:creeper,tall,60.0";
        public final ForgeConfigSpec.ConfigValue<String> defaultWallFoundationsActual;
        public final String defaultWallFoundations6464 = "minecraft:grass_block;minecraft:sand;minecraft:red_sand;minecraft:netherrack;minecraft:sandstone;minecraft:podzol;minecraft:dirt;minecraft:stone;minecraft:coarse_dirt";
        public final ForgeConfigSpec.ConfigValue<String> defaultBiomeWallDataActual;
        public final String defaultBiomeWallData6464 = "Regrowth:default,48,minecraft:cobblestone_wall,minecraft:oak_fence;minecraft:plains,64,minecraft:cobblestone_wall,minecraft:oak_fence;minecraft:desert,48,minecraft:sandstone_wall,minecraft:birch_fence;minecraft:taiga,48,minecraft:mossy_cobblestone_wall,minecraft:spruce_fence;minecraft:savanna,48,minecraft:stone_brick_wall,minecraft:acacia_fence;minecraft:icy,40,minecraft:diorite_wall,minecraft:spruce_fence;minecraft:the_end,40,minecraft:end_stone_brick_wall,minecraft:birch_fence;minecraft:beach,48,minecraft:sandstone_wall,minecraft:oak_fence;minecraft:forest,64,minecraft:mossy_stone_brick_wall,minecraft:oak_fence;minecraft:mesa,48,minecraft:red_sandstone_wall,minecraft:oak_fence;minecraft:jungle,48,minecraft:granite_wall,minecraft:jungle_fence;minecraft:river,48,minecraft:sandstone_wall,minecraft:oak_fence;minecraft:nether,40,minecraft:cobblestone_wall,minecraft:nether_brick_fence;Regrowth:minimum,32,regrowth:minimum_wall_size,regrowth:fence_placeholder";

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Regrowth Control Values");
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("regrowth.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.eatingHeals = builder.comment("Eating Heals: 0-No, 1-yes").translation("regrowth.config.eatingHeals").defineInRange("eatingHeals", () -> 0.99, 0.0, 1.0);
            builder.pop();
            builder.push("Regrowth Mobs 6464");
            this.defaultRegrowthMobsActual = builder.comment("RegrowthMobs String 6464").translation("regrowth.configdefaultRegrowthMobsActual").define("defaultRegrowthMobsActual", (Object)"minecraft:cow,both,240.0;minecraft:horse,eat,360.0;minecraft:donkey,eat,360.0;minecraft:sheep,eat,240.0;minecraft:pig,grow,800.0;minecraft:bee,grow,1000.0;minecraft:chicken,grow,600.0;minecraft:villager,crwlvt,5.0;minecraft:creeper,tall,60.0");
            builder.pop();
            builder.push("Regrowth Wall Foundations 6464");
            this.defaultWallFoundationsActual = builder.comment("WallFoundations String 6464").translation("regrowth.configdefaultWallFoundationsActual").define("defaultWallFoundationsActual", (Object)"minecraft:grass_block;minecraft:sand;minecraft:red_sand;minecraft:netherrack;minecraft:sandstone;minecraft:podzol;minecraft:dirt;minecraft:stone;minecraft:coarse_dirt");
            builder.pop();
            builder.push("Regrowth Biome Wall Data 6464");
            this.defaultBiomeWallDataActual = builder.comment("Biome Meeting Wall Data String 6464").translation("regrowth.configdefaultBiomeWallDataActual").define("defaultBiomeWallDataActual", (Object)"Regrowth:default,48,minecraft:cobblestone_wall,minecraft:oak_fence;minecraft:plains,64,minecraft:cobblestone_wall,minecraft:oak_fence;minecraft:desert,48,minecraft:sandstone_wall,minecraft:birch_fence;minecraft:taiga,48,minecraft:mossy_cobblestone_wall,minecraft:spruce_fence;minecraft:savanna,48,minecraft:stone_brick_wall,minecraft:acacia_fence;minecraft:icy,40,minecraft:diorite_wall,minecraft:spruce_fence;minecraft:the_end,40,minecraft:end_stone_brick_wall,minecraft:birch_fence;minecraft:beach,48,minecraft:sandstone_wall,minecraft:oak_fence;minecraft:forest,64,minecraft:mossy_stone_brick_wall,minecraft:oak_fence;minecraft:mesa,48,minecraft:red_sandstone_wall,minecraft:oak_fence;minecraft:jungle,48,minecraft:granite_wall,minecraft:jungle_fence;minecraft:river,48,minecraft:sandstone_wall,minecraft:oak_fence;minecraft:nether,40,minecraft:cobblestone_wall,minecraft:nether_brick_fence;Regrowth:minimum,32,regrowth:minimum_wall_size,regrowth:fence_placeholder");
            builder.pop();
        }
    }
}

