/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.MyConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class WallBiomeDataManager {
    public static Hashtable<String, WallBiomeDataItem> wallBiomeDataHashtable = new Hashtable();
    private static String defaultRegrowthMobString;
    private static String defaultRegrowthMobKey;

    public static WallBiomeDataItem getWallBiomeDataItem(String key) {
        String iKey = key;
        int dbg = 3;
        if (wallBiomeDataHashtable.isEmpty()) {
            WallBiomeDataManager.wallBiomeDataInit();
        }
        WallBiomeDataItem r = wallBiomeDataHashtable.get(iKey);
        return r;
    }

    public static String getWallBiomeDataHashAsString() {
        String returnString = "";
        for (String key : wallBiomeDataHashtable.keySet()) {
            int wallSize = WallBiomeDataManager.wallBiomeDataHashtable.get((Object)key).wallSize;
            BlockState wallTypeBlockState = wallBiomeDataHashtable.get(key).getWallBlockState();
            String tempString = key + "," + wallSize + "," + wallTypeBlockState.toString() + ";";
            returnString = returnString + tempString;
        }
        return returnString;
    }

    public static void wallBiomeDataInit() {
        ArrayList<String> dTL6464 = new ArrayList<String>();
        Collection wallsCollection = BlockTags.field_219757_z.func_199885_a();
        ArrayList walls = new ArrayList(wallsCollection);
        Collection fencesCollection = BlockTags.field_219748_G.func_199885_a();
        ArrayList fences = new ArrayList(fencesCollection);
        int i = 0;
        String wallBiomeDataLine6464 = "";
        StringTokenizer st6464 = new StringTokenizer(MyConfig.defaultWallBiomeData6464, ";");
        while (st6464.hasMoreElements()) {
            wallBiomeDataLine6464 = st6464.nextToken().trim();
            if (wallBiomeDataLine6464.isEmpty()) continue;
            dTL6464.add(wallBiomeDataLine6464);
            ++i;
        }
        MyConfig.defaultWallBiomeData = dTL6464.toArray(new String[i]);
        wallBiomeDataHashtable.clear();
        for (i = 0; i < MyConfig.defaultWallBiomeData.length; ++i) {
            try {
                String modAndBiome;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultWallBiomeData[i], ",");
                String key = modAndBiome = st.nextToken();
                String wallSizeString = st.nextToken();
                String wallBlockString = st.nextToken();
                String fenceBlockString = st.nextToken();
                int wallSize = Integer.parseInt(wallSizeString.trim());
                if (wallSize <= 32) {
                    wallSize = 32;
                }
                if (wallSize > 80) {
                    wallSize = 80;
                }
                BlockState wallBlockState = null;
                for (int v = 0; v < walls.size(); ++v) {
                    String wbs = ((Block)walls.get(v)).getBlock().getRegistryName().toString();
                    if (!wbs.equals(wallBlockString)) continue;
                    wallBlockState = ((Block)walls.get(v)).getBlock().func_176223_P();
                    break;
                }
                if (wallBlockState == null) {
                    wallBlockState = Blocks.field_150463_bK.func_176223_P();
                }
                BlockState fenceBlockState = null;
                for (int v = 0; v < fences.size(); ++v) {
                    String fbs = ((Block)fences.get(v)).getBlock().getRegistryName().toString();
                    if (!fbs.equals(fenceBlockString)) continue;
                    fenceBlockState = ((Block)walls.get(v)).getBlock().func_176223_P();
                    break;
                }
                if (fenceBlockState == null) {
                    fenceBlockState = Blocks.field_180407_aO.func_176223_P();
                }
                wallBiomeDataHashtable.put(key, new WallBiomeDataItem(wallSize, wallBlockState, fenceBlockState));
                if (modAndBiome.contentEquals("Regrowth:default") || modAndBiome.contentEquals("Regrowth:minimum") || modAndBiome.contentEquals("minecraft:icy") || ForgeRegistries.BIOMES.containsKey(new ResourceLocation(modAndBiome))) continue;
                System.out.println("Regrowth Debug: Wall Biome Data: " + wallBlockString + " not in Forge Entity Type Registry.  Mispelled?");
                continue;
            }
            catch (Exception e) {
                System.out.println("Regrowth Debug:  Bad Wall Biome Data Config : " + MyConfig.defaultWallBiomeData[i]);
            }
        }
        int breakpoint2 = 3;
    }

    static {
        defaultRegrowthMobKey = defaultRegrowthMobString = "regrowth:default";
    }

    public static class WallBiomeDataItem {
        int wallSize;
        BlockState wallBlockState;
        BlockState fenceBlockState;

        public WallBiomeDataItem(int wallSize, BlockState wallBlockState, BlockState fenceBlockState) {
            this.wallSize = wallSize;
            this.wallBlockState = wallBlockState;
            this.fenceBlockState = fenceBlockState;
        }

        public int getWallSize() {
            return this.wallSize;
        }

        public BlockState getWallBlockState() {
            return this.wallBlockState;
        }

        public BlockState getFenceBlockState() {
            return this.fenceBlockState;
        }
    }
}

