/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.events;

import com.mactso.regrowth.config.MyConfig;
import com.mactso.regrowth.config.RegrowthEntitiesManager;
import com.mactso.regrowth.config.WallBiomeDataManager;
import com.mactso.regrowth.config.WallFoundationDataManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class MoveEntityEvent {
    static int[] dx = new int[]{1, 0, -1, 0};
    static int[] dz = new int[]{0, 1, 0, -1};
    static int TICKS_PER_SECOND = 20;
    static int[][] facingArray = new int[][]{{0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}};
    static int lastTorchX = 0;
    static int lastTorchY = 0;
    static int lastTorchZ = 0;
    static final int WALL_CENTER = 0;
    static final int WALL_TYPE_WALL = -1;
    static final int WALL_TYPE_FENCE = -2;

    @SubscribeEvent
    public void doEntityMove(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        Entity eventEntity = event.getEntity();
        World world = eventEntity.field_70170_p;
        if (world == null) {
            return;
        }
        if (!(world instanceof ServerWorld)) {
            return;
        }
        Block footBlock = world.func_180495_p(eventEntity.func_180425_c()).func_177230_c();
        if (footBlock == null) {
            return;
        }
        Block groundBlock = footBlock == Blocks.field_185774_da ? footBlock : world.func_180495_p(eventEntity.func_180425_c().func_177977_b()).func_177230_c();
        if (groundBlock == null) {
            return;
        }
        BlockPos eventEntityPos = eventEntity.func_180425_c();
        int eventEntityX = eventEntityPos.func_177958_n();
        int eventEntityY = eventEntityPos.func_177956_o();
        int eventEntityZ = eventEntityPos.func_177952_p();
        Biome localBiome = world.func_226691_t_(eventEntityPos);
        EntityType tempType = eventEntity.func_200600_R();
        ResourceLocation registryName = tempType.getRegistryName();
        String registryNameAsString = registryName.toString();
        RegrowthEntitiesManager.RegrowthMobItem currentRegrowthMobItem = RegrowthEntitiesManager.getRegrowthMobInfo(registryNameAsString);
        if (currentRegrowthMobItem == null) {
            return;
        }
        String regrowthActions = currentRegrowthMobItem.getRegrowthType();
        if (this.isImpossibleRegrowthEvent(footBlock, regrowthActions)) {
            return;
        }
        double regrowthEventOdds = 2.0 / currentRegrowthMobItem.getRegrowthEventSeconds() * (double)TICKS_PER_SECOND;
        double randomD100Roll = world.field_73012_v.nextDouble() * 100.0;
        if (randomD100Roll <= regrowthEventOdds) {
            if (eventEntity instanceof VillagerEntity) {
                VillagerEntity ve = (VillagerEntity)eventEntity;
                if (ve.field_70122_E) {
                    if (footBlock == Blocks.field_150433_aE) {
                        footBlock = Blocks.field_150350_a;
                    }
                    this.doVillagerRegrowthEvents(ve, footBlock, groundBlock, registryNameAsString, regrowthActions, eventEntityX, eventEntityY, eventEntityZ, world, localBiome);
                }
            }
        } else {
            this.doMobRegrowthEvents(eventEntity, footBlock, groundBlock, registryNameAsString, regrowthActions, regrowthEventOdds, randomD100Roll, eventEntityX, eventEntityY, eventEntityZ, world);
        }
        boolean debugBreakPoint = false;
    }

    private void doMobRegrowthEvents(Entity eventEntity, Block footBlock, Block groundBlock, String key, String regrowthActions, double regrowthEventOdds, double randomD100Roll, int eX, int eY, int eZ, World world) {
        if (groundBlock != Blocks.field_196658_i) {
            return;
        }
        if (regrowthActions.equals("tall") && randomD100Roll <= regrowthEventOdds) {
            this.entityGrowTallGrassToDoubleGrass(eventEntity, footBlock, regrowthActions);
            if (MyConfig.aDebugLevel > 0) {
                System.out.println(key + " tall at " + eX + ", " + eY + ", " + eZ + ".");
            }
            return;
        }
        double eatingOdds = regrowthEventOdds;
        if (regrowthActions.contentEquals("eat") || regrowthActions.contentEquals("both")) {
            if (regrowthActions.contentEquals("both")) {
                eatingOdds = regrowthEventOdds * 15.0;
            }
            if (eventEntity instanceof AbstractHorseEntity) {
                AbstractHorseEntity h = (AbstractHorseEntity)eventEntity;
                BlockPos debugPos = h.func_180425_c();
                eatingOdds = !h.func_110204_cc() ? 0.0 : regrowthEventOdds * 25.0;
            }
            if (randomD100Roll <= eatingOdds) {
                if (MyConfig.aDebugLevel > 1) {
                    System.out.println(key + " trying to eat at " + eX + ", " + eY + ", " + eZ + ".");
                }
                if (this.entityEatGrassOrFlower(eventEntity, new BlockPos(eX, eY, eZ), regrowthActions, footBlock, groundBlock) && MyConfig.aDebugLevel > 0) {
                    System.out.println(key + " eat at " + eX + ", " + eY + ", " + eZ + ".");
                }
                return;
            }
        }
        randomD100Roll = eventEntity.field_70170_p.field_73012_v.nextDouble() * 100.0;
        if ((regrowthActions.equals("grow") || regrowthActions.equals("both")) && randomD100Roll <= regrowthEventOdds && footBlock instanceof AirBlock) {
            IGrowable ib = (IGrowable)groundBlock;
            if (ib == null) {
                return;
            }
            if (MyConfig.aDebugLevel > 1) {
                System.out.println(key + " trying to grow at " + eX + ", " + eY + ", " + eZ + ".");
            }
            ib.func_225535_a_((ServerWorld)world, world.field_73012_v, eventEntity.func_180425_c(), eventEntity.field_70170_p.func_180495_p(eventEntity.func_180425_c()));
            if (MyConfig.aDebugLevel > 0) {
                System.out.println(key + " grow at " + eX + ", " + eY + ", " + eZ + ".");
            }
            return;
        }
    }

    private void doVillagerRegrowthEvents(VillagerEntity ve, Block footBlock, Block groundBlock, String key, String regrowthType, int veX, int veY, int veZ, World world, Biome localBiome) {
        if (!ve.field_70122_E) {
            return;
        }
        if (MyConfig.aDebugLevel > 0) {
            StringTextComponent tName = new StringTextComponent("");
            float veYaw = ve.func_195046_g(1.0f);
            tName = new StringTextComponent("Reg-" + veX + "," + veZ + ": " + veYaw);
            ve.func_200203_b((ITextComponent)tName);
        } else if (ve.func_200201_e() != null && ve.func_200201_e().toString().contains("Reg-")) {
            ve.func_200203_b(null);
        }
        if (this.improveFarm(ve, groundBlock, footBlock, regrowthType, veX, veY, veZ) && MyConfig.aDebugLevel > 0) {
            System.out.println(key + " farm improved at " + veX + ", " + veY + ", " + veZ + ", ");
        }
        if (regrowthType.contains("v")) {
            this.improveLeaves(ve, groundBlock, key, veX, veY, veZ);
        }
        if (regrowthType.contains("c") && (footBlock instanceof TallGrassBlock || footBlock instanceof DoublePlantBlock)) {
            ve.field_70170_p.func_175655_b(ve.func_180425_c(), false);
            if (MyConfig.aDebugLevel > 0) {
                System.out.println(key + " cut at " + veX + ", " + veY + ", " + veZ + ".");
            }
        }
        if (regrowthType.contains("r")) {
            this.improveRoads(ve, footBlock, groundBlock, key, localBiome);
        }
        if (regrowthType.contains("w") || regrowthType.contains("p")) {
            this.improveWalls(ve, footBlock, groundBlock, key, regrowthType, veX, veY, veZ, localBiome);
            if (footBlock instanceof WallBlock || footBlock instanceof FenceBlock) {
                float veYaw = ve.func_195046_g(1.0f) / 45.0f;
                int facingNdx = Math.round(veYaw);
                if (facingNdx < 0) {
                    facingNdx = Math.abs(facingNdx);
                }
                double dx = (double)facingArray[facingNdx %= 8][0] / 2.0;
                double dz = (double)facingArray[facingNdx][1] / 2.0;
                ve.func_213293_j(dx, 0.55, dz);
            }
        }
        if (regrowthType.contains("t") && footBlock != Blocks.field_150478_aa && this.improveLighting(ve, footBlock, groundBlock, veX, veY, veZ) && MyConfig.aDebugLevel > 0) {
            System.out.println(key + "- " + footBlock + ", " + groundBlock + " pitch: " + ve.field_70125_A + " improve lighting at " + ve.func_226277_ct_() + ", " + ve.func_226278_cu_() + ", " + ve.func_226281_cx_());
        }
    }

    private void improveLeaves(VillagerEntity ve, Block groundBlock, String key, int veX, int veY, int veZ) {
        float veYaw = ve.func_195046_g(1.0f) / 45.0f;
        int facingNdx = Math.round(veYaw);
        if (facingNdx < 0) {
            facingNdx = Math.abs(facingNdx);
        }
        facingNdx %= 8;
        if (groundBlock == Blocks.field_185774_da) {
            ++veY;
        }
        int dx = facingArray[facingNdx][0];
        int dz = facingArray[facingNdx][1];
        BlockPos tmpBP = null;
        BlockState tempBS = null;
        Block tempBlock = null;
        boolean destroyBlock = false;
        for (int iY = 0; iY < 2; ++iY) {
            boolean persistantLeaves;
            tmpBP = new BlockPos(veX + dx, veY + iY, veZ + dz);
            tempBS = ve.field_70170_p.func_180495_p(tmpBP);
            tempBlock = tempBS.func_177230_c();
            if (tempBlock instanceof LeavesBlock && !(persistantLeaves = ((Boolean)tempBS.func_177229_b((IProperty)LeavesBlock.field_208495_b)).booleanValue())) {
                destroyBlock = true;
            }
            if (tempBlock instanceof CactusBlock) {
                destroyBlock = true;
            }
            if (!destroyBlock) continue;
            ve.field_70170_p.func_175655_b(tmpBP, false);
            destroyBlock = false;
            if (MyConfig.aDebugLevel <= 0) continue;
            System.out.println(key + " clear " + tempBlock.func_149739_a().toString() + " at" + veX + ", " + veY + iY + ", " + veZ + ", ");
        }
    }

    private boolean entityEatGrassOrFlower(Entity eventEntity, BlockPos eventEntityPos, String regrowthType, Block footBlock, Block groundBlock) {
        AgeableEntity ae;
        if (!this.isGrassOrFlower(footBlock)) {
            return false;
        }
        if (!regrowthType.equals("eat") && !regrowthType.equals("both")) {
            return false;
        }
        eventEntity.field_70170_p.func_175655_b(eventEntity.func_180425_c(), false);
        double randomD100Roll = eventEntity.field_70170_p.field_73012_v.nextDouble() * 100.0;
        if (randomD100Roll > 40.0 && groundBlock instanceof GrassBlock) {
            eventEntity.field_70170_p.func_175656_a(eventEntityPos.func_177977_b(), Blocks.field_150346_d.func_176223_P());
            int evX = eventEntityPos.func_177958_n();
            int evY = eventEntityPos.func_177956_o();
            int evZ = eventEntityPos.func_177952_p();
            int dirtCount = 0;
            for (int i = 0; i < 4; ++i) {
                Block tempBlock = eventEntity.field_70170_p.func_180495_p(new BlockPos(evX + dx[i], evY, evZ + dz[i])).func_177230_c();
                if (tempBlock != Blocks.field_185774_da && tempBlock != Blocks.field_150346_d) continue;
                ++dirtCount;
            }
            if (dirtCount == 4) {
                eventEntity.field_70170_p.func_175656_a(new BlockPos(evX, evY, evZ), Blocks.field_185774_da.func_176223_P());
            }
        }
        LivingEntity le = (LivingEntity)eventEntity;
        if (eventEntity instanceof AgeableEntity && (ae = (AgeableEntity)eventEntity).func_70631_g_()) {
            ae.func_70873_a(ae.func_70874_b() + 30);
        }
        if (le.func_110138_aP() > le.func_110143_aJ() && MyConfig.aEatingHeals == 1.0) {
            EffectInstance ei = new EffectInstance(Effects.field_76432_h, 1, 0, false, true);
            le.func_195064_c(ei);
        }
        return true;
    }

    private boolean entityGrowTallGrassToDoubleGrass(Entity eventEntity, Block footBlock, String regrowthType) {
        if (footBlock instanceof TallGrassBlock) {
            IGrowable ib = (IGrowable)footBlock;
            ib.func_225535_a_((ServerWorld)eventEntity.field_70170_p, eventEntity.field_70170_p.field_73012_v, eventEntity.func_180425_c(), eventEntity.field_70170_p.func_180495_p(eventEntity.func_180425_c()));
            return true;
        }
        return false;
    }

    private BlockState getBiomeRoadBlockType(Biome localBiome) {
        BlockState gateBlockType = Blocks.field_185774_da.func_176223_P();
        if (localBiome.func_201856_r() == Biome.Category.DESERT) {
            gateBlockType = Blocks.field_196580_bH.func_176223_P();
        }
        return gateBlockType;
    }

    private int getBiomeWallPerimeterValue(Biome localBiome) {
        int wallPerimeter = 31;
        if (localBiome.func_201856_r() == Biome.Category.DESERT) {
            wallPerimeter = 23;
        }
        if (localBiome.func_201856_r() == Biome.Category.TAIGA) {
            wallPerimeter = 23;
        }
        return wallPerimeter;
    }

    private boolean improveFarm(VillagerEntity ve, Block groundBlock, Block footBlock, String regrowthType, int veX, int veY, int veZ) {
        boolean nextToFarmBlock = false;
        boolean nextToWaterBlock = false;
        boolean torchExploit = false;
        if (ve.func_213700_eh().func_221130_b() == VillagerProfession.field_221156_f) {
            Block tempBlock;
            int i;
            if (lastTorchX == veX && lastTorchY == veY && lastTorchZ == veZ) {
                torchExploit = true;
            }
            for (i = 0; i < 4; ++i) {
                tempBlock = ve.field_70170_p.func_180495_p(new BlockPos(veX + dx[i], veY - 1, veZ + dz[i])).func_177230_c();
                if (tempBlock != Blocks.field_150458_ak) continue;
                nextToFarmBlock = true;
                i = 4;
            }
            for (i = 0; i < 4; ++i) {
                tempBlock = ve.field_70170_p.func_180495_p(new BlockPos(veX + dx[i], veY - 1, veZ + dz[i])).func_177230_c();
                if (tempBlock != Blocks.field_150355_j) continue;
                nextToWaterBlock = true;
                i = 4;
            }
            if (groundBlock instanceof LogBlock && nextToWaterBlock && regrowthType.contains("t") && footBlock == Blocks.field_150350_a && !torchExploit) {
                ve.field_70170_p.func_175656_a(ve.func_180425_c(), Blocks.field_150478_aa.func_176223_P());
                lastTorchX = veX;
                lastTorchY = veY;
                lastTorchZ = veZ;
            }
            if (nextToFarmBlock) {
                if (groundBlock == Blocks.field_196580_bH && regrowthType.contains("t")) {
                    ve.field_70170_p.func_175656_a(ve.func_180425_c(), Blocks.field_150478_aa.func_176223_P());
                    lastTorchX = veX;
                    lastTorchY = veY;
                    lastTorchZ = veZ;
                }
                if (groundBlock instanceof GrassBlock) {
                    ve.field_70170_p.func_175656_a(ve.func_180425_c().func_177977_b(), Blocks.field_150458_ak.func_176223_P());
                    return true;
                }
            }
        }
        return false;
    }

    private boolean improveLighting(VillagerEntity ve, Block footBlock, Block groundBlock, int veX, int veY, int veZ) {
        int blockLightValue = ve.field_70170_p.func_226658_a_(LightType.BLOCK, ve.func_180425_c());
        int skyLightValue = ve.field_70170_p.func_226658_a_(LightType.SKY, ve.func_180425_c());
        if (blockLightValue > 8) {
            return false;
        }
        if (skyLightValue > 13) {
            return false;
        }
        if (ve.func_70608_bn()) {
            return false;
        }
        if (footBlock instanceof BedBlock) {
            return false;
        }
        ve.field_70170_p.func_175656_a(ve.func_180425_c(), Blocks.field_150478_aa.func_176223_P());
        return true;
    }

    private void improveRoads(VillagerEntity ve, Block footBlock, Block groundBlock, String key, Biome localBiome) {
        int veZ;
        int veY;
        BlockPos vePos = ve.func_180425_c();
        int veX = vePos.func_177958_n();
        if (this.improveRoadsFixUnfinished(ve, groundBlock, veX, veY = vePos.func_177956_o(), veZ = vePos.func_177952_p(), localBiome) && MyConfig.aDebugLevel > 0) {
            System.out.println(key + " fix road " + veX + ", " + veY + ", " + veZ + ". ");
        }
        if (this.improveRoadsSmoothHeight(ve, footBlock, groundBlock, veX, veY, veZ, localBiome) && MyConfig.aDebugLevel > 0) {
            System.out.println(key + " smooth road slope" + veX + ", " + veY + ", " + veZ + ", ");
        }
    }

    private boolean improveRoadsFixUnfinished(VillagerEntity ve, Block groundBlock, int veX, int veY, int veZ, Biome localBiome) {
        Block biomeRoadBlock;
        int fixHeight = 3;
        if (Biome.Category.TAIGA == localBiome.func_201856_r()) {
            fixHeight = 5;
        }
        if (groundBlock != (biomeRoadBlock = this.getBiomeRoadBlockType(localBiome).func_177230_c())) {
            int roadBlockCount = 0;
            for (int dy = -1; dy <= fixHeight; ++dy) {
                for (int i = 0; i < 4; ++i) {
                    Block tempBlock = ve.field_70170_p.func_180495_p(new BlockPos(veX + dx[i], veY + dy, veZ + dz[i])).func_177230_c();
                    if (tempBlock != biomeRoadBlock || ++roadBlockCount <= 2) continue;
                    ve.field_70170_p.func_175656_a(ve.func_180425_c().func_177977_b(), biomeRoadBlock.func_176223_P());
                    return true;
                }
            }
        }
        return false;
    }

    private boolean improveRoadsSmoothHeight(VillagerEntity ve, Block footBlock, Block groundBlock, int veX, int veY, int veZ, Biome localBiome) {
        int skyLightValue = ve.field_70170_p.func_226658_a_(LightType.SKY, ve.func_180425_c());
        if (skyLightValue < 14) {
            return false;
        }
        Block biomeRoadBlock = this.getBiomeRoadBlockType(localBiome).func_177230_c();
        if (groundBlock != biomeRoadBlock && footBlock != biomeRoadBlock) {
            return false;
        }
        BlockState smoothingBlockState = biomeRoadBlock.func_176223_P();
        Block smoothingBlock = biomeRoadBlock;
        for (int dy = 2; dy < 6; ++dy) {
            for (int i = 0; i < 4; ++i) {
                Block tempBlock = ve.field_70170_p.func_180495_p(new BlockPos(veX + dx[i], veY + dy, veZ + dz[i])).func_177230_c();
                if (tempBlock != smoothingBlock) continue;
                ve.field_70170_p.func_175656_a(new BlockPos(veX, veY + 1, veZ), smoothingBlockState);
                ve.func_213293_j(0.0, 0.4, 0.0);
                return true;
            }
        }
        return false;
    }

    private boolean improveWallForMeetingPlace(VillagerEntity ve, String regrowthActions, BlockPos villageMeetingPlaceBlockPos, Block groundBlock, Block footBlock, Biome localBiome) {
        int absvz;
        int absvx;
        int wallPerimeter;
        String key = "minecraft:" + localBiome.func_201856_r().toString();
        ResourceLocation biomeName = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)localBiome);
        key = key.toLowerCase();
        int dbg = 3;
        WallBiomeDataManager.WallBiomeDataItem currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem(key);
        if (MyConfig.aDebugLevel == 1) {
            System.out.println("111 WallbiomeData Key:" + key + " at " + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
        }
        if (currentWallBiomeDataItem == null) {
            if (MyConfig.aDebugLevel == 2) {
                System.out.println("222 WallbiomeData was null at " + (int)ve.func_226277_ct_() + ":, " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
            }
            if ((currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem(key = "minecraft:" + localBiome.func_201856_r().toString().toLowerCase())) == null) {
                currentWallBiomeDataItem = WallBiomeDataManager.getWallBiomeDataItem("minecraft:plains");
            }
        }
        if ((wallPerimeter = currentWallBiomeDataItem.getWallSize()) < 32) {
            wallPerimeter = 32;
        }
        if (wallPerimeter > 80) {
            wallPerimeter = 80;
        }
        if (this.isOnWallPerimeter(wallPerimeter = wallPerimeter / 2 - 1, absvx = (int)Math.abs(ve.func_226277_ct_() - (double)villageMeetingPlaceBlockPos.func_177958_n()), absvz = (int)Math.abs(ve.func_226281_cx_() - (double)villageMeetingPlaceBlockPos.func_177952_p()))) {
            if (MyConfig.aDebugLevel > 1) {
                System.out.println("222: Villager on wall perimeter " + wallPerimeter + " at" + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
            }
            Collection result = ((ServerWorld)ve.field_70170_p).func_217443_B().func_226353_b_(t -> t == PointOfInterestType.field_221070_r, ve.func_180425_c(), 41, PointOfInterestManager.Status.ANY).collect(Collectors.toCollection(ArrayList::new));
            boolean buildWall = true;
            if (!result.isEmpty()) {
                for (PointOfInterest P : result) {
                    if (villageMeetingPlaceBlockPos.func_177958_n() == P.func_218261_f().func_177958_n() && villageMeetingPlaceBlockPos.func_177956_o() == P.func_218261_f().func_177956_o() && villageMeetingPlaceBlockPos.func_177952_p() == P.func_218261_f().func_177952_p()) continue;
                    int disX = Math.abs(ve.func_180425_c().func_177958_n() - P.func_218261_f().func_177958_n());
                    int disZ = Math.abs(ve.func_180425_c().func_177952_p() - P.func_218261_f().func_177952_p());
                    if (disX < wallPerimeter && disZ < wallPerimeter) {
                        buildWall = false;
                        break;
                    }
                    System.out.println(P.func_218260_g().toString() + " " + P.func_218261_f().toString());
                }
            } else if (result.isEmpty()) {
                buildWall = true;
                if (MyConfig.aDebugLevel > 1) {
                    System.out.println("222: No extra meeting places found by villager on wall perimeter at" + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
                }
            }
            if (buildWall) {
                BlockState wallTypeBlockState = currentWallBiomeDataItem.getWallBlockState();
                if (wallTypeBlockState == null) {
                    wallTypeBlockState = Blocks.field_150463_bK.func_176223_P();
                }
                BlockState wallBlock = wallTypeBlockState;
                BlockState gateBlockType = this.getBiomeRoadBlockType(localBiome);
                if (MyConfig.aDebugLevel > 1) {
                    System.out.println("222: wallBlock (" + wallTypeBlockState.func_177230_c().getRegistryName().toString() + ") at" + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
                }
                int wallTorchSpacing = (wallPerimeter + 1) / 4;
                boolean wallCenter = false;
                boolean buildCenterGate = true;
                if (this.placeOneWallPiece(ve, regrowthActions, wallPerimeter, wallTorchSpacing, gateBlockType, buildCenterGate, wallBlock, absvx, absvz, groundBlock, footBlock)) {
                    if (MyConfig.aDebugLevel > 1) {
                        System.out.println("222: wall built at" + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
                    }
                    if (regrowthActions.contains("t") && this.isValidTorchLocation(wallPerimeter, wallTorchSpacing, absvx, absvz, ve.field_70170_p.func_180495_p(ve.func_180425_c()).func_177230_c())) {
                        ve.field_70170_p.func_175656_a(ve.func_180425_c().func_177984_a(), Blocks.field_150478_aa.func_176223_P());
                    }
                    return true;
                }
                if (MyConfig.aDebugLevel > 1) {
                    System.out.println("222: wall NOT built at" + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
                }
            }
        }
        return false;
    }

    private boolean improveWallForPersonalHome(VillagerEntity ve, BlockPos vHomePos, String regrowthAction, Block groundBlock, Block footBlock, Biome localBiome) {
        boolean buildCenterGate;
        int absvz;
        int wallPerimeter = 5;
        boolean wallCenter = false;
        BlockState wallBlock = this.getBiomeWallBlock(localBiome, -2);
        BlockState gateBlockType = this.getBiomeRoadBlockType(localBiome);
        if (localBiome.func_201856_r() == Biome.Category.DESERT) {
            wallPerimeter += 2;
        }
        int wallTorchSpacing = wallPerimeter + 0;
        int absvx = (int)Math.abs(ve.func_226277_ct_() - (double)vHomePos.func_177958_n());
        if (this.isOnWallPerimeter(wallPerimeter, absvx, absvz = (int)Math.abs(ve.func_226281_cx_() - (double)vHomePos.func_177952_p())) && this.placeOneWallPiece(ve, regrowthAction, wallPerimeter, wallTorchSpacing, gateBlockType, buildCenterGate = true, wallBlock, absvx, absvz, groundBlock, footBlock)) {
            if (regrowthAction.contains("t") && this.isValidTorchLocation(wallPerimeter, wallTorchSpacing, absvx, absvz, groundBlock)) {
                ve.field_70170_p.func_175656_a(ve.func_180425_c().func_177984_a(), Blocks.field_150478_aa.func_176223_P());
            }
            return true;
        }
        return false;
    }

    private void improveWalls(VillagerEntity ve, Block footBlock, Block groundBlock, String key, String regrowthActions, int veX, int veY, int veZ, Biome localBiome) {
        Brain vb = ve.func_213375_cj();
        Optional vMeetingPlace = vb.func_218207_c(MemoryModuleType.field_220943_d);
        if (this.isOkayToBuildWallHere(ve, footBlock, groundBlock, vMeetingPlace, veX, veY, veZ)) {
            Optional villagerHome;
            GlobalPos gVMP = (GlobalPos)vMeetingPlace.get();
            BlockPos villageMeetingPlaceBlockPos = gVMP.func_218180_b();
            if (regrowthActions.contains("w") && this.improveWallForMeetingPlace(ve, regrowthActions, villageMeetingPlaceBlockPos, groundBlock, footBlock, localBiome) && MyConfig.aDebugLevel > 1) {
                System.out.println(key + "222 Meeting Place improved wall at " + veX + ", " + veY + ", " + veZ + ".");
            }
            if (regrowthActions.contains("p") && (villagerHome = vb.func_218207_c(MemoryModuleType.field_220941_b)).isPresent()) {
                GlobalPos gVHP = (GlobalPos)villagerHome.get();
                BlockPos villagerHomePos = gVHP.func_218180_b();
                if (this.isOutsideMeetingPlaceWall(ve, vMeetingPlace, ((GlobalPos)vMeetingPlace.get()).func_218180_b(), veX, veY, veZ) && this.improveWallForPersonalHome(ve, villagerHomePos, regrowthActions, groundBlock, footBlock, localBiome) && MyConfig.aDebugLevel > 0) {
                    System.out.println(key + " personal wall at " + veX + ", " + veY + ", " + veZ + ".");
                }
            }
        }
    }

    private boolean isFootBlockOkayToBuildIn(Block footBlock) {
        return footBlock instanceof AirBlock;
    }

    private boolean isGrassOrFlower(Block footBlock) {
        if (footBlock instanceof TallGrassBlock) {
            return true;
        }
        if (footBlock instanceof FlowerBlock) {
            return true;
        }
        if (footBlock instanceof DoublePlantBlock) {
            return true;
        }
        if (footBlock == Blocks.field_196554_aH) {
            return true;
        }
        return footBlock == Blocks.field_196805_gi;
    }

    private boolean isImpossibleRegrowthEvent(Block footBlock, String regrowthType) {
        if (regrowthType.equals("eat") && footBlock instanceof AirBlock) {
            return true;
        }
        if (regrowthType.equals("grow") && footBlock instanceof TallGrassBlock) {
            return true;
        }
        if (regrowthType.equals("grow") && footBlock instanceof FlowerBlock) {
            return true;
        }
        return regrowthType.equals("tall") && !(footBlock instanceof TallGrassBlock);
    }

    private boolean isOkayToBuildWallHere(VillagerEntity ve, Block footBlock, Block groundBlock, Optional<GlobalPos> vMeetingPlace, int veX, int veY, int veZ) {
        boolean okayToBuildWalls = true;
        if (!vMeetingPlace.isPresent()) {
            okayToBuildWalls = false;
        }
        if (!ve.field_70122_E) {
            okayToBuildWalls = false;
        }
        if (!this.isFootBlockOkayToBuildIn(footBlock)) {
            okayToBuildWalls = false;
        }
        if (!this.isValidGroundBlockToBuildWallOn(ve, groundBlock)) {
            okayToBuildWalls = false;
        }
        return okayToBuildWalls;
    }

    private boolean isOutsideMeetingPlaceWall(VillagerEntity ve, Optional<GlobalPos> vMeetingPlace, BlockPos meetingPlacePos, int veX, int veY, int veZ) {
        int absVMpX = Math.abs(veX - meetingPlacePos.func_177958_n());
        int absVMpZ = Math.abs(veZ - meetingPlacePos.func_177952_p());
        return absVMpX >= 32 || absVMpZ >= 32;
    }

    private boolean isOnWallPerimeter(int wallPerimeter, int absvx, int absvz) {
        boolean scratch = false;
        if (absvx == wallPerimeter && absvz <= wallPerimeter) {
            scratch = true;
        }
        if (absvz == wallPerimeter && absvx <= wallPerimeter) {
            scratch = true;
        }
        if (scratch) {
            System.out.println("isOnWallPerimeter:" + wallPerimeter + " " + absvx + " " + absvz);
        }
        return scratch;
    }

    private boolean isValidGroundBlockToBuildWallOn(VillagerEntity ve, Block groundBlock) {
        int blockSkyLightValue = ve.field_70170_p.func_226658_a_(LightType.SKY, ve.func_180425_c());
        if (blockSkyLightValue < 13) {
            return false;
        }
        String key = groundBlock.getRegistryName().toString();
        WallFoundationDataManager.wallFoundationItem currentWallFoundationItem = WallFoundationDataManager.getWallFoundationInfo(key);
        return currentWallFoundationItem != null;
    }

    private boolean isValidTorchLocation(int wallPerimeter, int wallTorchSpacing, int absvx, int absvz, Block wallFenceBlock) {
        boolean hasAWallUnderIt = false;
        if (wallFenceBlock instanceof WallBlock) {
            hasAWallUnderIt = true;
        }
        if (wallFenceBlock instanceof FenceBlock) {
            hasAWallUnderIt = true;
        }
        if (!hasAWallUnderIt) {
            return false;
        }
        if (absvx == wallPerimeter && absvz % wallTorchSpacing == 1) {
            return true;
        }
        if (absvx % wallTorchSpacing == 1 && absvz == wallPerimeter) {
            return true;
        }
        return absvx == wallPerimeter && absvz == wallPerimeter;
    }

    private boolean placeOneWallPiece(VillagerEntity ve, String regrowthType, int wallPerimeter, int wallTorchSpacing, BlockState gateBlockType, boolean buildCenterGate, BlockState wallType, int absvx, int absvz, Block groundBlock, Block footBlock) {
        if (MyConfig.aDebugLevel > 1) {
            System.out.println("222: Enter :placeOneWallPiece: " + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
        }
        BlockState bs = ve.field_70170_p.func_180495_p(ve.func_180425_c().func_177977_b());
        Block blockBs = bs.func_177230_c();
        if (MyConfig.aDebugLevel > 1) {
            System.out.println("222: About to Place wall piece: " + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
            System.out.println("222: wallPerimeter:" + wallPerimeter + " absvx:" + absvx + " absvz:" + absvz + " l= " + (int)ve.func_226277_ct_() + " " + (int)ve.func_226278_cu_() + " " + (int)ve.func_226281_cx_() + ".");
        }
        if (absvx == wallPerimeter && absvz <= wallPerimeter) {
            if (MyConfig.aDebugLevel > 1) {
                System.out.println("222: placeOneWallPiece Calling ns Wall Helper absvz : " + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
            }
            return this.placeWallHelper(ve, gateBlockType, buildCenterGate, wallType, absvz);
        }
        if (absvz == wallPerimeter && absvx <= wallPerimeter) {
            if (MyConfig.aDebugLevel > 1) {
                System.out.println("222: placeOneWallPiece Calling ew Wall Helper absvx: " + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
            }
            return this.placeWallHelper(ve, gateBlockType, buildCenterGate, wallType, absvx);
        }
        return false;
    }

    private boolean placeWallHelper(VillagerEntity ve, BlockState gateBlockType, boolean buildCenterGate, BlockState wallType, int absva) {
        BlockState b;
        Block block;
        if (MyConfig.aDebugLevel > 1) {
            System.out.println("222: Enter :placeWallHelper: " + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
        }
        if (absva == 0) {
            if (MyConfig.aDebugLevel > 1) {
                System.out.println("222: Placing gatez at: " + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
            }
            if (buildCenterGate) {
                ve.field_70170_p.func_175656_a(ve.func_180425_c().func_177977_b(), gateBlockType);
                return true;
            }
            return false;
        }
        if (MyConfig.aDebugLevel > 1) {
            System.out.println("222: Wall Helper about to set wallBlock (" + wallType.func_177230_c().getRegistryName().toString() + ") at" + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
        }
        if ((block = (b = ve.field_70170_p.func_180495_p(ve.func_180425_c().func_177977_b())).func_177230_c()) instanceof AirBlock || block instanceof TallGrassBlock || block instanceof FlowerBlock || block instanceof DoublePlantBlock) {
            ve.field_70170_p.func_175656_a(ve.func_180425_c().func_177977_b(), wallType);
            if (MyConfig.aDebugLevel > 1) {
                System.out.println("222: Wall Helper set.down() wallBlock (" + wallType.func_177230_c().getRegistryName().toString() + ") at" + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
            }
        } else {
            ve.field_70170_p.func_175656_a(ve.func_180425_c(), wallType);
            if (MyConfig.aDebugLevel > 1) {
                System.out.println("222: set Wall Helper wallBlock (" + wallType.func_177230_c().getRegistryName().toString() + ") at" + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
            }
        }
        if (MyConfig.aDebugLevel > 1) {
            System.out.println("222: exit true set Wall Helper wallBlock (" + wallType.func_177230_c().getRegistryName().toString() + ") at" + (int)ve.func_226277_ct_() + ", " + (int)ve.func_226278_cu_() + ", " + (int)ve.func_226281_cx_() + ".");
        }
        return true;
    }

    @Deprecated
    private BlockState getBiomeWallBlock(Biome localBiome, int wallType) {
        if (wallType == -1) {
            BlockState wallBlock = Blocks.field_150463_bK.func_176223_P();
            if (localBiome.func_201856_r() == Biome.Category.DESERT) {
                wallBlock = Blocks.field_222417_lF.func_176223_P();
            }
            if (localBiome.func_201856_r() == Biome.Category.TAIGA) {
                wallBlock = Blocks.field_196723_eg.func_176223_P();
            }
            return wallBlock;
        }
        if (wallType == -2) {
            BlockState wallBlock = Blocks.field_180407_aO.func_176223_P();
            if (localBiome.func_201856_r() == Biome.Category.DESERT) {
                wallBlock = Blocks.field_180405_aT.func_176223_P();
            }
            if (localBiome.func_201856_r() == Biome.Category.TAIGA) {
                wallBlock = Blocks.field_180408_aP.func_176223_P();
            }
            return wallBlock;
        }
        BlockState wallBlock = Blocks.field_180407_aO.func_176223_P();
        return wallBlock;
    }
}

