/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.RegrowthEntitiesManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="regrowth", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static int aDebugLevel;
    public static double aEatingHeals;
    public static String[] defaultRegrowthMobs;
    public static String defaultRegrowthMobs6464;
    public static String[] defaultWallFoundations;
    public static String defaultWallFoundations6464;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == SERVER_SPEC) {
            MyConfig.bakeConfig();
            RegrowthEntitiesManager.regrowthMobInit();
        }
    }

    public static void pushDebugLevel() {
        MyConfig.SERVER.debugLevel.set((Object)aDebugLevel);
    }

    public static void pushValues() {
        MyConfig.SERVER.defaultRegrowthMobsActual.set((Object)RegrowthEntitiesManager.getRegrowthHashAsString());
        MyConfig.SERVER.defaultRegrowthMobsActual.set((Object)RegrowthEntitiesManager.getRegrowthHashAsString());
    }

    public static void bakeConfig() {
        aDebugLevel = (Integer)MyConfig.SERVER.debugLevel.get();
        aEatingHeals = (Double)MyConfig.SERVER.eatingHeals.get();
        defaultRegrowthMobs6464 = (String)MyConfig.SERVER.defaultRegrowthMobsActual.get();
        defaultWallFoundations6464 = (String)MyConfig.SERVER.defaultWallFoundationsActual.get();
        if (aDebugLevel > 0) {
            System.out.println("Regrowth Debug Level: " + aDebugLevel);
        }
    }

    public static void sendChat(PlayerEntity p, String chatMessage, Color color) {
        StringTextComponent component = new StringTextComponent(chatMessage);
        component.func_150256_b().func_240718_a_(color);
        p.func_145747_a((ITextComponent)component, p.func_110124_au());
    }

    public static void sendBoldChat(PlayerEntity p, String chatMessage, Color color) {
        StringTextComponent component = new StringTextComponent(chatMessage);
        component.func_150256_b().func_240713_a_(Boolean.valueOf(true));
        component.func_150256_b().func_240718_a_(color);
        p.func_145747_a((ITextComponent)component, p.func_110124_au());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.DoubleValue eatingHeals;
        public final ForgeConfigSpec.ConfigValue<String> defaultRegrowthMobsActual;
        public final String defaultRegrowthMobs6464 = "minecraft:cow,both,240.0;minecraft:horse,eat,360.0;minecraft:donkey,eat,360.0;minecraft:sheep,eat,240.0;minecraft:pig,grow,800.0;minecraft:bee,grow,1000.0;minecraft:chicken,grow,600.0;minecraft:villager,crwlvt,5.0;minecraft:creeper,tall,60.0";
        public final ForgeConfigSpec.ConfigValue<String> defaultWallFoundationsActual;
        public final String defaultWallFoundations6464 = "minecraft:grass_block;minecraft:sand;minecraft:podzal;minecraft:dirt;minecraft:coarse_dirt";

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Regrowth Control Values");
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("regrowth.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.eatingHeals = builder.comment("Eating Heals: 0-No, 1-yes").translation("regrowth.config.eatingHeals").defineInRange("eatingHeals", () -> 0.99, 0.0, 1.0);
            builder.pop();
            builder.push("Regrowth Mobs 6464");
            this.defaultRegrowthMobsActual = builder.comment("RegrowthMobs String 6464").translation("regrowth.configdefaultRegrowthMobsActual").define("defaultRegrowthMobsActual", (Object)"minecraft:cow,both,240.0;minecraft:horse,eat,360.0;minecraft:donkey,eat,360.0;minecraft:sheep,eat,240.0;minecraft:pig,grow,800.0;minecraft:bee,grow,1000.0;minecraft:chicken,grow,600.0;minecraft:villager,crwlvt,5.0;minecraft:creeper,tall,60.0");
            builder.pop();
            builder.push("Regrowth Mobs 6464");
            this.defaultWallFoundationsActual = builder.comment("WallFoundations String 6464").translation("regrowth.configdefaultWallFoundationsActual").define("defaultWallFoundationsActual", (Object)"minecraft:grass_block;minecraft:sand;minecraft:podzal;minecraft:dirt;minecraft:coarse_dirt");
            builder.pop();
        }
    }
}

