/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.events;

import com.mactso.regrowth.config.MyConfig;
import com.mactso.regrowth.config.RegrowthEntitiesManager;
import com.mactso.regrowth.config.WallFoundationsManager;
import java.util.Optional;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MoveEntityEvent {
    static int[] dx = new int[]{1, 0, -1, 0};
    static int[] dz = new int[]{0, 1, 0, -1};
    static int TICKS_PER_SECOND = 20;
    static int[][] facingArray = new int[][]{{0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}};
    static int lastTorchX = 0;
    static int lastTorchY = 0;
    static int lastTorchZ = 0;

    @SubscribeEvent
    public void doEntityMove(LivingEvent.LivingUpdateEvent event) {
        VillagerEntity ve;
        if (event.getEntity() == null) {
            return;
        }
        Entity eventEntity = event.getEntity();
        World world = eventEntity.field_70170_p;
        if (world == null) {
            return;
        }
        if (!(world instanceof ServerWorld)) {
            return;
        }
        BlockPos debugBlockPos = this.getBlockPos(eventEntity);
        Block footBlock = world.func_180495_p(this.getBlockPos(eventEntity)).func_177230_c();
        if (footBlock == null) {
            return;
        }
        Block groundBlock = footBlock == Blocks.field_185774_da ? footBlock : world.func_180495_p(this.getBlockPos(eventEntity).func_177977_b()).func_177230_c();
        if (groundBlock == null) {
            return;
        }
        BlockPos eventEntityPos = this.getBlockPos(eventEntity);
        int eventEntityX = eventEntityPos.func_177958_n();
        int eventEntityY = eventEntityPos.func_177956_o();
        int eventEntityZ = eventEntityPos.func_177952_p();
        Biome localBiome = world.func_226691_t_(eventEntityPos);
        EntityType tempType = eventEntity.func_200600_R();
        ResourceLocation registryName = tempType.getRegistryName();
        String registryNameAsString = registryName.toString();
        RegrowthEntitiesManager.RegrowthMobItem currentRegrowthMobItem = RegrowthEntitiesManager.getRegrowthMobInfo(registryNameAsString);
        if (currentRegrowthMobItem == null) {
            return;
        }
        String regrowthType = currentRegrowthMobItem.getRegrowthType();
        if (this.isImpossibleRegrowthEvent(footBlock, regrowthType)) {
            return;
        }
        double regrowthEventOdds = 2.0 / currentRegrowthMobItem.getRegrowthEventSeconds() * (double)TICKS_PER_SECOND;
        double randomD100Roll = eventEntity.field_70170_p.field_73012_v.nextDouble() * 100.0;
        if (randomD100Roll <= regrowthEventOdds && eventEntity instanceof VillagerEntity && (ve = (VillagerEntity)eventEntity).func_233570_aj_()) {
            this.doVillagerRegrowthEvents(ve, footBlock, groundBlock, eventEntityPos, registryNameAsString, regrowthType, eventEntityX, eventEntityY, eventEntityZ, world);
        }
        this.doMobRegrowthEvents(eventEntity, footBlock, groundBlock, registryNameAsString, regrowthType, regrowthEventOdds, randomD100Roll, eventEntityX, eventEntityY, eventEntityZ, world);
        boolean debugBreakPoint = false;
    }

    private void doMobRegrowthEvents(Entity eventEntity, Block footBlock, Block groundBlock, String key, String regrowthType, double regrowthEventOdds, double randomD100Roll, int eX, int eY, int eZ, World world) {
        if (groundBlock != Blocks.field_196658_i) {
            return;
        }
        if (regrowthType.equals("tall") && randomD100Roll <= regrowthEventOdds) {
            this.entityGrowTallGrassToDoubleGrass(eventEntity, footBlock, regrowthType);
            if (MyConfig.aDebugLevel > 0) {
                System.out.println(key + " tall at " + eX + ", " + eY + ", " + eZ + ".");
            }
            return;
        }
        if ((regrowthType.equals("grow") || regrowthType.equals("both")) && randomD100Roll <= regrowthEventOdds && footBlock instanceof AirBlock) {
            IGrowable ib = (IGrowable)groundBlock;
            if (ib == null) {
                return;
            }
            if (MyConfig.aDebugLevel > 1) {
                System.out.println(key + " trying to grow plants sat " + eX + ", " + eY + ", " + eZ + ".");
            }
            ib.func_225535_a_((ServerWorld)eventEntity.field_70170_p, eventEntity.field_70170_p.field_73012_v, this.getBlockPos(eventEntity), eventEntity.field_70170_p.func_180495_p(this.getBlockPos(eventEntity)));
            if (MyConfig.aDebugLevel > 0) {
                System.out.println(key + " grow at " + eX + ", " + eY + ", " + eZ + ".");
            }
            return;
        }
        double eatingOdds = regrowthEventOdds;
        if (regrowthType.contentEquals("eat") || regrowthType.contentEquals("both")) {
            if (regrowthType.contentEquals("both")) {
                eatingOdds = regrowthEventOdds * 15.0;
            }
            if (eventEntity instanceof AbstractHorseEntity) {
                AbstractHorseEntity h = (AbstractHorseEntity)eventEntity;
                BlockPos debugPos = this.getBlockPos(eventEntity);
                eatingOdds = !h.func_110204_cc() ? 0.0 : regrowthEventOdds * 25.0;
            }
            if (randomD100Roll <= eatingOdds) {
                if (MyConfig.aDebugLevel > 1) {
                    System.out.println(key + " trying to eat at " + eX + ", " + eY + ", " + eZ + ".");
                }
                if (this.entityEatGrassOrFlower(eventEntity, this.getBlockPos(eventEntity), regrowthType, footBlock, groundBlock) && MyConfig.aDebugLevel > 0) {
                    System.out.println(key + " eat at " + eX + ", " + eY + ", " + eZ + ".");
                }
                return;
            }
        }
    }

    private void doVillagerRegrowthEvents(VillagerEntity ve, Block footBlock, Block groundBlock, BlockPos eventEntityPos, String key, String regrowthType, int veX, int veY, int veZ, World world) {
        if (!this.isOnGround((Entity)ve)) {
            return;
        }
        if (MyConfig.aDebugLevel > 0) {
            StringTextComponent tName = new StringTextComponent("");
            float veYaw = ve.func_195046_g(1.0f);
            tName = new StringTextComponent("Reg-" + veX + "," + veZ + ": " + veYaw);
            ve.func_200203_b((ITextComponent)tName);
        } else if (ve.func_200201_e() != null && ve.func_200201_e().toString().contains("Reg-")) {
            ve.func_200203_b(null);
        }
        if (this.improveFarm(ve, groundBlock, footBlock, regrowthType, veX, veY, veZ) && MyConfig.aDebugLevel > 0) {
            System.out.println(key + " farm improved at " + veX + ", " + veY + ", " + veZ + ", ");
        }
        if (regrowthType.contains("v")) {
            this.improveLeaves(ve, groundBlock, key, veX, veY, veZ);
        }
        if (regrowthType.contains("c") && (footBlock instanceof TallGrassBlock || footBlock instanceof DoublePlantBlock)) {
            ve.field_70170_p.func_175655_b(eventEntityPos, false);
            if (MyConfig.aDebugLevel > 0) {
                System.out.println(key + " cut at " + veX + ", " + veY + ", " + veZ + ".");
            }
        }
        if (regrowthType.contains("r")) {
            this.improveRoads(ve, footBlock, groundBlock, key);
        }
        if (regrowthType.contains("w") || regrowthType.contains("p")) {
            this.improveWalls(ve, footBlock, groundBlock, key, regrowthType, veX, veY, veZ);
            if (footBlock instanceof WallBlock || footBlock instanceof FenceBlock) {
                float veYaw = ve.func_195046_g(1.0f) / 45.0f;
                int facingNdx = Math.round(veYaw);
                if (facingNdx < 0) {
                    facingNdx = Math.abs(facingNdx);
                }
                double dx = (double)facingArray[facingNdx %= 8][0] / 2.0;
                double dz = (double)facingArray[facingNdx][1] / 2.0;
                ve.func_213293_j(dx, 0.55, dz);
            }
        }
        if (regrowthType.contains("t") && footBlock != Blocks.field_150478_aa && this.improveLighting(ve, footBlock, groundBlock, veX, veY, veZ) && MyConfig.aDebugLevel > 0) {
            System.out.println(key + "- " + footBlock + ", " + groundBlock + " pitch: " + ve.field_70125_A + " improve lighting at " + ve.func_226277_ct_() + ", " + ve.func_226278_cu_() + ", " + ve.func_226281_cx_());
        }
    }

    private void improveLeaves(VillagerEntity ve, Block groundBlock, String key, int veX, int veY, int veZ) {
        float veYaw = ve.func_195046_g(1.0f) / 45.0f;
        int facingNdx = Math.round(veYaw);
        if (facingNdx < 0) {
            facingNdx = Math.abs(facingNdx);
        }
        facingNdx %= 8;
        if (groundBlock == Blocks.field_185774_da) {
            ++veY;
        }
        int dx = facingArray[facingNdx][0];
        int dz = facingArray[facingNdx][1];
        BlockPos tmpBP = null;
        BlockState tempBS = null;
        Block tempBlock = null;
        boolean destroyBlock = false;
        for (int iY = 0; iY < 2; ++iY) {
            boolean persistantLeaves;
            tmpBP = new BlockPos(veX + dx, veY + iY, veZ + dz);
            tempBS = ve.field_70170_p.func_180495_p(tmpBP);
            tempBlock = tempBS.func_177230_c();
            if (tempBlock instanceof LeavesBlock && !(persistantLeaves = ((Boolean)tempBS.func_177229_b((Property)LeavesBlock.field_208495_b)).booleanValue())) {
                destroyBlock = true;
            }
            if (tempBlock instanceof CactusBlock) {
                destroyBlock = true;
            }
            if (!destroyBlock) continue;
            ve.field_70170_p.func_175655_b(tmpBP, false);
            destroyBlock = false;
            if (MyConfig.aDebugLevel <= 0) continue;
            System.out.println(key + " clear " + tempBlock.func_149739_a().toString() + " at" + veX + ", " + veY + iY + ", " + veZ + ", ");
        }
    }

    private boolean entityEatGrassOrFlower(Entity eventEntity, BlockPos eventEntityPos, String regrowthType, Block footBlock, Block groundBlock) {
        AgeableEntity ae;
        if (!this.isGrassOrFlower(footBlock)) {
            return false;
        }
        if (!regrowthType.equals("eat") && !regrowthType.equals("both")) {
            return false;
        }
        eventEntity.field_70170_p.func_175655_b(eventEntityPos, false);
        double randomD100Roll = eventEntity.field_70170_p.field_73012_v.nextDouble() * 100.0;
        if (randomD100Roll > 60.0 && groundBlock instanceof GrassBlock) {
            eventEntity.field_70170_p.func_175656_a(eventEntityPos.func_177977_b(), Blocks.field_150346_d.func_176223_P());
        }
        LivingEntity le = (LivingEntity)eventEntity;
        if (eventEntity instanceof AgeableEntity && (ae = (AgeableEntity)eventEntity).func_70631_g_()) {
            ae.func_70873_a(ae.func_70874_b() + 30);
        }
        if (le.func_110138_aP() > le.func_110143_aJ() && MyConfig.aEatingHeals == 1.0) {
            EffectInstance ei = new EffectInstance(Effects.field_76432_h, 1, 0, false, true);
            le.func_195064_c(ei);
        }
        return true;
    }

    private boolean entityGrowTallGrassToDoubleGrass(Entity eventEntity, Block footBlock, String regrowthType) {
        if (footBlock instanceof TallGrassBlock) {
            IGrowable ib = (IGrowable)footBlock;
            ib.func_225535_a_((ServerWorld)eventEntity.field_70170_p, eventEntity.field_70170_p.field_73012_v, this.getBlockPos(eventEntity), eventEntity.field_70170_p.func_180495_p(this.getBlockPos(eventEntity)));
            return true;
        }
        return false;
    }

    private boolean improveFarm(VillagerEntity ve, Block groundBlock, Block footBlock, String regrowthType, int veX, int veY, int veZ) {
        boolean nextToFarmBlock = false;
        boolean nextToWaterBlock = false;
        boolean torchExploit = false;
        if (ve.func_213700_eh().func_221130_b() == VillagerProfession.field_221156_f) {
            Block tempBlock;
            int i;
            if (lastTorchX == veX && lastTorchY == veY && lastTorchZ == veZ) {
                torchExploit = true;
            }
            for (i = 0; i < 4; ++i) {
                tempBlock = ve.field_70170_p.func_180495_p(new BlockPos(veX + dx[i], veY - 1, veZ + dz[i])).func_177230_c();
                if (tempBlock != Blocks.field_150458_ak) continue;
                nextToFarmBlock = true;
                i = 4;
            }
            if (BlockTags.field_200031_h.func_230235_a_((Object)groundBlock)) {
                for (i = 0; i < 4; ++i) {
                    tempBlock = ve.field_70170_p.func_180495_p(new BlockPos(veX + dx[i], veY - 1, veZ + dz[i])).func_177230_c();
                    if (tempBlock != Blocks.field_150355_j) continue;
                    nextToWaterBlock = true;
                    i = 4;
                }
                if (regrowthType.contains("t") && nextToWaterBlock && footBlock == Blocks.field_150350_a && !torchExploit) {
                    ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve), Blocks.field_150478_aa.func_176223_P());
                    lastTorchX = veX;
                    lastTorchY = veY;
                    lastTorchZ = veZ;
                }
            }
            if (nextToFarmBlock) {
                if (groundBlock == Blocks.field_196580_bH && regrowthType.contains("t")) {
                    ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve), Blocks.field_150478_aa.func_176223_P());
                    lastTorchX = veX;
                    lastTorchY = veY;
                    lastTorchZ = veZ;
                }
                if (groundBlock instanceof GrassBlock) {
                    ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve).func_177977_b(), Blocks.field_150458_ak.func_176223_P());
                    return true;
                }
            }
        }
        return false;
    }

    private boolean improveLighting(VillagerEntity ve, Block footBlock, Block groundBlock, int veX, int veY, int veZ) {
        int blockLightValue;
        int skylightValue = ve.field_70170_p.func_226658_a_(LightType.SKY, this.getBlockPos((Entity)ve));
        Biome.Category villageBiomeCategory = ve.field_70170_p.func_226691_t_(this.getBlockPos((Entity)ve)).func_201856_r();
        if (ve.func_70608_bn()) {
            return false;
        }
        if (footBlock instanceof BedBlock) {
            return false;
        }
        if ((groundBlock == Blocks.field_196662_n || groundBlock == Blocks.field_196664_o || groundBlock == Blocks.field_196666_p || groundBlock == Blocks.field_196668_q || groundBlock == Blocks.field_196670_r || groundBlock == Blocks.field_196580_bH && skylightValue < 14 || groundBlock == Blocks.field_150347_e && skylightValue < 14 && villageBiomeCategory == Biome.Category.TAIGA) && (blockLightValue = ve.field_70170_p.func_226658_a_(LightType.BLOCK, this.getBlockPos((Entity)ve))) < 8) {
            ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve), Blocks.field_150478_aa.func_176223_P());
            return true;
        }
        return false;
    }

    private void improveRoads(VillagerEntity ve, Block footBlock, Block groundBlock, String key) {
        int veZ;
        int veY;
        BlockPos vePos = this.getBlockPos((Entity)ve);
        int veX = vePos.func_177958_n();
        if (this.improveRoadsFixPotholes(ve, groundBlock, veX, veY = vePos.func_177956_o(), veZ = vePos.func_177952_p()) && MyConfig.aDebugLevel > 0) {
            System.out.println(key + " fix road " + veX + ", " + veY + ", " + veZ + ". ");
        }
        if (this.improveRoadsSmoothHeight(ve, footBlock, groundBlock, veX, veY, veZ) && MyConfig.aDebugLevel > 0) {
            System.out.println(key + " smooth road slope" + veX + ", " + veY + ", " + veZ + ", ");
        }
    }

    private boolean improveRoadsFixPotholes(VillagerEntity ve, Block groundBlock, int veX, int veY, int veZ) {
        int grassPathCount = 0;
        int fixHeight = 2;
        if (Biome.Category.TAIGA == ve.field_70170_p.func_226691_t_(this.getBlockPos((Entity)ve)).func_201856_r()) {
            fixHeight = 4;
        }
        int pitVeY = veY;
        if (groundBlock == Blocks.field_185774_da) {
            pitVeY = veY + 1;
        }
        if (groundBlock == Blocks.field_150346_d || groundBlock == Blocks.field_196658_i || groundBlock == Blocks.field_185774_da) {
            grassPathCount = 0;
            for (int i = 0; i < 4; ++i) {
                Block tempBlock = ve.field_70170_p.func_180495_p(new BlockPos(veX + dx[i], pitVeY, veZ + dz[i])).func_177230_c();
                if (tempBlock != Blocks.field_185774_da) continue;
                ++grassPathCount;
            }
            if (grassPathCount == 4) {
                ve.field_70170_p.func_175656_a(new BlockPos(veX, pitVeY, veZ), Blocks.field_185774_da.func_176223_P());
                ve.func_213293_j(0.0, 0.4, 0.0);
                return true;
            }
        }
        if (groundBlock == Blocks.field_150346_d || groundBlock instanceof GrassBlock) {
            grassPathCount = 0;
            for (int dy = -1; dy <= fixHeight; ++dy) {
                for (int i = 0; i < 4; ++i) {
                    Block tempBlock = ve.field_70170_p.func_180495_p(new BlockPos(veX + dx[i], veY + dy, veZ + dz[i])).func_177230_c();
                    if (tempBlock != Blocks.field_185774_da) continue;
                    ++grassPathCount;
                }
            }
            if (grassPathCount >= 3) {
                ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve).func_177977_b(), Blocks.field_185774_da.func_176223_P());
                return true;
            }
        }
        return false;
    }

    private boolean improveRoadsSmoothHeight(VillagerEntity ve, Block footBlock, Block groundBlock, int veX, int veY, int veZ) {
        boolean doRoadSmoothing = false;
        BlockState smoothingBlockState = Blocks.field_185774_da.func_176223_P();
        Block smoothingBlock = Blocks.field_185774_da;
        if (footBlock == Blocks.field_185774_da) {
            doRoadSmoothing = true;
        }
        if (doRoadSmoothing) {
            for (int dy = 2; dy < 6; ++dy) {
                for (int i = 0; i < 4; ++i) {
                    Block tempBlock = ve.field_70170_p.func_180495_p(new BlockPos(veX + dx[i], veY + dy, veZ + dz[i])).func_177230_c();
                    if (tempBlock != smoothingBlock) continue;
                    ve.field_70170_p.func_175656_a(new BlockPos(veX, veY + 1, veZ), smoothingBlockState);
                    ve.func_213293_j(0.0, 0.4, 0.0);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean improveWallForMeetingPlace(VillagerEntity ve, String regrowthType, BlockPos villageMeetingPlaceBlockPos, Block groundBlock) {
        int absvz;
        int absvx;
        boolean buildCenterGate;
        Biome villageBiome = ve.field_70170_p.func_226691_t_(villageMeetingPlaceBlockPos);
        int wallPerimeter = 31;
        int wallTorchSpacing = 8;
        boolean wallCenter = false;
        BlockState wallType = Blocks.field_150463_bK.func_176223_P();
        BlockState gateBlockType = Blocks.field_185774_da.func_176223_P();
        if (villageBiome.func_201856_r() == Biome.Category.DESERT) {
            wallPerimeter = 23;
            wallType = Blocks.field_222417_lF.func_176223_P();
            gateBlockType = Blocks.field_196580_bH.func_176223_P();
        }
        if (villageBiome.func_201856_r() == Biome.Category.TAIGA) {
            wallPerimeter = 23;
            wallType = Blocks.field_196723_eg.func_176223_P();
        }
        if (this.placeOneWallPiece(ve, regrowthType, wallPerimeter, wallTorchSpacing, 0, gateBlockType, buildCenterGate = true, wallType, absvx = (int)Math.abs(ve.func_226277_ct_() - (double)villageMeetingPlaceBlockPos.func_177958_n()), absvz = (int)Math.abs(ve.func_226281_cx_() - (double)villageMeetingPlaceBlockPos.func_177952_p()))) {
            if (regrowthType.contains("t") && this.isValidTorchLocation(wallPerimeter, wallTorchSpacing, absvx, absvz, ve.field_70170_p.func_180495_p(this.getBlockPos((Entity)ve)).func_177230_c())) {
                ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve).func_177984_a(), Blocks.field_150478_aa.func_176223_P());
            }
            return true;
        }
        return false;
    }

    private boolean improveWallForPersonalHome(VillagerEntity ve, BlockPos vHomePos, String regrowthType, Block groundBlock) {
        int absvz;
        int absvx;
        boolean buildCenterGate;
        Biome villageBiome = ve.field_70170_p.func_226691_t_(vHomePos);
        int wallPerimeter = 5;
        int wallTorchSpacing = 4;
        boolean wallCenter = false;
        BlockState wallType = Blocks.field_180407_aO.func_176223_P();
        BlockState gateBlockType = Blocks.field_185774_da.func_176223_P();
        if (villageBiome.func_201856_r() == Biome.Category.DESERT) {
            wallPerimeter += 2;
            wallTorchSpacing = 6;
            wallType = Blocks.field_180405_aT.func_176223_P();
            gateBlockType = Blocks.field_150322_A.func_176223_P();
        }
        if (villageBiome.func_201856_r() == Biome.Category.TAIGA) {
            wallTorchSpacing = 3;
            wallType = Blocks.field_180408_aP.func_176223_P();
            gateBlockType = Blocks.field_150322_A.func_176223_P();
        }
        if (this.placeOneWallPiece(ve, regrowthType, wallPerimeter, wallTorchSpacing, 0, gateBlockType, buildCenterGate = false, wallType, absvx = (int)Math.abs(ve.func_226277_ct_() - (double)vHomePos.func_177958_n()), absvz = (int)Math.abs(ve.func_226281_cx_() - (double)vHomePos.func_177952_p()))) {
            if (regrowthType.contains("t") && this.isValidTorchLocation(wallPerimeter, wallTorchSpacing, absvx, absvz, groundBlock)) {
                ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve).func_177984_a(), Blocks.field_150478_aa.func_176223_P());
            }
            return true;
        }
        return false;
    }

    private void improveWalls(VillagerEntity ve, Block footBlock, Block groundBlock, String key, String regrowthType, int veX, int veY, int veZ) {
        Brain vb = ve.func_213375_cj();
        Optional vMeetingPlace = vb.func_218207_c(MemoryModuleType.field_220943_d);
        if (this.isOkayToBuildWallHere(ve, footBlock, groundBlock, vMeetingPlace, veX, veY, veZ)) {
            Optional villagerHome;
            GlobalPos gVMP = (GlobalPos)vMeetingPlace.get();
            BlockPos villageMeetingPlaceBlockPos = gVMP.func_218180_b();
            if (regrowthType.contains("w") && this.improveWallForMeetingPlace(ve, regrowthType, villageMeetingPlaceBlockPos, groundBlock) && MyConfig.aDebugLevel > 0) {
                System.out.println(key + " Meeting Place wall at " + veX + ", " + veY + ", " + veZ + ".");
            }
            if (regrowthType.contains("p") && (villagerHome = vb.func_218207_c(MemoryModuleType.field_220941_b)).isPresent()) {
                GlobalPos gVHP = (GlobalPos)villagerHome.get();
                BlockPos villagerHomePos = gVHP.func_218180_b();
                if (this.isOutsideMeetingPlaceWall(ve, vMeetingPlace, ((GlobalPos)vMeetingPlace.get()).func_218180_b(), veX, veY, veZ) && this.improveWallForPersonalHome(ve, villagerHomePos, regrowthType, groundBlock) && MyConfig.aDebugLevel > 0) {
                    System.out.println(key + " personal wall at " + veX + ", " + veY + ", " + veZ + ".");
                }
            }
        }
    }

    private boolean isFootBlockOkayToBuildIn(Block footBlock) {
        return footBlock instanceof AirBlock;
    }

    private boolean isGrassOrFlower(Block footBlock) {
        if (footBlock instanceof TallGrassBlock) {
            return true;
        }
        if (footBlock instanceof FlowerBlock) {
            return true;
        }
        if (footBlock instanceof DoublePlantBlock) {
            return true;
        }
        if (footBlock == Blocks.field_196554_aH) {
            return true;
        }
        return footBlock == Blocks.field_196805_gi;
    }

    private boolean isImpossibleRegrowthEvent(Block footBlock, String regrowthType) {
        if (regrowthType.equals("eat") && footBlock instanceof AirBlock) {
            return true;
        }
        if (regrowthType.equals("grow") && footBlock instanceof TallGrassBlock) {
            return true;
        }
        if (regrowthType.equals("grow") && footBlock instanceof FlowerBlock) {
            return true;
        }
        return regrowthType.equals("tall") && !(footBlock instanceof TallGrassBlock);
    }

    private boolean isOkayToBuildWallHere(VillagerEntity ve, Block footBlock, Block groundBlock, Optional<GlobalPos> vMeetingPlace, int veX, int veY, int veZ) {
        boolean okayToBuildWalls = true;
        if (!vMeetingPlace.isPresent()) {
            okayToBuildWalls = false;
        }
        if (!this.isOnGround((Entity)ve)) {
            okayToBuildWalls = false;
        }
        if (!this.isFootBlockOkayToBuildIn(footBlock)) {
            okayToBuildWalls = false;
        }
        if (!this.isValidGroundBlockToBuildWallOn(ve, groundBlock)) {
            okayToBuildWalls = false;
        }
        return okayToBuildWalls;
    }

    private boolean isOutsideMeetingPlaceWall(VillagerEntity ve, Optional<GlobalPos> vMeetingPlace, BlockPos meetingPlacePos, int veX, int veY, int veZ) {
        int absVMpX = Math.abs(veX - meetingPlacePos.func_177958_n());
        int absVMpZ = Math.abs(veZ - meetingPlacePos.func_177952_p());
        return absVMpX >= 32 || absVMpZ >= 32;
    }

    private boolean isValidGroundBlockToBuildWallOn(VillagerEntity ve, Block groundBlock) {
        int blockSkyLightValue = ve.field_70170_p.func_226658_a_(LightType.SKY, this.getBlockPos((Entity)ve));
        if (blockSkyLightValue < 14) {
            return false;
        }
        String key = groundBlock.getRegistryName().toString();
        WallFoundationsManager.wallFoundationItem currentWallFoundationItem = WallFoundationsManager.getWallFoundationInfo(key);
        return currentWallFoundationItem != null;
    }

    private boolean isValidTorchLocation(int wallPerimeter, int wallTorchSpacing, int absvx, int absvz, Block wallFenceBlock) {
        boolean hasAWallUnderIt = false;
        if (wallFenceBlock instanceof WallBlock) {
            hasAWallUnderIt = true;
        }
        if (wallFenceBlock instanceof FenceBlock) {
            hasAWallUnderIt = true;
        }
        if (!hasAWallUnderIt) {
            return false;
        }
        if (absvx == wallPerimeter && absvz % wallTorchSpacing == 1) {
            return true;
        }
        if (absvx % wallTorchSpacing == 1 && absvz == wallPerimeter) {
            return true;
        }
        return absvx == wallPerimeter && absvz == wallPerimeter;
    }

    private boolean placeOneWallPiece(VillagerEntity ve, String regrowthType, int wallPerimeter, int wallTorchSpacing, int wallCenter, BlockState gateBlockType, boolean buildCenterGate, BlockState wallType, int absvx, int absvz) {
        BlockState bs = ve.field_70170_p.func_180495_p(this.getBlockPos((Entity)ve).func_177977_b());
        Block blockBs = bs.func_177230_c();
        if (blockBs instanceof StairsBlock) {
            return false;
        }
        if (absvx != wallPerimeter && absvz != wallPerimeter) {
            return false;
        }
        int scan = wallPerimeter - 2;
        int scanPosX = (int)ve.func_226277_ct_();
        int scanPosZ = (int)ve.func_226281_cx_();
        int scanPosY = (int)ve.func_226278_cu_();
        boolean noOtherBells = true;
        for (int dy = scanPosY - 1; dy < scanPosY + 3; ++dy) {
            for (int dx = scanPosX - scan; dx < scanPosX + scan; ++dx) {
                for (int dz = scanPosZ - scan; dz < scanPosZ + scan + 1; ++dz) {
                    BlockPos pos = new BlockPos(dx, dy, dz);
                    if (ve.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_222431_lT) continue;
                    return false;
                }
            }
        }
        if (absvx == wallPerimeter && absvz <= wallPerimeter) {
            if (absvz == wallCenter) {
                if (buildCenterGate) {
                    ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve).func_177977_b(), gateBlockType);
                    return true;
                }
                return false;
            }
            BlockState b = ve.field_70170_p.func_180495_p(this.getBlockPos((Entity)ve).func_177977_b());
            Block block = b.func_177230_c();
            if (block instanceof AirBlock || block instanceof TallGrassBlock) {
                ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve).func_177977_b(), wallType);
            } else {
                ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve), wallType);
            }
            return true;
        }
        if (absvz == wallPerimeter && absvx <= wallPerimeter) {
            if (absvx == wallCenter) {
                if (buildCenterGate) {
                    ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve).func_177977_b(), gateBlockType);
                    return true;
                }
                return false;
            }
            BlockState b = ve.field_70170_p.func_180495_p(this.getBlockPos((Entity)ve).func_177977_b());
            Block block = b.func_177230_c();
            if (block instanceof AirBlock || block instanceof TallGrassBlock) {
                ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve).func_177977_b(), wallType);
            } else {
                ve.field_70170_p.func_175656_a(this.getBlockPos((Entity)ve), wallType);
            }
            return true;
        }
        return false;
    }

    private BlockPos getBlockPos(Entity e) {
        return e.func_233580_cy_();
    }

    private boolean isOnGround(Entity e) {
        return e.func_233570_aj_();
    }
}

