/*
 * Decompiled with CFR 0.152.
 */
package com.shockingartist.rocketboots;

import com.shockingartist.rocketboots.RocketbootsMod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class RocketbootsModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public RocketbootsModElements() {
        sounds.put(new ResourceLocation("rocketboots", "fusil_mondragon_fire"), new SoundEvent(new ResourceLocation("rocketboots", "fusil_mondragon_fire")));
        sounds.put(new ResourceLocation("rocketboots", "lazer_fire"), new SoundEvent(new ResourceLocation("rocketboots", "lazer_fire")));
        sounds.put(new ResourceLocation("rocketboots", "lazerminigun_fire"), new SoundEvent(new ResourceLocation("rocketboots", "lazerminigun_fire")));
        sounds.put(new ResourceLocation("rocketboots", "acid_gun_fire"), new SoundEvent(new ResourceLocation("rocketboots", "acid_gun_fire")));
        sounds.put(new ResourceLocation("rocketboots", "grenade_explode"), new SoundEvent(new ResourceLocation("rocketboots", "grenade_explode")));
        sounds.put(new ResourceLocation("rocketboots", "zapped_effect"), new SoundEvent(new ResourceLocation("rocketboots", "zapped_effect")));
        sounds.put(new ResourceLocation("rocketboots", "machete_use"), new SoundEvent(new ResourceLocation("rocketboots", "machete_use")));
        sounds.put(new ResourceLocation("rocketboots", "uluknife_use"), new SoundEvent(new ResourceLocation("rocketboots", "uluknife_use")));
        sounds.put(new ResourceLocation("rocketboots", "diffuser_entity"), new SoundEvent(new ResourceLocation("rocketboots", "diffuser_entity")));
        sounds.put(new ResourceLocation("rocketboots", "grenade_launcher_use"), new SoundEvent(new ResourceLocation("rocketboots", "grenade_launcher_use")));
        sounds.put(new ResourceLocation("rocketboots", "musket_use"), new SoundEvent(new ResourceLocation("rocketboots", "musket_use")));
        sounds.put(new ResourceLocation("rocketboots", "shotgun_fire"), new SoundEvent(new ResourceLocation("rocketboots", "shotgun_fire")));
        sounds.put(new ResourceLocation("rocketboots", "swamp_ambient"), new SoundEvent(new ResourceLocation("rocketboots", "swamp_ambient")));
        sounds.put(new ResourceLocation("rocketboots", "wcb_block"), new SoundEvent(new ResourceLocation("rocketboots", "wcb_block")));
        sounds.put(new ResourceLocation("rocketboots", "boomerang_throw"), new SoundEvent(new ResourceLocation("rocketboots", "boomerang_throw")));
        sounds.put(new ResourceLocation("rocketboots", "radio_block"), new SoundEvent(new ResourceLocation("rocketboots", "radio_block")));
        sounds.put(new ResourceLocation("rocketboots", "warning_horn"), new SoundEvent(new ResourceLocation("rocketboots", "warning_horn")));
        sounds.put(new ResourceLocation("rocketboots", "be_free"), new SoundEvent(new ResourceLocation("rocketboots", "be_free")));
        sounds.put(new ResourceLocation("rocketboots", "warpingpearl_use"), new SoundEvent(new ResourceLocation("rocketboots", "warpingpearl_use")));
        sounds.put(new ResourceLocation("rocketboots", "subresource_get"), new SoundEvent(new ResourceLocation("rocketboots", "subresource_get")));
        sounds.put(new ResourceLocation("rocketboots", "stove_heatup"), new SoundEvent(new ResourceLocation("rocketboots", "stove_heatup")));
        sounds.put(new ResourceLocation("rocketboots", "service_bell"), new SoundEvent(new ResourceLocation("rocketboots", "service_bell")));
        sounds.put(new ResourceLocation("rocketboots", "cooking_food"), new SoundEvent(new ResourceLocation("rocketboots", "cooking_food")));
        sounds.put(new ResourceLocation("rocketboots", "snake_living"), new SoundEvent(new ResourceLocation("rocketboots", "snake_living")));
        sounds.put(new ResourceLocation("rocketboots", "rocket_boost"), new SoundEvent(new ResourceLocation("rocketboots", "rocket_boost")));
        sounds.put(new ResourceLocation("rocketboots", "rocket"), new SoundEvent(new ResourceLocation("rocketboots", "rocket")));
        sounds.put(new ResourceLocation("rocketboots", "login"), new SoundEvent(new ResourceLocation("rocketboots", "login")));
        sounds.put(new ResourceLocation("rocketboots", "horde"), new SoundEvent(new ResourceLocation("rocketboots", "horde")));
        sounds.put(new ResourceLocation("rocketboots", "zattacked"), new SoundEvent(new ResourceLocation("rocketboots", "zattacked")));
        sounds.put(new ResourceLocation("rocketboots", "zdeath"), new SoundEvent(new ResourceLocation("rocketboots", "zdeath")));
        sounds.put(new ResourceLocation("rocketboots", "zliving"), new SoundEvent(new ResourceLocation("rocketboots", "zliving")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("rocketboots").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        RocketbootsMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final RocketbootsModElements elements;
        protected final int sortid;

        public ModElement(RocketbootsModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

