/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.block;

import com.mrtrollnugnug.ropebridge.handler.ConfigHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RopeBridgeBlock
extends Block {
    public static final IntegerProperty PROPERTY_HEIGHT = BlockStateProperties.field_208130_ae;
    public static final IntegerProperty PROPERTY_BACK = IntegerProperty.func_177719_a((String)"back", (int)0, (int)3);
    public static final BooleanProperty ROTATED = BooleanProperty.func_177716_a((String)"rotated");
    public static final VoxelShape ZERO_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape ONE_AABB = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape TWO_AABB = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final VoxelShape THREE_AABB = Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private Block slab;

    public RopeBridgeBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PROPERTY_HEIGHT, PROPERTY_BACK, ROTATED});
    }

    public Block getSlab() {
        return this.slab;
    }

    public void setSlab(Block slab) {
        this.slab = slab;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int level = (Integer)state.func_177229_b((Property)PROPERTY_HEIGHT);
        switch (level) {
            default: {
                return ZERO_AABB;
            }
            case 1: {
                return ONE_AABB;
            }
            case 2: {
                return TWO_AABB;
            }
            case 3: 
        }
        return THREE_AABB;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(world, pos, state, player);
        if (!world.field_72995_K && player.func_184614_ca().func_77973_b() == ContentHandler.bridge_builder && player.func_213453_ef()) {
            boolean rotate = (Boolean)world.func_180495_p(pos).func_177229_b((Property)ROTATED);
            if (rotate) {
                this.breakNorth(pos, (ServerWorld)world);
                this.breakSouth(pos, (ServerWorld)world);
            } else {
                this.breakEast(pos, (ServerWorld)world);
                this.breakWest(pos, (ServerWorld)world);
            }
        }
    }

    public void breakSouth(BlockPos posToBreak, final ServerWorld world) {
        final BlockPos south = posToBreak.func_177968_d();
        final BlockPos up = south.func_177984_a();
        final BlockPos down = south.func_177977_b();
        BlockState stateDown = world.func_180495_p(down);
        BlockState stateUp = world.func_180495_p(up);
        BlockState state = world.func_180495_p(south);
        if (state.func_177230_c() == this) {
            world.func_175655_b(south, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakSouth(south, world);
                }
            }, 100L);
        }
        if (stateUp.func_177230_c() == this) {
            world.func_175655_b(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakSouth(up, world);
                }
            }, 100L);
        }
        if (stateDown.func_177230_c() == this) {
            world.func_175655_b(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakSouth(down, world);
                }
            }, 100L);
        }
    }

    public void breakNorth(BlockPos posToBreak, final ServerWorld world) {
        final BlockPos north = posToBreak.func_177978_c();
        final BlockPos up = north.func_177984_a();
        final BlockPos down = north.func_177977_b();
        BlockState stateDown = world.func_180495_p(down);
        BlockState stateUp = world.func_180495_p(up);
        BlockState state = world.func_180495_p(north);
        if (state.func_177230_c() == this) {
            world.func_175655_b(north, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakNorth(north, world);
                }
            }, 100L);
        }
        if (stateUp.func_177230_c() == this) {
            world.func_175655_b(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakNorth(up, world);
                }
            }, 100L);
        }
        if (stateDown.func_177230_c() == this) {
            world.func_175655_b(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakNorth(down, world);
                }
            }, 100L);
        }
    }

    public void breakEast(BlockPos posToBreak, final ServerWorld world) {
        final BlockPos east = posToBreak.func_177974_f();
        final BlockPos up = east.func_177984_a();
        final BlockPos down = east.func_177977_b();
        BlockState stateDown = world.func_180495_p(down);
        BlockState stateUp = world.func_180495_p(up);
        BlockState state = world.func_180495_p(east);
        if (state.func_177230_c() == this) {
            world.func_175655_b(east, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakEast(east, world);
                }
            }, 100L);
        }
        if (stateUp.func_177230_c() == this) {
            world.func_175655_b(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakEast(up, world);
                }
            }, 100L);
        }
        if (stateDown.func_177230_c() == this) {
            world.func_175655_b(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakEast(down, world);
                }
            }, 100L);
        }
    }

    public void breakWest(BlockPos posToBreak, final ServerWorld world) {
        final BlockPos west = posToBreak.func_177976_e();
        final BlockPos up = west.func_177984_a();
        final BlockPos down = west.func_177977_b();
        BlockState stateDown = world.func_180495_p(down);
        BlockState stateUp = world.func_180495_p(up);
        BlockState state = world.func_180495_p(west);
        if (state.func_177230_c() == this) {
            world.func_175655_b(west, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakWest(west, world);
                }
            }, 100L);
        }
        if (stateUp.func_177230_c() == this) {
            world.func_175655_b(up, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakWest(up, world);
                }
            }, 100L);
        }
        if (stateDown.func_177230_c() == this) {
            world.func_175655_b(down, true);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    RopeBridgeBlock.this.breakWest(down, world);
                }
            }, 100L);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((IItemProvider)ContentHandler.rope, ConfigHandler.getRopePerBridge()));
        drops.add(new ItemStack((IItemProvider)this.slab, ConfigHandler.getSlabsPerBridge()));
        return drops;
    }
}

