/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.item;

import com.mrtrollnugnug.ropebridge.block.RopeBridgeBlock;
import com.mrtrollnugnug.ropebridge.handler.BridgeBuildingHandler;
import com.mrtrollnugnug.ropebridge.item.ItemBuilder;
import com.mrtrollnugnug.ropebridge.lib.ModUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ItemBridgeBuilder
extends ItemBuilder {
    public ItemBridgeBuilder(Item.Properties properties) {
        super(properties);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        super.onUsingTick(stack, player, count);
        if (player.field_70170_p.field_72995_K && player instanceof PlayerEntity) {
            PlayerEntity p = (PlayerEntity)player;
            ItemBridgeBuilder.rotatePlayerTowards(p, ItemBridgeBuilder.getNearestYaw(p));
        }
    }

    private static void rotatePlayerTowards(PlayerEntity player, float target) {
        float yaw = player.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        ItemBridgeBuilder.rotatePlayerTo(player, yaw + (target - yaw) / 4.0f);
    }

    private static void rotatePlayerTo(PlayerEntity player, float yaw) {
        float original = player.field_70177_z;
        player.field_70177_z = yaw;
        player.field_70126_B += player.field_70177_z - original;
    }

    private static float getNearestYaw(PlayerEntity player) {
        float yaw = player.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw < 45.0f) {
            return 0.0f;
        }
        if (yaw > 45.0f && yaw <= 135.0f) {
            return 90.0f;
        }
        if (yaw > 135.0f && yaw <= 225.0f) {
            return 180.0f;
        }
        if (yaw > 225.0f && yaw <= 315.0f) {
            return 270.0f;
        }
        return 360.0f;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity && !world.field_72995_K) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            if (this.func_77626_a(stack) - timeLeft > 10) {
                if (!player.func_233570_aj_()) {
                    ModUtils.tellPlayer(player, "chat.ropebridge.info.notonground", new Object[0]);
                } else {
                    RayTraceResult hit = ItemBridgeBuilder.trace(player);
                    if (hit instanceof BlockRayTraceResult) {
                        BlockPos floored = new BlockPos(Math.floor(player.func_226277_ct_()), Math.floor(player.func_226278_cu_()) - 1.0, Math.floor(player.func_226281_cx_())).func_177977_b();
                        BlockPos target = ((BlockRayTraceResult)hit).func_216350_a();
                        BridgeBuildingHandler.newBridge(player, player.func_184614_ca(), floored, target);
                    }
                }
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        BlockState state = player.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!player.field_70170_p.field_72995_K && player.func_213453_ef() && ItemBridgeBuilder.isBridgeBlock(player.field_70170_p.func_180495_p(pos).func_177230_c())) {
            ModUtils.tellPlayer(player, "chat.ropebridge.warning.breaking", new Object[0]);
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (ItemBridgeBuilder.isBridgeBlock(state.func_177230_c())) {
            return 1.0f;
        }
        return super.func_150893_a(stack, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("- Hold right-click to build"));
        tooltip.add((ITextComponent)new StringTextComponent("- Sneak to break whole bridge"));
    }

    private static boolean isBridgeBlock(Block block) {
        return block instanceof RopeBridgeBlock;
    }

    private static void breakBridge(PlayerEntity player, World worldIn, BlockPos posIn) {
        worldIn.func_73046_m().execute(() -> {
            int xRange = 0;
            int zRange = 0;
            xRange = 1;
            LinkedList<BlockPos> newQueue = new LinkedList<BlockPos>();
            newQueue.add(posIn);
            LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
            queue.add(posIn);
            while (!newQueue.isEmpty()) {
                BlockPos pos = (BlockPos)newQueue.remove();
                for (int x = pos.func_177958_n() - xRange; x <= pos.func_177958_n() + xRange; ++x) {
                    for (int y = pos.func_177956_o() - 1; y <= pos.func_177956_o() + 1; ++y) {
                        for (int z = pos.func_177952_p() - zRange; z <= pos.func_177952_p() + zRange; ++z) {
                            BlockState currentBlockState;
                            BlockPos currentPos = new BlockPos(x, y, z);
                            if (x - pos.func_177958_n() == 0 && z - pos.func_177952_p() == 0 || queue.contains(currentPos) || !ItemBridgeBuilder.isBridgeBlock((currentBlockState = worldIn.func_180495_p(currentPos)).func_177230_c())) continue;
                            newQueue.add(currentPos);
                        }
                    }
                }
                queue.add(pos);
            }
            Timer timer = new Timer();
            BreakTask task = new BreakTask(queue, worldIn, timer, !player.field_71075_bZ.field_75098_d);
            timer.schedule((TimerTask)task, 100L, 100L);
        });
    }

    private static class BreakTask
    extends TimerTask {
        private final Queue<BlockPos> queue;
        private final World world;
        private final Timer timer;
        private final boolean drop;

        public BreakTask(Queue<BlockPos> queue, World world, Timer timer, boolean drop) {
            this.queue = queue;
            this.world = world;
            this.timer = timer;
            this.drop = drop;
        }

        @Override
        public void run() {
            BlockPos pos = this.queue.remove();
            if (this.world.func_180495_p(pos).func_177230_c() instanceof RopeBridgeBlock) {
                ServerLifecycleHooks.getCurrentServer().execute(() -> this.world.func_175655_b(pos, this.drop));
            }
            if (this.queue.isEmpty()) {
                this.timer.cancel();
            }
        }
    }
}

