/*
 * Decompiled with CFR 0.152.
 */
package com.czechmate777.ropebridge.blocks;

import com.czechmate777.ropebridge.blocks.BasicBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BridgeSlab
extends BasicBlock {
    protected static float slabHeight = 0.25f;
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    public BridgeSlab(String unlocalizedName, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        super(unlocalizedName, Material.field_151575_d, 1.0f, 5.0f);
        this.func_149672_a(field_149766_f);
        this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.OAK)));
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int meta = this.func_176201_c(state);
        int slabMeta = (meta - meta % 2) / 2;
        ret.add(new ItemStack((Block)Blocks.field_150376_bx, 1, slabMeta));
        ret.add(new ItemStack(Items.field_151007_F, RANDOM.nextInt(2)));
        return ret;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public int func_149656_h() {
        return 1;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            case 0: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.OAK));
            }
            case 1: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.OAK_R));
            }
            case 2: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.SPRUCE));
            }
            case 3: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.SPRUCE_R));
            }
            case 4: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.BIRCH));
            }
            case 5: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.BIRCH_R));
            }
            case 6: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.JUNGLE));
            }
            case 7: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.JUNGLE_R));
            }
            case 8: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.ACACIA));
            }
            case 9: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.ACACIA_R));
            }
            case 10: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.BIG_OAK));
            }
            case 11: {
                return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.BIG_OAK_R));
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.OAK));
    }

    public int func_176201_c(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b((IProperty)TYPE));
        return type.getID();
    }

    public static enum EnumType implements IStringSerializable
    {
        OAK(0, "oak"),
        OAK_R(1, "oak-r"),
        SPRUCE(2, "spruce"),
        SPRUCE_R(3, "spruce-r"),
        BIRCH(4, "birch"),
        BIRCH_R(5, "birch-r"),
        JUNGLE(6, "jungle"),
        JUNGLE_R(7, "jungle-r"),
        ACACIA(8, "acacia"),
        ACACIA_R(9, "acacia-r"),
        BIG_OAK(10, "big-oak"),
        BIG_OAK_R(11, "big-oak-r");

        private int ID;
        private String name;

        private EnumType(int ID, String name) {
            this.ID = ID;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

