/*
 * Decompiled with CFR 0.152.
 */
package com.czechmate777.ropebridge.items;

import com.czechmate777.ropebridge.Main;
import com.czechmate777.ropebridge.bridgeMessage;
import com.czechmate777.ropebridge.items.Builder;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BBItem
extends Item {
    World world;
    EntityPlayer player;
    boolean viewSnap;
    float playerFov;
    boolean fovNormal;
    Timer smokeTimer;
    Timer buildTimer;
    Timer clickTimer;
    ChatStyle chatStyle = new ChatStyle().func_150238_a(EnumChatFormatting.DARK_AQUA);
    boolean posSet = false;
    BlockPos firstPos;
    private boolean warningSent = false;

    public BBItem(String unlocalizedName) {
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77625_d(1);
        this.func_77656_e(64);
        this.smokeTimer = new Timer();
        this.buildTimer = new Timer();
        this.clickTimer = new Timer();
        this.viewSnap = false;
        this.fovNormal = true;
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        playerIn.func_71029_a((StatBase)Main.craftAchievement);
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            this.world = worldIn;
        }
        if (playerIn.field_70170_p.field_72995_K) {
            this.player = playerIn;
            if (this.playerFov == 0.0f) {
                this.playerFov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            }
        }
        playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        if (worldIn.field_72995_K) {
            this.viewSnap = true;
            this.fovNormal = false;
            this.clickTimer = new Timer();
            this.clickTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Main.snw.sendToServer((IMessage)new bridgeMessage(0, 0, 0, 0, 2, 0));
                }
            }, 500L);
        }
        return itemStackIn;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public float getDigSpeed(ItemStack itemstack, IBlockState state) {
        if (this.player == null) {
            return 1.0f;
        }
        if (this.player.func_70093_af() && this.isBridgeBlock(state.func_177230_c())) {
            if (!this.warningSent) {
                this.tellPlayer("WARNING! Breaking whole bridge!");
                this.warningSent = true;
            }
            return 0.3f;
        }
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        tooltip.add("- Hold right-click to build");
        tooltip.add("- Sneak to break whole bridge");
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityPlayer playerIn, int timeLeft) {
        if (worldIn.field_72995_K) {
            this.viewSnap = false;
            if (72000 - timeLeft > 10) {
                if (!this.player.field_70122_E) {
                    this.tellPlayer("You must be standing on something to build a bridge!");
                } else {
                    MovingObjectPosition hit = this.player.func_174822_a((double)Main.maxBridgeDistance, 1.0f);
                    Main.snw.sendToServer((IMessage)new bridgeMessage(0, 0, 0, 0, 0, 0));
                    if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                        BlockPos floored = new BlockPos(Math.floor(this.player.field_70165_t), Math.floor(this.player.field_70163_u) - 1.0, Math.floor(this.player.field_70161_v));
                        double xOffset = 0.0;
                        double yOffset = 0.0;
                        double zOffset = 0.0;
                        if (hit.field_72307_f.field_72450_a % 1.0 == 0.0 && hit.field_72307_f.field_72450_a < (double)floored.func_177958_n()) {
                            xOffset = -0.8;
                        }
                        if (hit.field_72307_f.field_72449_c % 1.0 == 0.0 && hit.field_72307_f.field_72449_c < (double)floored.func_177952_p()) {
                            zOffset = -0.8;
                        }
                        if (hit.field_72307_f.field_72448_b % 1.0 == 0.0 && this.player.field_70125_A > 0.0f) {
                            yOffset = -0.8;
                        }
                        Builder.newBridge(this.player, this.playerFov, stack, -1, floored, new BlockPos(hit.field_72307_f.field_72450_a + xOffset, hit.field_72307_f.field_72448_b + yOffset, hit.field_72307_f.field_72449_c + zOffset));
                    }
                }
            } else {
                this.clickTimer.cancel();
            }
        }
    }

    private void tell(EntityPlayer playerIn, String message) {
        playerIn.func_145747_a(new ChatComponentText("[Rope Bridge]: " + message).func_150255_a(this.chatStyle));
    }

    private void tellPlayer(String message) {
        this.tell(this.player, message);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K) {
            if (this.player == null) {
                this.player = (EntityPlayer)entityIn;
            }
            if (((EntityPlayer)entityIn).func_71045_bC() != null) {
                if (((EntityPlayer)entityIn).func_71045_bC().func_77977_a().equals(stack.func_77977_a())) {
                    if (this.viewSnap) {
                        if (isSelected) {
                            this.rotatePlayerTowards(this.getNearestYaw());
                            this.zoomTowards(30.0f);
                        }
                    } else {
                        this.zoomTowards(this.playerFov);
                    }
                } else {
                    this.zoomTowards(this.playerFov);
                    this.viewSnap = false;
                    this.clickTimer.cancel();
                }
            } else {
                this.zoomTowards(this.playerFov);
                this.viewSnap = false;
                this.clickTimer.cancel();
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer playerIn) {
        if (playerIn.field_70170_p.field_72995_K) {
            Block blk = playerIn.field_70170_p.func_180495_p(pos).func_177230_c();
            if (playerIn.func_70093_af() && this.isBridgeBlock(blk)) {
                this.breakBridge(playerIn.field_70170_p, pos, blk.func_176201_c(playerIn.field_70170_p.func_180495_p(pos)));
            }
        }
        return false;
    }

    private boolean isBridgeBlock(Block blockIn) {
        return blockIn.func_149739_a().contains("bridge_block");
    }

    private void breakBridge(World worldIn, BlockPos posIn, int meta) {
        Main.snw.sendToServer((IMessage)new bridgeMessage(1, posIn.func_177958_n(), posIn.func_177956_o(), posIn.func_177952_p(), 0, 0));
        int xRange = 0;
        int zRange = 0;
        if (meta % 2 == 0) {
            xRange = 1;
        } else {
            zRange = 1;
        }
        for (int x = posIn.func_177958_n() - xRange; x <= posIn.func_177958_n() + xRange; ++x) {
            for (int y = posIn.func_177956_o() - 1; y <= posIn.func_177956_o() + 1; ++y) {
                for (int z = posIn.func_177952_p() - zRange; z <= posIn.func_177952_p() + zRange; ++z) {
                    BlockPos currentPos;
                    IBlockState currentBlockState;
                    if (x - posIn.func_177958_n() == 0 && z - posIn.func_177952_p() == 0 || !this.isBridgeBlock((currentBlockState = worldIn.func_180495_p(currentPos = new BlockPos(x, y, z))).func_177230_c()) || currentBlockState.func_177230_c().func_176201_c(currentBlockState) != meta) continue;
                    final World worldInFinal = worldIn;
                    final BlockPos currentPosFinal = currentPos;
                    final int metaFinal = meta;
                    this.buildTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            BBItem.this.breakBridge(worldInFinal, currentPosFinal, metaFinal);
                        }
                    }, 100L);
                }
            }
        }
    }

    private float getNearestYaw() {
        float yaw = this.player.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw < 45.0f) {
            return 0.0f;
        }
        if (yaw > 45.0f && yaw <= 135.0f) {
            return 90.0f;
        }
        if (yaw > 135.0f && yaw <= 225.0f) {
            return 180.0f;
        }
        if (yaw > 225.0f && yaw <= 315.0f) {
            return 270.0f;
        }
        return 360.0f;
    }

    private void rotatePlayerTowards(float target) {
        float yaw = this.player.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        this.rotatePlayerTo(yaw + (target - yaw) / 4.0f);
    }

    private void rotatePlayerTo(float yaw) {
        float original = this.player.field_70177_z;
        this.player.field_70177_z = yaw;
        this.player.field_70126_B += this.player.field_70177_z - original;
    }

    private void zoomTowards(float toFov) {
        if (Main.zoomOnAim && toFov != 0.0f && !this.fovNormal) {
            float currentFov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            if ((float)Math.round(currentFov) != toFov) {
                this.zoomTo(currentFov + (toFov - currentFov) / 4.0f);
            } else if ((float)Math.round(currentFov) == this.playerFov) {
                this.fovNormal = true;
            }
        }
    }

    private void zoomTo(float toFov) {
        if (Main.zoomOnAim && toFov != 0.0f) {
            Minecraft.func_71410_x().field_71474_y.field_74334_X = toFov;
        }
    }
}

