/*
 * Decompiled with CFR 0.152.
 */
package com.czechmate777.ropebridge.items;

import com.czechmate777.ropebridge.Main;
import com.czechmate777.ropebridge.bridgeMessage;
import com.czechmate777.ropebridge.items.SlabPos;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Builder {
    public static void newBridge(EntityPlayer player, float playerFov, ItemStack stack, int inputType, BlockPos pos1, BlockPos pos2) {
        int type;
        int z2;
        int z;
        int y2;
        int x2;
        int y1;
        int x1;
        boolean rotate;
        int Zdiff;
        LinkedList<SlabPos> bridge = new LinkedList<SlabPos>();
        boolean allClear = true;
        int Xdiff = Math.abs(pos1.func_177958_n() - pos2.func_177958_n());
        if (Xdiff > (Zdiff = Math.abs(pos1.func_177952_p() - pos2.func_177952_p()))) {
            rotate = false;
            x1 = pos1.func_177958_n();
            y1 = pos1.func_177956_o();
            x2 = pos2.func_177958_n();
            y2 = pos2.func_177956_o();
            z = pos1.func_177952_p();
            z2 = pos2.func_177952_p();
        } else {
            rotate = true;
            x1 = pos1.func_177952_p();
            y1 = pos1.func_177956_o();
            x2 = pos2.func_177952_p();
            y2 = pos2.func_177956_o();
            z = pos1.func_177958_n();
            z2 = pos2.func_177958_n();
        }
        if (Math.abs(z2 - z) > 3) {
            Builder.tell(player, "Sorry, bridge must be built in a cardinal dirrection. Please try again.");
            return;
        }
        double m = (double)(y2 - y1) / (double)(x2 - x1);
        if (!Main.ignoreSlopeWarnings && Math.abs(m) > 0.2) {
            Builder.tell(player, "Sorry, your slope is too great. Please try again.");
            return;
        }
        double b = (double)y1 - m * (double)x1;
        double distance = Math.abs(x2 - x1);
        int distInt = Math.abs(x2 - x1);
        if (distInt < 2) {
            return;
        }
        if (!Builder.hasMaterials(player, distInt - 1) && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        for (int x = Math.min(x1, x2) + 1; x <= Math.max(x1, x2) - 1; ++x) {
            for (int y = Math.max(y1, y2); y >= Math.min(y1, y2) - distInt / 8 - 1; --y) {
                double funcVal = m * (double)x + b - distance / 1000.0 * Math.sin((double)(x - Math.min(x1, x2)) * (Math.PI / distance)) * (double)Main.bridgeDroopFactor + (double)Main.bridgeYOffset;
                if (!((double)y + 0.5 > funcVal) || !((double)y - 0.5 <= funcVal)) continue;
                int level = funcVal >= (double)y ? (funcVal >= (double)y + 0.25 ? 4 : 3) : (funcVal >= (double)y - 0.25 ? 2 : 1);
                allClear = !Builder.addSlab(player.field_70170_p, bridge, x, y + 1, z, level, rotate) ? false : allClear;
            }
        }
        if (allClear) {
            int n = type = inputType == -1 ? Builder.getWoodType(player) : inputType;
            if (inputType == -1 && !player.field_71075_bZ.field_75098_d) {
                Builder.takeMaterials(player, distInt - 1);
                if (stack.func_77952_i() == stack.func_77958_k()) {
                    Builder.resetFov(playerFov);
                }
                Main.snw.sendToServer((IMessage)new bridgeMessage(3, 0, 0, 0, 0, 0));
            }
        } else {
            Builder.tell(player, "Oops! Looks like there's something in the way. Look for the Smoke to see where that is and try again.");
            return;
        }
        Main.snw.sendToServer((IMessage)new bridgeMessage(4, 0, 0, 0, 0, 0));
        Builder.buildBridge(player.field_70170_p, bridge, type);
    }

    private static boolean hasMaterials(EntityPlayer player, int dist) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int slabsNeeded = dist;
        int stringNeeded = 1 + Math.round(dist / 2);
        int slabsHad = 0;
        int stringHad = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null) continue;
            String name = stack.func_77973_b().func_77658_a();
            if (name.equals("item.string")) {
                stringHad += stack.field_77994_a;
            }
            if (!name.equals("tile.woodSlab")) continue;
            slabsHad += stack.field_77994_a;
        }
        if (slabsHad >= slabsNeeded && stringHad >= stringNeeded) {
            return true;
        }
        Builder.tell(player, "You need at least " + slabsNeeded + " slabs and " + stringNeeded + " strings to build this bridge.");
        return false;
    }

    private static void takeMaterials(EntityPlayer player, int dist) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        int slabsNeeded = dist;
        int stringNeeded = 1 + Math.round(dist / 2);
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null) continue;
            String name = stack.func_77973_b().func_77658_a();
            if (name.equals("item.string")) {
                if (stack.field_77994_a > stringNeeded) {
                    Main.snw.sendToServer((IMessage)new bridgeMessage(2, 0, 0, 0, i, stack.field_77994_a - stringNeeded));
                    stringNeeded = 0;
                } else {
                    stringNeeded -= stack.field_77994_a;
                    Main.snw.sendToServer((IMessage)new bridgeMessage(2, 0, 0, 0, i, 0));
                    continue;
                }
            }
            if (!name.equals("tile.woodSlab")) continue;
            if (stack.field_77994_a > slabsNeeded) {
                Main.snw.sendToServer((IMessage)new bridgeMessage(2, 0, 0, 0, i, stack.field_77994_a - slabsNeeded));
                slabsNeeded = 0;
                continue;
            }
            slabsNeeded -= stack.field_77994_a;
            Main.snw.sendToServer((IMessage)new bridgeMessage(2, 0, 0, 0, i, 0));
        }
    }

    private static boolean addSlab(World world, LinkedList<SlabPos> list, int x, int y, int z, int level, boolean rotate) {
        BlockPos pos = rotate ? new BlockPos(z, y, x) : new BlockPos(x, y, z);
        boolean isClear = Main.breakThroughBlocks || world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_176200_f(world, pos);
        list.add(new SlabPos(pos, level, rotate));
        if (!isClear) {
            Builder.spawnSmoke(world, pos, 15);
        }
        return isClear;
    }

    private static void spawnSmoke(World world, BlockPos pos, int times) {
        if (times > 0) {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
            final World finworld = world;
            final BlockPos finPos = pos;
            final int finTimes = times - 1;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Builder.spawnSmoke(finworld, finPos, finTimes);
                }
            }, 1000L);
        }
    }

    private static void buildBridge(World world, LinkedList<SlabPos> bridge, int type) {
        if (!bridge.isEmpty()) {
            SlabPos slab = bridge.pop();
            Main.snw.sendToServer((IMessage)new bridgeMessage(1, slab.x, slab.y, slab.z, slab.level, (slab.rotate ? 1 : 0) + 2 * type));
            Builder.spawnSmoke(world, new BlockPos(slab.x, slab.y, slab.z), 1);
            Main.snw.sendToServer((IMessage)new bridgeMessage(0, slab.x, slab.y, slab.z, 1, 0));
            final World finworld = world;
            final LinkedList<SlabPos> finBridge = bridge;
            final int finType = type;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    Builder.buildBridge(finworld, finBridge, finType);
                }
            }, 100L);
        }
    }

    private static int getWoodType(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            String name;
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null || !(name = stack.func_77973_b().func_77658_a()).equals("tile.woodSlab")) continue;
            return stack.func_77952_i();
        }
        return 0;
    }

    private static void resetFov(float toFov) {
        if (Main.zoomOnAim && toFov != 0.0f) {
            Minecraft.func_71410_x().field_71474_y.field_74334_X = toFov;
        }
    }

    private static void tell(EntityPlayer playerIn, String message) {
        playerIn.func_145747_a(new ChatComponentText("[Rope Bridge]: " + message).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_AQUA)));
    }
}

