/*
 * Decompiled with CFR 0.152.
 */
package com.czechmate777.ropebridge;

import com.czechmate777.ropebridge.CommonProxy;
import com.czechmate777.ropebridge.RopeBridgeCommand;
import com.czechmate777.ropebridge.blocks.ModBlocks;
import com.czechmate777.ropebridge.bridgeMessage;
import com.czechmate777.ropebridge.bridgeMessageHandler;
import com.czechmate777.ropebridge.items.ModItems;
import net.minecraft.command.ICommand;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="ropebridge", name="Rope Bridge Mod", version="1.3", acceptedMinecraftVersions="[1.8]")
public class Main {
    public static final String MODID = "ropebridge";
    public static final String MODNAME = "Rope Bridge Mod";
    public static final String VERSION = "1.3";
    public static SimpleNetworkWrapper snw;
    public static Configuration config;
    public static int maxBridgeDistance;
    public static int bridgeDroopFactor;
    public static float bridgeYOffset;
    public static boolean zoomOnAim;
    public static boolean breakThroughBlocks;
    public static boolean ignoreSlopeWarnings;
    public static boolean customAchievements;
    public static Achievement craftAchievement;
    public static Achievement buildAchievement;
    @SidedProxy(clientSide="com.czechmate777.ropebridge.ClientProxy", serverSide="com.czechmate777.ropebridge.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance
    public static Main instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        proxy.preInit(e);
        config = new Configuration(e.getSuggestedConfigurationFile());
        config.load();
        maxBridgeDistance = config.getInt("maxBridgeDistance", "general", 400, 1, 1000, "Max length of bridges made be Grappling Gun.");
        bridgeDroopFactor = config.getInt("bridgeDroopFactor", "general", 100, 0, 100, "Percent of slack the bridge will have, causing it to hang.");
        bridgeYOffset = config.getFloat("bridgeYOffset", "general", -0.3f, -1.0f, 1.0f, "Generated bridges will be raised or lowered by this ammount in blocks.\nDefault is just below user's feet.");
        zoomOnAim = config.getBoolean("zoomOnAim", "general", true, "Turn this off if issues come up with Optifine.");
        breakThroughBlocks = config.getBoolean("breakThroughBlocks", "general", false, "If enabled, all blocks that dare stand in a bridge's way will be broken.\nVery useful in creative mode.");
        ignoreSlopeWarnings = config.getBoolean("ignoreSlopeWarnings", "general", false, "Set true to ignore all slope warnings and allow building of very steep bridges.");
        customAchievements = config.getBoolean("customAchievements", "general", true, "Custom crafting and building achievements.");
        config.save();
        if (customAchievements) {
            craftAchievement = new Achievement("achievement.grapplingGun", "grapplingGun", 8, 2, ModItems.bridgeBuilder, AchievementList.field_76012_o);
            craftAchievement.func_75971_g();
            buildAchievement = new Achievement("achievement.buildBridge", "buildBridge", 10, 2, ModBlocks.bridgeBlock2, craftAchievement);
            buildAchievement.func_75971_g();
        }
        snw = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        snw.registerMessage(bridgeMessageHandler.class, bridgeMessage.class, 0, Side.SERVER);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new RopeBridgeCommand());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    static {
        instance = new Main();
    }
}

