/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTJson;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.item.IItemRendererCustom;
import jp.ngt.ngtlib.item.ItemRenderHandler;
import jp.ngt.ngtlib.renderer.NGTParticle;
import jp.ngt.ngtlib.sound.MovingSoundCustom;
import jp.ngt.ngtlib.sound.NGTSound;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.ngtlib.util.PackInfo;
import jp.ngt.ngtlib.util.VersionChecker;
import jp.ngt.rtm.CommonProxy;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMEntity;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMSound;
import jp.ngt.rtm.block.ParticleSpark;
import jp.ngt.rtm.block.tileentity.RenderDecoration;
import jp.ngt.rtm.entity.EntityMeltedMetalFX;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.parts.EntityArtillery;
import jp.ngt.rtm.entity.train.util.FormationManager;
import jp.ngt.rtm.entity.vehicle.EntityVehicle;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.entity.vehicle.IUpdateVehicle;
import jp.ngt.rtm.event.RTMEventHandlerClient;
import jp.ngt.rtm.event.RTMKeyHandlerClient;
import jp.ngt.rtm.event.RTMTickHandlerClient;
import jp.ngt.rtm.gui.camera.Camera;
import jp.ngt.rtm.modelpack.cfg.FirearmConfig;
import jp.ngt.rtm.modelpack.init.ModelPackLoadThread;
import jp.ngt.rtm.modelpack.model.ModelMissing;
import jp.ngt.rtm.modelpack.modelset.ModelSetFirearm;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.sound.MovingSoundEntity;
import jp.ngt.rtm.sound.MovingSoundMaker;
import jp.ngt.rtm.sound.MovingSoundTileEntity;
import jp.ngt.rtm.sound.SoundUpdaterTrain;
import jp.ngt.rtm.sound.SoundUpdaterVehicle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static final byte ViewMode_Artillery = 0;
    public static final byte ViewMode_SR = 1;
    public static final byte ViewMode_AMR = 2;
    public static final byte ViewMode_NVD = 3;
    public static final byte ViewMode_Camera = 4;
    private final ModelBase missing = new ModelMissing();
    private final ResourceLocation texture = new ResourceLocation("rtm", "textures/missing.png");
    private byte connectionState = 0;
    private final FormationManager fmClient = new FormationManager(true);
    private List<TileEntityLargeRailCore> unloadedRails = new ArrayList<TileEntityLargeRailCore>();

    @Override
    public void preInit() {
        this.versionCheck();
        RTMEntity.initClient();
        RTMBlock.initClient();
        RTMItem.initClient();
        MinecraftForge.EVENT_BUS.register((Object)new RTMEventHandlerClient(Minecraft.func_71410_x()));
        RTMKeyHandlerClient.init();
    }

    private void versionCheck() {
        if (!RTMCore.versionCheck) {
            return;
        }
        List fileList = NGTFileLoader.findFile(file -> file.getName().startsWith("pack") && file.getName().endsWith(".json"));
        for (File file2 : fileList) {
            try {
                String json = NGTText.readText((File)file2, (boolean)false, (String)"UTF-8");
                PackInfo info = (PackInfo)NGTJson.getObjectFromJson((String)json, PackInfo.class);
                if (info == null) continue;
                VersionChecker.addToCheckList((PackInfo)info);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        VersionChecker.addToCheckList((PackInfo)new PackInfo(RTMCore.metadata.name, RTMCore.metadata.url, RTMCore.metadata.updateUrl, RTMCore.metadata.version));
    }

    @Override
    public void init() {
        ModelPackLoadThread thread = new ModelPackLoadThread(Side.CLIENT);
        thread.start();
        MinecraftForge.EVENT_BUS.register((Object)RTMKeyHandlerClient.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new RTMTickHandlerClient());
        RTMBlock.initClient2();
        RTMItem.initClient2();
        ItemRenderHandler.INSTANCE.register(RTMItem.decoration_block, (IItemRendererCustom)new RenderDecoration());
        NGTParticle.INSTANCE.register(100, (particleID, worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, p_178902_15_) -> new ParticleSpark(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn));
    }

    @Override
    public void complete() {
        RTMSound.init();
    }

    @Override
    public IUpdateVehicle getSoundUpdater(EntityVehicleBase vehicle) {
        if (vehicle instanceof EntityTrainBase) {
            return new SoundUpdaterTrain(NGTUtilClient.getMinecraft().func_147118_V(), (EntityTrainBase)vehicle);
        }
        if (vehicle instanceof EntityVehicle) {
            return new SoundUpdaterVehicle<EntityVehicle>(NGTUtilClient.getMinecraft().func_147118_V(), (EntityVehicle)vehicle);
        }
        return null;
    }

    @Override
    public byte getConnectionState() {
        return this.connectionState;
    }

    @Override
    public void setConnectionState(byte par1) {
        this.connectionState = par1;
        NGTLog.debug((String)("[RTM](Client) Set connection state : " + par1));
    }

    @Override
    public void spawnModParticle(World world, double x, double y, double z, double mX, double mY, double mZ) {
        EntityMeltedMetalFX entityFX = new EntityMeltedMetalFX(world, x, y, z, mX, mY, mZ);
        entityFX.func_187117_a(NGTUtilClient.getIcon((String)"rtm:blocks/meltedMetal"));
        NGTUtilClient.getMinecraft().field_71452_i.func_78873_a((Particle)entityFX);
    }

    @Override
    public void renderMissingModel() {
        NGTUtilClient.getMinecraft().field_71446_o.func_110577_a(this.texture);
        this.missing.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
    }

    @Override
    public float getFov(EntityPlayer player, float fov) {
        switch (ClientProxy.getViewMode(player)) {
            case 0: {
                return 0.1f;
            }
            case 1: {
                return 0.25f;
            }
            case 2: {
                return 0.1f;
            }
            case 4: {
                return Camera.INSTANCE.getFov();
            }
        }
        return fov;
    }

    public static byte getViewMode(EntityPlayer player) {
        if (player != null && NGTUtilClient.getMinecraft().field_71474_y.field_74320_O == 0) {
            ItemStack stack;
            ItemStack helmet = player.field_71071_by.func_70440_f(3);
            if (helmet.func_77973_b() == RTMItem.nvd) {
                return 3;
            }
            if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityArtillery) {
                ModelSetFirearm set = (ModelSetFirearm)((EntityArtillery)player.func_184187_bx()).getResourceState().getResourceSet();
                if (((FirearmConfig)set.getConfig()).fpvMode) {
                    return 0;
                }
            }
            if ((stack = player.func_184614_ca()).func_77973_b() == RTMItem.sniper_rifle) {
                return 1;
            }
            if (stack.func_77973_b() == RTMItem.amr) {
                return 2;
            }
            if (stack.func_77973_b() == RTMItem.camera) {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public void playSound(Entity entity, String sound, float vol, float pitch) {
        if (sound == null) {
            NGTLog.debug((String)"Proxy:Sound is null");
            return;
        }
        if (NGTUtil.isServer()) {
            super.playSound(entity, sound, vol, pitch);
        } else {
            MovingSoundEntity ms = MovingSoundMaker.create(entity, sound, false);
            if (ms != null) {
                ClientProxy.playSound(ms, vol, pitch);
            }
        }
    }

    @Override
    public void playSound(TileEntity entity, String sound, float vol, float pitch) {
        if (sound == null) {
            NGTLog.debug((String)"Proxy:Sound is null");
            return;
        }
        if (NGTUtil.isServer()) {
            super.playSound(entity, sound, vol, pitch);
        } else {
            MovingSoundTileEntity ms = MovingSoundMaker.create(entity, sound, false);
            if (ms != null) {
                ClientProxy.playSound(ms, vol, pitch);
            }
        }
    }

    public static void playSound(MovingSoundCustom sound, float vol, float pitch) {
        sound.setVolume(vol);
        sound.setPitch(pitch);
        NGTSound.playSound((ISound)sound);
    }

    @Override
    public FormationManager getFormationManager() {
        return NGTUtil.isServer() ? super.getFormationManager() : this.fmClient;
    }
}

