/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block;

import jp.ngt.ngtlib.block.BlockContainerCustom;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.block.tileentity.TileEntityConverter;
import jp.ngt.rtm.block.tileentity.TileEntityConverterCore;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockConverter
extends BlockContainerCustom {
    private static int[][] pos_iron = new int[][]{{-3, 0, -1}, {-3, 0, 0}, {-3, 0, 1}, {3, 0, -1}, {3, 0, 0}, {3, 0, 1}, {-3, 1, -1}, {-3, 1, 0}, {-3, 1, 1}, {-1, 1, -1}, {-1, 1, 0}, {-1, 1, 1}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {1, 1, -1}, {1, 1, 0}, {1, 1, 1}, {3, 1, -1}, {3, 1, 0}, {3, 1, 1}, {-3, 2, -1}, {-3, 2, 0}, {-3, 2, 1}, {-2, 2, -1}, {-2, 2, 0}, {-2, 2, 1}, {-1, 2, -2}, {-1, 2, 2}, {0, 2, -2}, {0, 2, 2}, {1, 2, -2}, {1, 2, 2}, {2, 2, -1}, {2, 2, 0}, {2, 2, 1}, {3, 2, -1}, {3, 2, 0}, {3, 2, 1}, {-3, 3, -1}, {-3, 3, 0}, {-3, 3, 1}, {-2, 3, -1}, {-2, 3, 0}, {-2, 3, 1}, {-1, 3, -2}, {-1, 3, 2}, {0, 3, -2}, {0, 3, 2}, {1, 3, -2}, {1, 3, 2}, {2, 3, -1}, {2, 3, 0}, {2, 3, 1}, {3, 3, -1}, {3, 3, 0}, {3, 3, 1}, {-3, 4, 0}, {-2, 4, -1}, {-2, 4, 0}, {-2, 4, 1}, {-1, 4, -2}, {-1, 4, 2}, {0, 4, -2}, {0, 4, 2}, {1, 4, -2}, {1, 4, 2}, {2, 4, -1}, {2, 4, 0}, {2, 4, 1}, {3, 4, 0}, {-2, 5, -1}, {-2, 5, 0}, {-2, 5, 1}, {-1, 5, -2}, {-1, 5, 2}, {0, 5, -2}, {0, 5, 2}, {0, 5, 3}, {1, 5, -2}, {1, 5, 2}, {2, 5, -1}, {2, 5, 0}, {2, 5, 1}, {-2, 6, -1}, {-2, 6, 0}, {-2, 6, 1}, {-1, 6, -2}, {-1, 6, 2}, {0, 6, -2}, {0, 6, 2}, {1, 6, -2}, {1, 6, 2}, {2, 6, -1}, {2, 6, 0}, {2, 6, 1}, {-1, 7, -1}, {-1, 7, 0}, {-1, 7, 1}, {0, 7, -1}, {0, 7, 1}, {1, 7, -1}, {1, 7, 0}, {1, 7, 1}};
    private static int[][] pos_brick = new int[][]{{-1, 0, -1}, {-1, 0, 0}, {-1, 0, 1}, {0, 0, -1}, {0, 0, 1}, {1, 0, -1}, {1, 0, 0}, {1, 0, 1}};
    public final boolean isCore;

    public BlockConverter(boolean par1) {
        super(Material.field_151576_e);
        this.isCore = par1;
        this.func_149715_a(par1 ? 1.0f : 0.0f);
        if (par1) {
            this.setAABB(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0));
        }
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        if (this.isCore) {
            return new TileEntityConverterCore();
        }
        return new TileEntityConverter();
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        if (this == RTMBlock.converterCore) {
            entity.func_70097_a(DamageSource.field_76371_c, 1.0f);
            entity.func_70015_d(1);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile0;
        if (!world.field_72995_K && (tile0 = BlockUtil.getTileEntity((IBlockAccess)world, (BlockPos)pos)) instanceof TileEntityConverter) {
            TileEntityConverterCore tile1 = ((TileEntityConverter)tile0).getCore();
            int tx = tile1.getX();
            int ty = tile1.getY();
            int tz = tile1.getZ();
            if (tile1 != null && BlockUtil.getBlock((IBlockAccess)world, (int)tx, (int)ty, (int)tz) == RTMBlock.converterCore) {
                BlockConverter.createConverter(world, tx, ty - 4, tz, tile1.getDirection(), true);
                BlockConverter.func_180635_a((World)world, (BlockPos)new BlockPos(tx, ty - 4, tz), (ItemStack)new ItemStack(RTMItem.steel_ingot, 64, 0));
                BlockConverter.func_180635_a((World)world, (BlockPos)new BlockPos(tx, ty - 4, tz), (ItemStack)new ItemStack(RTMItem.steel_ingot, 64, 0));
                BlockConverter.func_180635_a((World)world, (BlockPos)new BlockPos(tx, ty - 4, tz), (ItemStack)new ItemStack(RTMItem.steel_ingot, 64, 0));
                BlockConverter.func_180635_a((World)world, (BlockPos)new BlockPos(tx, ty - 4, tz), (ItemStack)new ItemStack(RTMItem.steel_ingot, 16, 0));
            }
        }
    }

    public static byte shouldCreateConverter(World world, int x, int y, int z) {
        if (BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)(y + 2), (int)z) != RTMBlock.fireBrick) {
            return -1;
        }
        for (int i = 2; i < 7; ++i) {
            for (int j = 0; j < pos_brick.length; ++j) {
                if (BlockUtil.getBlock((IBlockAccess)world, (int)(x + pos_brick[j][0]), (int)(y + i), (int)(z + pos_brick[j][2])) == RTMBlock.fireBrick) continue;
                return -1;
            }
        }
        for (int i = 0; i < 4; ++i) {
            boolean flag = true;
            for (int j = 0; j < pos_iron.length; ++j) {
                int[] p0 = BlockUtil.rotateBlockPos((byte)((byte)i), (int)pos_iron[j][0], (int)pos_iron[j][1], (int)pos_iron[j][2]);
                if (BlockUtil.getBlock((IBlockAccess)world, (int)(x + p0[0]), (int)(y + p0[1]), (int)(z + p0[2])) == RTMBlock.steelMaterial) continue;
                flag = false;
            }
            if (!flag) continue;
            return (byte)i;
        }
        return -1;
    }

    public static void createConverter(World world, int x, int y, int z, byte dir, boolean setAir) {
        if (setAir) {
            BlockUtil.setAir((World)world, (int)x, (int)(y + 4), (int)z);
            BlockUtil.setAir((World)world, (int)x, (int)(y + 2), (int)z);
        } else {
            BlockUtil.setBlock((World)world, (int)x, (int)(y + 4), (int)z, (Block)RTMBlock.converterCore, (int)0, (int)2);
            TileEntityConverterCore tile = (TileEntityConverterCore)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)(y + 4), (int)z);
            tile.setDirection(dir);
            BlockConverter.setConverterBlock(world, x, y + 2, z, x, y + 4, z);
        }
        for (int i = 2; i < 7; ++i) {
            for (int j = 0; j < pos_brick.length; ++j) {
                if (setAir) {
                    BlockUtil.setAir((World)world, (int)(x + pos_brick[j][0]), (int)(y + i), (int)(z + pos_brick[j][2]));
                    continue;
                }
                BlockConverter.setConverterBlock(world, x + pos_brick[j][0], y + i, z + pos_brick[j][2], x, y + 4, z);
            }
        }
        for (int j = 0; j < pos_iron.length; ++j) {
            int[] p0 = BlockUtil.rotateBlockPos((byte)dir, (int)pos_iron[j][0], (int)pos_iron[j][1], (int)pos_iron[j][2]);
            if (setAir) {
                BlockUtil.setAir((World)world, (int)(x + p0[0]), (int)(y + p0[1]), (int)(z + p0[2]));
                continue;
            }
            BlockConverter.setConverterBlock(world, x + p0[0], y + p0[1], z + p0[2], x, y + 4, z);
        }
    }

    private static void setConverterBlock(World world, int x, int y, int z, int coreX, int coreY, int coreZ) {
        BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)RTMBlock.converterBase, (int)0, (int)2);
        TileEntityConverter tile = (TileEntityConverter)BlockUtil.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z);
        tile.setCorePos(coreX, coreY, coreZ);
    }
}

