/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block;

import java.util.List;
import java.util.Random;
import jp.ngt.ngtlib.block.BlockLiquidBase;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMFluid;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFurnaceFire
extends BlockLiquidBase {
    private static final Item itemIronOre = Item.func_150898_a((Block)Blocks.field_150366_p);

    public BlockFurnaceFire(Fluid fluid, boolean light) {
        super(fluid, RTMMaterial.melted);
        this.func_149715_a(light ? 1.0f : 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180650_b(world, pos, state, random);
        if (!world.field_72995_K) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int meta = BlockUtil.getMetadata((IBlockAccess)world, (BlockPos)pos);
            if (this == RTMFluid.furnaceFire) {
                IBlockState state2;
                Block block;
                if (meta == 0 && (block = (state2 = BlockUtil.getBlockState((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)).func_177230_c()) != RTMBlock.fireBrick && block != RTMBlock.hotStoveBrick && state2.func_185915_l()) {
                    BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150480_ab, (int)0, (int)2);
                }
            } else if (this == RTMFluid.exhaustGas) {
                if (BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)(y + 1), (int)z) == RTMFluid.furnaceFire) {
                    int m1 = BlockUtil.getMetadata((IBlockAccess)world, (int)x, (int)(y + 1), (int)z);
                    BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)RTMFluid.furnaceFire, (int)m1, (int)2);
                    BlockUtil.setBlock((World)world, (int)x, (int)(y + 1), (int)z, (Block)RTMFluid.exhaustGas, (int)meta, (int)2);
                    world.func_180497_b(new BlockPos(x, y + 1, z), (Block)this, this.func_149738_a(world), 0);
                } else if (BlockUtil.isAir((IBlockAccess)world, (int)x, (int)(y + 1), (int)z) && random.nextInt(10) == 0) {
                    if (meta > 0) {
                        BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)RTMFluid.exhaustGas, (int)(meta - 1), (int)2);
                    } else {
                        BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150350_a, (int)0, (int)2);
                    }
                }
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        boolean flag1 = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (entity instanceof EntityItem) {
            ItemStack itemstack0 = ((EntityItem)entity).func_92059_d();
            int sizeCoke = 0;
            int sizeIron = 0;
            boolean isIron = false;
            if (itemstack0.func_77973_b() == RTMItem.coke) {
                sizeCoke = itemstack0.func_190916_E() / 2;
                entity.func_70110_aj();
                flag1 = false;
            } else if (itemstack0.func_77973_b() == Items.field_151044_h && itemstack0.func_77952_i() == 1) {
                sizeCoke = itemstack0.func_190916_E() / 8;
                entity.func_70110_aj();
                flag1 = false;
            } else if (itemstack0.func_77973_b() == itemIronOre) {
                sizeIron = itemstack0.func_190916_E();
                isIron = true;
                entity.func_70110_aj();
                flag1 = false;
            }
            if (!(sizeCoke <= 0 && sizeIron <= 0 || world.field_72995_K)) {
                List list = world.func_72872_a(EntityItem.class, new AxisAlignedBB((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0));
                if (list != null && !list.isEmpty()) {
                    int i2 = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        EntityItem entityItem = (EntityItem)list.get(i);
                        ItemStack itemstack1 = entityItem.func_92059_d();
                        i2 = itemstack1.func_77973_b() == RTMItem.coke ? itemstack1.func_190916_E() / 2 : (itemstack1.func_77973_b() == Items.field_151044_h && itemstack1.func_77952_i() == 1 ? itemstack1.func_190916_E() / 8 : 0);
                        if (i2 <= 0) continue;
                        if (sizeCoke + i2 > sizeIron) {
                            itemstack1.func_190920_e(sizeCoke + i2 - sizeIron);
                            entityItem.func_92058_a(itemstack1);
                            sizeCoke = sizeIron;
                            continue;
                        }
                        sizeCoke += i2;
                        entityItem.func_70106_y();
                    }
                }
                if (isIron) {
                    if (sizeCoke == 0) {
                        return;
                    }
                    if (sizeCoke < sizeIron) {
                        itemstack0.func_190918_g(sizeCoke);
                        ((EntityItem)entity).func_92058_a(itemstack0);
                        sizeIron = sizeCoke;
                    } else {
                        entity.func_70106_y();
                    }
                } else {
                    if (sizeIron == 0) {
                        return;
                    }
                    if (sizeCoke > sizeIron) {
                        itemstack0.func_190918_g(sizeIron);
                        ((EntityItem)entity).func_92058_a(itemstack0);
                        sizeCoke = sizeIron;
                    } else {
                        entity.func_70106_y();
                    }
                }
                this.onCollidedIronOre(world, x, y, z, sizeIron);
            }
            if (flag1) {
                entity.field_70181_x = 0.2f;
                entity.field_70159_w = (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f;
                entity.field_70179_y = (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f;
                entity.func_184185_a(SoundEvents.field_187659_cY, 0.4f, 2.0f + world.field_73012_v.nextFloat() * 0.4f);
            }
        }
        if (flag1) {
            entity.func_70097_a(DamageSource.field_76371_c, 1.0f);
            entity.func_70015_d(5);
        }
    }

    protected void onCollidedIronOre(World world, int x, int y, int z, int amount) {
        if (BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) instanceof BlockFurnaceFire) {
            if (BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)y, (int)z) == RTMFluid.furnaceFire && world.field_73012_v.nextInt(10) == 0) {
                int meta = BlockUtil.getMetadata((IBlockAccess)world, (int)x, (int)y, (int)z);
                amount += world.field_73012_v.nextInt(meta + 1);
                if (world.field_73012_v.nextInt(5) == 0) {
                    BlockUtil.setBlock((World)world, (int)x, (int)y, (int)z, (Block)RTMFluid.exhaustGas, (int)15, (int)2);
                }
            }
            this.onCollidedIronOre(world, x, y - 1, z, amount);
        } else {
            while (amount > 0 && BlockUtil.getBlock((IBlockAccess)world, (int)x, (int)y, (int)z) instanceof BlockFurnaceFire) {
                BlockUtil.setAir((World)world, (int)x, (int)y, (int)z);
                amount = BlockLiquidBase.addLiquid((World)world, (int)x, (int)y, (int)z, (Block)RTMFluid.liquefiedPigIron, (int)amount, (boolean)true);
                ++y;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        IBlockState state;
        if (this == RTMFluid.furnaceFire && (state = BlockUtil.getBlockState((IBlockAccess)world, (int)x, (int)(y + 1), (int)z)).func_185904_a() == Material.field_151579_a && !state.func_185914_p()) {
            double d5 = (float)x + random.nextFloat();
            double d6 = y;
            double d7 = (float)z + random.nextFloat();
            world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, d5, d6, d7, 0.0, 0.0, 0.0, new int[0]);
            if (random.nextInt(200) == 0) {
                world.func_184134_a((double)x, (double)y, (double)z, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    protected void meltBlock(World world, int x, int y, int z) {
        if (this == RTMFluid.furnaceFire) {
            super.meltBlock(world, x, y, z);
        }
    }
}

