/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.decoration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTJson;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.block.decoration.DecorationModel;
import jp.ngt.rtm.network.PacketNotice;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class DecorationStore {
    public static final DecorationStore INSTANCE = new DecorationStore();
    public static final String PACKET_PREFIX = "decoration:";
    public static final String FILE_SUFFIX = ".json";
    public static final String SAVE_DIR = "ngt/rtm/decoration";
    private final List<ResourceLocation> icons = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> unregisteredIcons = new ArrayList<ResourceLocation>();
    private final Map<String, DecorationModel> modelMap = new HashMap<String, DecorationModel>();
    private final Map<String, DecorationModel> serverModelMap = new HashMap<String, DecorationModel>();
    private boolean needReloadTexture;

    private DecorationStore() {
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModelOnClient(DecorationModel model) {
        String json = model.toJson();
        RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketNotice(0, PACKET_PREFIX + json));
    }

    @SideOnly(value=Side.CLIENT)
    public void setModel(String json) {
        try {
            DecorationModel model = DecorationModel.fromJson(json);
            this.modelMap.put(model.name, model);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerModel(String json, World world) {
        try {
            DecorationModel model = DecorationModel.fromJson(json);
            this.registerModel(model, world);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerModel(DecorationModel model, World world) {
        this.serverModelMap.put(model.name, model);
        this.saveModel(model, world);
        RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketNotice(1, PACKET_PREFIX + NGTJson.getJsonFromObject((Object)model)));
    }

    public void saveModel(DecorationModel model, World world) {
        File saveFolder = this.getSaveFolder(world);
        NGTJson.writeToJson((String)NGTJson.getJsonFromObject((Object)model), (File)new File(saveFolder, model.name + FILE_SUFFIX));
    }

    public void loadModels(World world) {
        String[] files;
        File saveFolder = this.getSaveFolder(world);
        for (String fileName : files = saveFolder.list()) {
            File file = new File(saveFolder, fileName);
            if (!file.getName().endsWith(FILE_SUFFIX)) continue;
            try {
                DecorationModel model = (DecorationModel)NGTJson.getObjectFromJson((String)NGTText.readText((File)file, (boolean)false, (String)""), DecorationModel.class);
                this.registerModel(model, world);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public File getSaveFolder(World world) {
        File worldFolder = world.func_72860_G().func_75765_b();
        File saveFolder = new File(worldFolder, SAVE_DIR);
        if (!saveFolder.exists()) {
            saveFolder.mkdirs();
        }
        return saveFolder;
    }

    public DecorationModel getModel(String name) {
        return this.modelMap.containsKey(name) ? this.modelMap.get(name) : DecorationModel.DEFAULT_MODEL;
    }

    public List<DecorationModel> getModels() {
        ArrayList<DecorationModel> list = new ArrayList<DecorationModel>();
        for (Map.Entry<String, DecorationModel> entry : this.modelMap.entrySet()) {
            list.add(entry.getValue());
        }
        list.sort(new Comparator<DecorationModel>(){

            @Override
            public int compare(DecorationModel o1, DecorationModel o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        return list;
    }

    public void onTextureStitch(TextureMap map) {
        this.loadTexture();
        for (ResourceLocation rl : this.unregisteredIcons) {
            map.func_174942_a(rl);
        }
    }

    private void loadTexture() {
        this.icons.clear();
        this.unregisteredIcons.clear();
        this.needReloadTexture = true;
        List fileList = NGTFileLoader.findFile(file -> file.getName().startsWith("deco") && file.getName().endsWith(".png"));
        for (File file2 : fileList) {
            String s = file2.getAbsolutePath().replace('\\', '/');
            s = s.split("assets/")[1];
            s = s.replaceAll("/textures/", ":");
            s = s.replaceAll(".png", "");
            this.unregisteredIcons.add(new ResourceLocation(s));
        }
        this.icons.addAll(this.unregisteredIcons);
    }

    private void loadMCIcons() {
        if (this.needReloadTexture) {
            TextureMap texturemap = Minecraft.func_71410_x().func_147117_R();
            Map iconMap = (Map)NGTUtil.getField(TextureMap.class, (Object)texturemap, (String[])new String[]{"mapUploadedSprites", "field_94252_e"});
            for (Map.Entry entry : iconMap.entrySet()) {
                this.icons.add(new ResourceLocation((String)entry.getKey()));
            }
            this.icons.sort(new Comparator<ResourceLocation>(){

                @Override
                public int compare(ResourceLocation o1, ResourceLocation o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            this.needReloadTexture = false;
        }
    }

    public List<ResourceLocation> getAllIcon() {
        this.loadMCIcons();
        return this.icons;
    }
}

