/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.decoration;

import jp.ngt.rtm.block.decoration.Face;

public class Element
implements Cloneable {
    public String name;
    public Face[] faces;

    public Element clone() {
        Element element = new Element();
        element.name = this.name;
        element.faces = new Face[this.faces.length];
        for (int i = 0; i < element.faces.length; ++i) {
            element.faces[i] = this.faces[i].clone();
        }
        return element;
    }

    public void addVec(float[] vec3, boolean lockUV) {
        for (Face face : this.faces) {
            face.addVec(vec3, lockUV);
        }
    }

    public static Element getDefaultElement() {
        Element element = new Element();
        element.name = "default";
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        Face front = new Face();
        front.name = "front";
        front.texture = "minecraft:decoration/deco_platform_side";
        front.shadow = 0.8f;
        front.type = Face.FaceType.FRONT;
        front.vertex = new float[][]{{0.0f, 1.0f, 1.0f, minU, minV}, {0.0f, 0.0f, 1.0f, minU, maxV}, {1.0f, 0.0f, 1.0f, maxU, maxV}, {1.0f, 1.0f, 1.0f, maxU, minV}};
        Face back = new Face();
        back.name = "back";
        back.texture = "minecraft:blocks/log_birch";
        back.shadow = 0.8f;
        back.type = Face.FaceType.BACK;
        back.vertex = new float[][]{{1.0f, 1.0f, 0.0f, minU, minV}, {1.0f, 0.0f, 0.0f, minU, maxV}, {0.0f, 0.0f, 0.0f, maxU, maxV}, {0.0f, 1.0f, 0.0f, maxU, minV}};
        Face left = new Face();
        left.name = "left";
        left.texture = "rtm:blocks/fireBrick";
        left.shadow = 0.6f;
        left.type = Face.FaceType.LEFT;
        left.vertex = new float[][]{{1.0f, 1.0f, 1.0f, minU, minV}, {1.0f, 0.0f, 1.0f, minU, maxV}, {1.0f, 0.0f, 0.0f, maxU, maxV}, {1.0f, 1.0f, 0.0f, maxU, minV}};
        Face right = new Face();
        right.name = "right";
        right.texture = "minecraft:blocks/bookshelf";
        right.shadow = 0.6f;
        right.type = Face.FaceType.RIGHT;
        right.vertex = new float[][]{{0.0f, 1.0f, 0.0f, minU, minV}, {0.0f, 0.0f, 0.0f, minU, maxV}, {0.0f, 0.0f, 1.0f, maxU, maxV}, {0.0f, 1.0f, 1.0f, maxU, minV}};
        Face top = new Face();
        top.name = "top";
        top.texture = "minecraft:decoration/deco_platform_top";
        top.shadow = 1.0f;
        top.type = Face.FaceType.TOP;
        top.vertex = new float[][]{{0.0f, 1.0f, 0.0f, minU, minV}, {0.0f, 1.0f, 1.0f, minU, maxV}, {1.0f, 1.0f, 1.0f, maxU, maxV}, {1.0f, 1.0f, 0.0f, maxU, minV}};
        Face bottom = new Face();
        bottom.name = "bottom";
        bottom.texture = "sound_test:blocks/deco_test";
        bottom.shadow = 0.5f;
        bottom.type = Face.FaceType.BOTTOM;
        bottom.vertex = new float[][]{{0.0f, 0.0f, 1.0f, minU, minV}, {0.0f, 0.0f, 0.0f, minU, maxV}, {1.0f, 0.0f, 0.0f, maxU, maxV}, {1.0f, 0.0f, 1.0f, maxU, minV}};
        element.faces = new Face[]{front, back, left, right, top, bottom};
        return element;
    }
}

