/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import jp.ngt.ngtlib.item.IItemRendererCustom;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.block.decoration.DecorationModel;
import jp.ngt.rtm.block.decoration.DecorationStore;
import jp.ngt.rtm.block.decoration.Element;
import jp.ngt.rtm.block.decoration.Face;
import jp.ngt.rtm.block.tileentity.TileEntityDecoration;
import jp.ngt.rtm.item.ItemDecoration;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderDecoration
extends TileEntitySpecialRenderer<TileEntityDecoration>
implements IItemRendererCustom {
    public void render(TileEntityDecoration par1, double par2, double par4, double par6, float par8, int par9, float alpha) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)par2 + 0.0f), (float)((float)par4 + 0.0f), (float)((float)par6 + 0.0f));
        DecorationModel model = DecorationStore.INSTANCE.getModel(par1.getModelName());
        this.renderModel(model, true);
        GL11.glPopMatrix();
    }

    public void renderModel(DecorationModel model, boolean onWorld) {
        GLHelper.disableLighting();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        NGTUtilClient.bindTexture((ResourceLocation)TextureMap.field_110575_b);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        for (Element element : model.elements) {
            for (Face face : element.faces) {
                TextureAtlasSprite icon = NGTUtilClient.getIcon((String)face.texture);
                tessellator.setColorOpaque_F(face.shadow, face.shadow, face.shadow);
                this.addVertex(tessellator, icon, face.vertex[0]);
                this.addVertex(tessellator, icon, face.vertex[1]);
                this.addVertex(tessellator, icon, face.vertex[2]);
                this.addVertex(tessellator, icon, face.vertex[3]);
            }
        }
        tessellator.draw();
        GLHelper.enableLighting();
        if (onWorld) {
            NGTUtilClient.getMinecraft().field_71460_t.func_180436_i();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void addVertex(NGTTessellator tessellator, TextureAtlasSprite icon, float[] array) {
        float u = icon.func_94209_e() + (icon.func_94212_f() - icon.func_94209_e()) * array[3];
        float v = icon.func_94206_g() + (icon.func_94210_h() - icon.func_94206_g()) * array[4];
        tessellator.addVertexWithUV(array[0], array[1], array[2], u, v);
    }

    public void renderItem(ItemStack itemStack) {
        String name = ItemDecoration.getModelName(itemStack);
        DecorationModel model = DecorationStore.INSTANCE.getModel(name);
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)-1.0f);
        this.renderModel(model, false);
        GL11.glPopMatrix();
    }
}

