/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.NGTRenderer;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.block.tileentity.TileEntityFlag;
import jp.ngt.rtm.modelpack.cfg.FlagConfig;
import jp.ngt.rtm.modelpack.modelset.TextureSetFlag;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderFlag
extends TileEntitySpecialRenderer<TileEntityFlag> {
    private static ResourceLocation TEXTURE = new ResourceLocation("minecraft", "textures/ornament/iron.png");

    private void renderFlag(TileEntityFlag tileEntity, double par2, double par4, double par6, float par8) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2884);
        GL11.glTranslatef((float)((float)par2 + 0.5f), (float)((float)par4 + 0.0f), (float)((float)par6 + 0.5f));
        TextureSetFlag set = tileEntity.getResourceState().getResourceSet();
        this.renderPole(set);
        if (BlockUtil.getBlock((IBlockAccess)this.func_178459_a(), (BlockPos)tileEntity.func_174877_v().func_177984_a()) != RTMBlock.flag) {
            this.renderFlag(tileEntity, set);
        }
        GL11.glPopMatrix();
    }

    private void renderFlag(TileEntityFlag tileEntity, TextureSetFlag set) {
        GL11.glTranslatef((float)0.0f, (float)((FlagConfig)set.getConfig()).poleLength, (float)0.0f);
        float yaw = tileEntity.getRotation();
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        float wind = 1.0f;
        float windInv = 1.0f - wind;
        float h = ((FlagConfig)set.getConfig()).height;
        float w = ((FlagConfig)set.getConfig()).width;
        GL11.glShadeModel((int)7425);
        this.func_147499_a(set.texture);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        int resV = ((FlagConfig)set.getConfig()).resolutionV;
        int resU = ((FlagConfig)set.getConfig()).resolutionU;
        for (int i = 0; i < resV; ++i) {
            float v0 = (float)i / (float)resV;
            float v1 = (float)(i + 1) / (float)resV;
            for (int j = 0; j < resU; ++j) {
                float u0 = (float)j / (float)resU;
                float u1 = (float)(j + 1) / (float)resU;
                float u0w = u0 * w;
                float u1w = u1 * w;
                float r0 = this.getR(tileEntity.wave, u1, v0);
                float d0 = this.getWave(r0, u1);
                float nr0 = this.getNormalR(r0 + yaw);
                tessellator.setNormal(NGTMath.getSin((float)nr0), 0.0f, NGTMath.getCos((float)nr0));
                tessellator.addVertexWithUV(d0, -(v0 + windInv * u1w) * h, u1w * wind, u1, v0);
                float r1 = this.getR(tileEntity.wave, u1, v1);
                float d1 = this.getWave(r1, u1);
                float nr1 = this.getNormalR(r1 + yaw);
                tessellator.setNormal(NGTMath.getSin((float)nr1), 0.0f, NGTMath.getCos((float)nr1));
                tessellator.addVertexWithUV(d1, -(v1 + windInv * u1w) * h, u1w * wind, u1, v1);
                float r2 = this.getR(tileEntity.wave, u0, v1);
                float d2 = this.getWave(r2, u0);
                float nr2 = this.getNormalR(r2 + yaw);
                tessellator.setNormal(NGTMath.getSin((float)nr2), 0.0f, NGTMath.getCos((float)nr2));
                tessellator.addVertexWithUV(d2, -(v1 + windInv * u0w) * h, u0w * wind, u0, v1);
                float r3 = this.getR(tileEntity.wave, u0, v0);
                float d3 = this.getWave(r3, u0);
                float nr3 = this.getNormalR(r3 + yaw);
                tessellator.setNormal(NGTMath.getSin((float)nr3), 0.0f, NGTMath.getCos((float)nr3));
                tessellator.addVertexWithUV(d3, -(v0 + windInv * u0w) * h, u0w * wind, u0, v0);
            }
        }
        tessellator.draw();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)2884);
    }

    private void renderPole(TextureSetFlag set) {
        NGTTessellator tessellator = NGTTessellator.instance;
        this.func_147499_a(TEXTURE);
        tessellator.startDrawingQuads();
        NGTRenderer.renderPole((NGTTessellator)tessellator, (float)0.0625f, (float)((FlagConfig)set.getConfig()).poleLength, (boolean)true);
        tessellator.draw();
    }

    private float getR(float r, float u, float v) {
        return -NGTMath.toRadians((float)(r + 360.0f / (3.0f * u + 1.0f) * (v + 1.0f)));
    }

    private float getWave(float r, float u) {
        return NGTMath.getSin((float)r) * u * 0.15f;
    }

    private float getNormalR(float r) {
        return NGTMath.toRadians((float)(45.0f * NGTMath.getCos((float)r) + 90.0f));
    }

    public void render(TileEntityFlag par1, double par2, double par4, double par6, float par8, int par9, float alpha) {
        this.renderFlag(par1, par2, par4, par6, par8);
    }
}

