/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.TileEntityPlaceable;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.ScriptExecuter;
import jp.ngt.rtm.modelpack.cfg.MachineConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetMachine;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityMachineBase
extends TileEntityPlaceable
implements IResourceSelector,
ITickable {
    private ResourceState<ModelSetMachine> state = new ResourceState(this.getSubType(), this);
    private ScriptExecuter executer = new ScriptExecuter();
    private float pitch;
    public int tick;
    public boolean isGettingPower;
    protected Vec3 normal;
    private boolean yawFixed;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state.readFromNBT(nbt.func_74775_l("State"));
        this.pitch = nbt.func_74760_g("Pitch");
        this.yawFixed = nbt.func_74764_b("Yaw");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("State", (NBTBase)this.state.writeToNBT());
        nbt.func_74776_a("Pitch", this.pitch);
        return nbt;
    }

    public void func_73660_a() {
        ++this.tick;
        if (this.tick == Integer.MAX_VALUE) {
            this.tick = 0;
        }
        if (!this.func_145831_w().field_72995_K) {
            this.executer.execScript(this);
        }
    }

    public void setRotation(EntityPlayer player, float rotationInterval, boolean synch) {
        super.setRotation(player, rotationInterval, synch);
        this.pitch = -player.field_70125_A;
    }

    public void setRotation(float par1, boolean synch) {
        super.setRotation(par1, synch);
        this.yawFixed = true;
    }

    public float getPitch() {
        return this.pitch;
    }

    public Vec3 getNormal(float x, float y, float z, float pitch, float yaw) {
        if (this.normal == null) {
            this.normal = new Vec3((double)x, (double)y, (double)z);
        }
        return this.normal;
    }

    public void onActivate() {
        ModelSetMachine set = this.getResourceState().getResourceSet();
        if (this.field_145850_b.field_72995_K && ((MachineConfig)set.getConfig()).sound_OnActivate != null) {
            RTMCore.proxy.playSound((TileEntity)this, ((MachineConfig)set.getConfig()).sound_OnActivate, 1.0f, 1.0f);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass >= 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
        return bb;
    }

    public ResourceState<ModelSetMachine> getResourceState() {
        return this.state;
    }

    @Override
    public void updateResourceState() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            this.sendPacket();
            this.func_70296_d();
            BlockUtil.markBlockForUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        }
    }

    @Override
    public int[] getSelectorPos() {
        return new int[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()};
    }

    @Override
    public boolean closeGui(ResourceState par1) {
        return true;
    }

    protected abstract ResourceType getSubType();
}

