/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tileentity;

import java.util.Arrays;
import jp.ngt.ngtlib.block.TileEntityCustom;
import jp.ngt.ngtlib.item.ItemUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.gui.ContainerRTMWorkBench;
import jp.ngt.rtm.network.PacketNotice;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityTrainWorkBench
extends TileEntityCustom
implements ITickable {
    private ItemStack[] craftSlots = ItemUtil.getEmptyArray((int)30);
    public static final int Max_CraftingTime = 64;
    private int craftingTime = 0;
    private boolean isCrafting = false;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        Arrays.fill(this.craftSlots, ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = nbttaglist.func_150305_b(i);
            int j = nbt1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.craftSlots.length) continue;
            this.craftSlots[j] = new ItemStack(nbt1);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.craftSlots.length; ++i) {
            if (this.craftSlots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("Slot", (byte)i);
            this.craftSlots[i].func_77955_b(nbt1);
            tagList.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("Items", (NBTBase)tagList);
        return nbt;
    }

    public void func_73660_a() {
        if (this.isCrafting) {
            if (this.craftingTime < 64) {
                ++this.craftingTime;
            } else {
                this.craftingTime = 0;
                this.isCrafting = false;
            }
        }
    }

    public void readItemsFromTile(IInventory inventory, IInventory inv2) {
        int i;
        for (i = 0; i < 25; ++i) {
            inventory.func_70299_a(i, this.craftSlots[i]);
        }
        for (i = 25; i < 30; ++i) {
            inv2.func_70299_a(i - 25, this.craftSlots[i]);
        }
    }

    public void writeItemsToTile(IInventory inventory, IInventory inv2) {
        int i;
        for (i = 0; i < this.craftSlots.length; ++i) {
            this.craftSlots[i] = inventory.func_70301_a(i);
        }
        for (i = 25; i < 30; ++i) {
            this.craftSlots[i] = inv2.func_70301_a(i - 25);
        }
        this.sendPacket();
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public void setCraftingTime(int par1) {
        this.craftingTime = par1;
    }

    public void startCrafting(EntityPlayer player, boolean sendPacket) {
        this.craftingTime = 0;
        this.isCrafting = true;
        ContainerRTMWorkBench container = (ContainerRTMWorkBench)player.field_71070_bA;
        container.startCrafting();
        if (sendPacket) {
            String s = "StartCrafting";
            RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketNotice(0, s, (TileEntity)this));
        }
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }
}

