/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.block.tt;

import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.block.tt.TimeTable;
import jp.ngt.rtm.block.tt.TimeTableManager;

public class StationTimeTable {
    public final TimeTable timeTable;
    public final String station;
    public final byte track;
    private final int rowIndex;

    public StationTimeTable(String pTT, String pStation, int pTrack) {
        this.timeTable = TimeTableManager.INSTANCE.getTimeTable(pTT);
        this.station = pStation;
        this.track = (byte)pTrack;
        this.rowIndex = (Integer)this.timeTable.stationAxis.get((Object)this.station);
    }

    public int getMatchTrainIndex(int track) {
        int time;
        if (this.timeTable.useRealTime) {
            time = (int)(System.currentTimeMillis() / 1000L % 86400L);
        } else {
            int mcTime = 0;
            if (!NGTUtil.isServer()) {
                mcTime = (int)((NGTUtil.getClientWorld().func_72820_D() + 6000L) % 24000L);
            }
            time = mcTime * 86400 / 24000;
        }
        for (int i = 0; i < this.timeTable.ttData[this.rowIndex].length; ++i) {
            TimeTable.TTEntry entry = this.timeTable.ttData[this.rowIndex][i];
            if (time > entry.departureTime || track >= 0 && track != entry.trackNum) continue;
            return i;
        }
        return this.getSize();
    }

    public int getSize() {
        return this.timeTable.ttData[this.rowIndex].length;
    }

    public String getData(int trainId, int col) {
        return this.timeTable.ttData[this.rowIndex][trainId].data[col];
    }
}

