/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.command;

import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.parts.EntityArtillery;
import jp.ngt.rtm.entity.train.util.TrainState;
import jp.ngt.rtm.entity.vehicle.EntityVehicle;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.item.ItemAmmunition;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.cfg.FirearmConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetFirearm;
import net.minecraft.command.ICommandSender;

public enum ModelCtrl {
    NOTCH(s -> s.equals("notch"), obj -> obj instanceof EntityTrainBase, (target, player, order, value) -> {
        int notch = Integer.valueOf(value);
        return ((EntityTrainBase)target).setNotch(notch);
    }, "mctrl <train> notch <-8 ~ 5>"),
    DIR(s -> s.equals("dir"), obj -> obj instanceof EntityTrainBase, (target, player, order, value) -> {
        int dir = Integer.valueOf(value);
        ((EntityTrainBase)target).setTrainDirection(dir);
        return true;
    }, "mctrl <train> dir <0 or 1>"),
    DATA_MAP(s -> s.startsWith("dm:"), obj -> obj instanceof IResourceSelector, (target, player, order, value) -> {
        String dataName = order.replace("dm:", "");
        if (!((IResourceSelector)target).getResourceState().getDataMap().set(dataName, value, 3)) {
            NGTLog.sendChatMessage((ICommandSender)player, (String)("[" + dataName + "] is not key."), (Object[])new Object[0]);
            return false;
        }
        return true;
    }, "mctrl <?> dm:<data name> <(type)value>"),
    VEHICLE_STATE(s -> s.startsWith("state:"), obj -> obj instanceof EntityVehicleBase, (target, player, order, value) -> {
        String dataName = order.replace("state:", "");
        try {
            TrainState state = TrainState.valueOf(value);
            TrainState.TrainStateType type = TrainState.TrainStateType.valueOf(dataName);
            ((EntityVehicleBase)target).setVehicleState(type, state.data);
            return true;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            NGTLog.sendChatMessage((ICommandSender)player, (String)"Illegal argument.", (Object[])new Object[0]);
            return false;
        }
    }, "mctrl <vehicle> state:<data name> <value>"),
    V_MOV_DIST(s -> s.equals("move"), obj -> obj instanceof EntityVehicle, (target, player, order, value) -> {
        EntityVehicle vehicle = (EntityVehicle)target;
        double dist = Double.valueOf(value);
        vehicle.controller.setMoveDistance(vehicle, dist);
        return true;
    }, "mctrl <vehicle> move <distance>"),
    V_ADD_YAW(s -> s.equals("addYaw"), obj -> obj instanceof EntityVehicle || obj instanceof EntityArtillery, (target, player, order, value) -> {
        if (target instanceof EntityArtillery) {
            EntityArtillery firearm = (EntityArtillery)target;
            float yaw = Float.valueOf(value).floatValue();
            firearm.controller.addYaw(firearm, yaw);
        } else {
            EntityVehicle vehicle = (EntityVehicle)target;
            float yaw = Float.valueOf(value).floatValue();
            vehicle.controller.addYaw(vehicle, yaw);
        }
        return true;
    }, "mctrl <vehicle or artillery> addYaw <value>"),
    V_ADD_PITCH(s -> s.equals("addPitch"), obj -> obj instanceof EntityVehicle || obj instanceof EntityArtillery, (target, player, order, value) -> {
        if (target instanceof EntityArtillery) {
            EntityArtillery firearm = (EntityArtillery)target;
            float yaw = Float.valueOf(value).floatValue();
            firearm.controller.addPitch(firearm, -yaw);
        }
        return true;
    }, "mctrl <artillery> addPitch <value>"),
    FIRE(s -> s.equals("fire"), obj -> obj instanceof EntityArtillery, (target, player, order, value) -> {
        EntityArtillery firearm = (EntityArtillery)target;
        ItemAmmunition.BulletType type = ItemAmmunition.BulletType.getBulletType(((FirearmConfig)((ModelSetFirearm)firearm.getResourceState().getResourceSet()).getConfig()).ammoType);
        int count = Integer.valueOf(value);
        firearm.fire(null, type, count);
        return true;
    }, "mctrl <artillery> fire <number of bullet>"),
    NO_FUNC(s -> false, obj -> false, (target, player, order, value) -> false, "");

    public final CommandMatcher matcher;
    public final TargetFilter filter;
    public final CommandExecutor executor;
    public final String discription;

    private ModelCtrl(CommandMatcher par1, TargetFilter par2, CommandExecutor par3, String par4) {
        this.matcher = par1;
        this.filter = par2;
        this.executor = par3;
        this.discription = par4;
    }

    public static ModelCtrl getCommand(String par1) {
        for (ModelCtrl ctrl : ModelCtrl.values()) {
            if (!ctrl.matcher.match(par1)) continue;
            return ctrl;
        }
        return NO_FUNC;
    }

    public static interface CommandExecutor {
        public boolean exec(Object var1, ICommandSender var2, String var3, String var4);
    }

    public static interface TargetFilter {
        public boolean match(Object var1);
    }

    public static interface CommandMatcher {
        public boolean match(String var1);
    }
}

