/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.electric;

public enum SignalLevel {
    HIGH_SPEED_PROCEED(6, 1.2f, 1.5f),
    PROCEED(5, 0.9f, 1.2f),
    SLOW_DOWN(4, 0.6f, 0.9f),
    CAUTION(3, 0.3f, 0.6f),
    VIGILANCE(2, 0.3f, 0.6f),
    STOP(1, 0.0f, 0.0f);

    public final int level;
    public final float speedLowerLimit;
    public final float speedUpperLimit;

    private SignalLevel(int par1, float par2, float par3) {
        this.level = par1;
        this.speedLowerLimit = par2;
        this.speedUpperLimit = par3;
    }

    public static SignalLevel getSignal(int par1) {
        for (SignalLevel signal : SignalLevel.values()) {
            if (signal.level != par1) continue;
            return signal;
        }
        return STOP;
    }

    public static float getSpeed(int par1, float par2) {
        SignalLevel signal = SignalLevel.getSignal(par1);
        if (par2 > signal.speedUpperLimit) {
            return signal.speedUpperLimit;
        }
        if (par2 < signal.speedLowerLimit) {
            return signal.speedLowerLimit;
        }
        return par2;
    }
}

