/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.electric;

import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.TileEntityPlaceable;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.electric.IProvideElectricity;
import jp.ngt.rtm.modelpack.IResourceSelector;
import jp.ngt.rtm.modelpack.ScriptExecuter;
import jp.ngt.rtm.modelpack.cfg.SignalConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetSignal;
import jp.ngt.rtm.modelpack.state.ResourceState;
import jp.ngt.rtm.modelpack.state.ResourceStateWithBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySignal
extends TileEntityPlaceable
implements IProvideElectricity,
IResourceSelector,
ITickable {
    private ResourceStateWithBlock<ModelSetSignal> state = new ResourceStateWithBlock(RTMResource.SIGNAL, this);
    private ScriptExecuter executer = new ScriptExecuter();
    private TileEntity origTileEntity;
    public int blockDirection;
    private int signalLevel = 0;
    public int tick;

    public TileEntitySignal() {
        this.state.setBlock(Blocks.field_150350_a, 0);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state.readFromNBT(nbt.func_74775_l("State"));
        this.blockDirection = nbt.func_74762_e("blockDir");
        this.signalLevel = nbt.func_74762_e("Signal");
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            BlockUtil.markBlockForUpdate((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        }
        if (nbt.func_74764_b("BaseBlockData")) {
            this.origTileEntity = TileEntity.func_190200_a(null, (NBTTagCompound)nbt.func_74775_l("BaseBlockData"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("State", (NBTBase)this.state.writeToNBT());
        nbt.func_74768_a("blockDir", this.blockDirection);
        nbt.func_74768_a("Signal", this.signalLevel);
        if (this.origTileEntity != null) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            this.origTileEntity.func_189515_b(nbt2);
            nbt.func_74782_a("BaseBlockData", (NBTBase)nbt2);
        }
        return nbt;
    }

    public void func_73660_a() {
        ++this.tick;
        if (this.tick == Integer.MAX_VALUE) {
            this.tick = 0;
        }
        if (!this.func_145831_w().field_72995_K) {
            this.executer.execScript(this);
        }
    }

    @Override
    public int getElectricity() {
        return 0;
    }

    @Override
    public void setElectricity(int x, int y, int z, int level) {
        if (!this.field_145850_b.field_72995_K) {
            ModelSetSignal modelSet = (ModelSetSignal)this.getResourceState().getResourceSet();
            if (level > ((SignalConfig)modelSet.getConfig()).maxSignalLevel) {
                level = ((SignalConfig)modelSet.getConfig()).maxSignalLevel;
            }
            this.signalLevel = level;
            this.func_70296_d();
            this.sendPacket();
        }
    }

    public void setSignalProperty(String name, Block par1, int par2, EntityPlayer player, TileEntity tile) {
        this.state.setResourceName(name);
        this.state.setBlock(par1, this.func_145832_p());
        this.origTileEntity = tile;
        this.blockDirection = par2;
        this.setRotation(player, 15.0f, false);
        this.sendPacket();
        this.func_70296_d();
    }

    public TileEntity getOrigTileEntity() {
        return this.origTileEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public float getBlockDirection() {
        return (float)this.blockDirection * 90.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSignal() {
        return this.signalLevel;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSignal(int par1) {
        this.signalLevel = par1;
    }

    public Block getRenderBlock() {
        return ((ResourceStateWithBlock)this.getResourceState()).block;
    }

    public void setOrigBlock() {
        Block block = this.getRenderBlock();
        int meta = BlockUtil.getMetadata((IBlockAccess)this.func_145831_w(), (BlockPos)this.func_174877_v());
        BlockUtil.setBlock((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (Block)block, (int)meta, (int)3);
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v());
        if (this.origTileEntity != null && tile != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.origTileEntity.func_189515_b(nbt);
            tile.func_145839_a(nbt);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass >= 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int x = this.func_174877_v().func_177958_n();
        int y = this.func_174877_v().func_177956_o();
        int z = this.func_174877_v().func_177952_p();
        AxisAlignedBB bb = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1));
        return bb;
    }

    @Override
    public void updateResourceState() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.sendPacket();
        }
    }

    @Override
    public int[] getSelectorPos() {
        return new int[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()};
    }

    @Override
    public boolean closeGui(ResourceState par1) {
        return true;
    }

    public ResourceStateWithBlock<ModelSetSignal> getResourceState() {
        return this.state;
    }
}

