/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity;

import java.util.List;
import java.util.Random;
import jp.ngt.ngtlib.NGTCore;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.rtm.RTMBlock;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.item.ItemAmmunition;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBullet
extends EntityArrow {
    private static final DataParameter<Byte> BREAKABLE = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> AMMO_TYPE = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final int LIFE_ON_GROUND = 400;
    private static final int LIFE_IN_AIR = 1200;
    private ItemAmmunition.BulletType type;
    private int tileX = -1;
    private int tileY = -1;
    private int tileZ = -1;
    private Block landingBlock;
    private boolean inGround;
    private int ticksInGround;
    private int ticksInAir;

    public EntityBullet(World world) {
        super(world);
        this.setBulletSize();
        if (world.field_72995_K) {
            EntityBullet.func_184227_b((double)10.0);
        }
    }

    public EntityBullet(World world, Entity shooter, ItemAmmunition.BulletType type, double x, double y, double z, double mX, double mY, double mZ) {
        this(world);
        this.field_70250_c = shooter;
        this.setBulletType(type);
        this.func_70107_b(x, y, z);
        float speed = type == ItemAmmunition.BulletType.rocket ? 1.25f : 10.0f;
        this.field_70159_w = mX;
        this.field_70181_x = mY;
        this.field_70179_y = mZ;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed, 0.0f);
    }

    public EntityBullet(World world, EntityLivingBase shooter, float speed, ItemAmmunition.BulletType type) {
        this(world);
        this.field_70250_c = shooter;
        this.setBulletType(type);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        float yawRad = NGTMath.toRadians((float)this.field_70177_z);
        float pitchRad = NGTMath.toRadians((float)this.field_70125_A);
        this.field_70159_w = -MathHelper.func_76126_a((float)yawRad) * MathHelper.func_76134_b((float)pitchRad);
        this.field_70179_y = MathHelper.func_76134_b((float)yawRad) * MathHelper.func_76134_b((float)pitchRad);
        this.field_70181_x = -MathHelper.func_76126_a((float)pitchRad);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed, 1.0f);
    }

    public EntityBullet(World world, EntityLivingBase shooter, EntityLivingBase target, float speed, ItemAmmunition.BulletType type) {
        this(world);
        this.field_70250_c = shooter;
        this.setBulletType(type);
        this.field_70163_u = shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f;
        double d0 = target.field_70165_t - shooter.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - this.field_70163_u;
        double d2 = target.field_70161_v - shooter.field_70161_v;
        double distance = NGTMath.firstSqrt((double)(d0 * d0 + d2 * d2));
        if (distance >= 1.0E-7) {
            float f2 = (float)NGTMath.toDegrees((double)Math.atan2(d2, d0)) - 90.0f;
            float f3 = (float)(-NGTMath.toDegrees((double)Math.atan2(d1, distance)));
            double d4 = d0 / distance;
            double d5 = d2 / distance;
            this.func_70012_b(shooter.field_70165_t + d4, this.field_70163_u, shooter.field_70161_v + d5, f2, f3);
            this.func_70186_c(d0, d1, d2, speed, 1.0f);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(BREAKABLE, (Object)0);
        this.func_184212_Q().func_187214_a(AMMO_TYPE, (Object)-1);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74777_a("xTile", (short)this.tileX);
        nbt.func_74777_a("yTile", (short)this.tileY);
        nbt.func_74777_a("zTile", (short)this.tileZ);
        nbt.func_74777_a("life", (short)this.ticksInGround);
        nbt.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.landingBlock));
        nbt.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        nbt.func_74774_a("canBreak", (byte)(this.getCanBreakBlock() ? 1 : 0));
        nbt.func_74774_a("bulletType", this.getBulletType().id);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.tileX = nbt.func_74765_d("xTile");
        this.tileY = nbt.func_74765_d("yTile");
        this.tileZ = nbt.func_74765_d("zTile");
        this.ticksInGround = nbt.func_74765_d("life");
        this.landingBlock = Block.func_149729_e((int)(nbt.func_74771_c("inTile") & 0xFF));
        this.inGround = nbt.func_74771_c("inGround") == 1;
        this.setCanBreakBlock(nbt.func_74771_c("canBreak") == 1);
        this.setBulletType(ItemAmmunition.BulletType.getBulletType(nbt.func_74771_c("bulletType")));
    }

    private void setBulletSize() {
        if (this.getBulletType() == ItemAmmunition.BulletType.cannon_40cm) {
            this.func_70105_a(0.5f, 0.5f);
        } else {
            this.func_70105_a(0.05f, 0.05f);
        }
    }

    public void func_70186_c(double par1, double par3, double par5, float par7, float par8) {
        double f2 = Math.sqrt(par1 * par1 + par3 * par3 + par5 * par5);
        double d0 = (double)par7 / f2;
        this.field_70159_w = par1 *= d0;
        this.field_70181_x = par3 *= d0;
        this.field_70179_y = par5 *= d0;
        float f3 = (float)NGTMath.firstSqrt((double)(par1 * par1 + par5 * par5));
        this.field_70126_B = this.field_70177_z = (float)NGTMath.toDegrees((double)Math.atan2(par1, par5));
        this.field_70127_C = this.field_70125_A = (float)NGTMath.toDegrees((double)Math.atan2(par3, f3));
        this.ticksInGround = 0;
        if (this.field_70250_c != null) {
            double recoilCoe = 0.01;
            this.field_70250_c.field_70159_w -= this.field_70159_w * recoilCoe;
            this.field_70250_c.field_70181_x -= this.field_70181_x * recoilCoe;
            this.field_70250_c.field_70179_y -= this.field_70179_y * recoilCoe;
            this.field_70250_c.field_70133_I = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double par1, double par3, double par5, float par7, float par8, int par9, boolean par10) {
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.field_70159_w = par1;
        this.field_70181_x = par3;
        this.field_70179_y = par5;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = (float)NGTMath.firstSqrt((double)(par1 * par1 + par5 * par5));
            this.field_70126_B = this.field_70177_z = (float)NGTMath.toDegrees((double)Math.atan2(par1, par5));
            this.field_70127_C = this.field_70125_A = (float)NGTMath.toDegrees((double)Math.atan2(par3, f));
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB aabb;
        BlockPos pos;
        IBlockState state;
        this.func_70030_z();
        if (this.field_70170_p.field_72995_K) {
            this.updateClient();
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = (float)NGTMath.firstSqrt((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)NGTMath.toDegrees((double)Math.atan2(this.field_70159_w, this.field_70179_y));
            this.field_70127_C = this.field_70125_A = (float)NGTMath.toDegrees((double)Math.atan2(this.field_70181_x, f));
        }
        if ((state = this.field_70170_p.func_180495_p(pos = new BlockPos(this.tileX, this.tileY, this.tileZ))).func_185904_a() != Material.field_151579_a && (aabb = state.func_185890_d((IBlockAccess)this.field_70170_p, pos)) != null && aabb.func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.inGround) {
            if (state.func_177230_c() == this.landingBlock) {
                ++this.ticksInGround;
                if (!this.field_70170_p.field_72995_K && this.ticksInGround >= 400) {
                    this.func_70106_y();
                }
                this.onLanding(this.tileX, this.tileY, this.tileZ);
            } else {
                this.inGround = false;
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            ItemAmmunition.BulletType type;
            ++this.ticksInAir;
            if (!this.field_70170_p.field_72995_K && this.ticksInAir >= 1200) {
                this.func_70106_y();
            }
            Vec3d vecPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult mop = this.field_70170_p.func_147447_a(vecPos, vec3, false, true, false);
            vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (mop != null) {
                vec3 = new Vec3d(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
            }
            Entity hitEntity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
            if (!list.isEmpty()) {
                Vec3d vecPos2 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                double d0 = 0.0;
                for (Entity entity : list) {
                    double d1;
                    AxisAlignedBB aabb2;
                    RayTraceResult mop1;
                    boolean flag = true;
                    if (entity.equals((Object)this.field_70250_c)) {
                        flag = false;
                    }
                    if (!entity.func_70067_L() || !flag || (mop1 = (aabb2 = entity.func_174813_aQ().func_72321_a(0.5, 0.5, 0.5)).func_72327_a(vecPos2, vec3)) == null || !((d1 = vecPos2.func_72438_d(mop1.field_72307_f)) < d0) && d0 != 0.0) continue;
                    hitEntity = entity;
                    d0 = d1;
                }
            }
            if (hitEntity != null) {
                mop = new RayTraceResult(hitEntity);
            }
            boolean hitBlock = false;
            if (mop != null) {
                if (mop.field_72308_g != null) {
                    this.onHitEntity(mop.field_72308_g);
                } else {
                    hitBlock = true;
                    this.tileX = mop.func_178782_a().func_177958_n();
                    this.tileY = mop.func_178782_a().func_177956_o();
                    this.tileZ = mop.func_178782_a().func_177952_p();
                    this.landingBlock = state.func_177230_c();
                    this.inGround = true;
                    if (this.landingBlock != Blocks.field_150350_a) {
                        this.landingBlock.func_180634_a(this.field_70170_p, pos, state, (Entity)this);
                    }
                }
            }
            if (hitBlock) {
                this.field_70165_t = mop.field_72307_f.field_72450_a;
                this.field_70163_u = mop.field_72307_f.field_72448_b;
                this.field_70161_v = mop.field_72307_f.field_72449_c;
            } else {
                this.field_70165_t += this.field_70159_w;
                this.field_70163_u += this.field_70181_x;
                this.field_70161_v += this.field_70179_y;
            }
            float f2 = (float)NGTMath.firstSqrt((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)NGTMath.toDegrees((double)Math.atan2(this.field_70159_w, this.field_70179_y));
            this.field_70125_A = (float)NGTMath.toDegrees((double)Math.atan2(this.field_70181_x, f2));
            this.field_70126_B = MathHelper.func_76142_g((float)this.field_70126_B);
            this.field_70127_C = MathHelper.func_76142_g((float)this.field_70127_C);
            this.field_70125_A = this.field_70127_C + MathHelper.func_76142_g((float)(this.field_70125_A - this.field_70127_C)) * 0.2f;
            this.field_70177_z = this.field_70126_B + MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70126_B)) * 0.2f;
            double d3 = 0.999;
            if (this.func_70090_H()) {
                for (int l = 0; l < 4; ++l) {
                    double d4 = 0.25;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * d4, this.field_70163_u - this.field_70181_x * d4, this.field_70161_v - this.field_70179_y * d4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                d3 = 0.9;
            }
            if ((type = this.getBulletType()) == ItemAmmunition.BulletType.cannon_40cm || type == ItemAmmunition.BulletType.cannon_Atomic) {
                this.field_70159_w *= d3;
                this.field_70179_y *= d3;
                this.field_70181_x -= 0.025;
            } else if (type == ItemAmmunition.BulletType.rocket) {
                double len = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                double accXZ = 0.125 * (1.0 - len / 10.0);
                double accY = -0.01;
                this.field_70159_w += accXZ * (this.field_70159_w >= 0.0 ? 1.0 : -1.0) * (Math.abs(this.field_70159_w) / len);
                this.field_70179_y += accXZ * (this.field_70179_y >= 0.0 ? 1.0 : -1.0) * (Math.abs(this.field_70179_y) / len);
                this.field_70181_x += accY;
            } else {
                this.field_70159_w *= d3;
                this.field_70181_x *= d3;
                this.field_70179_y *= d3;
                this.field_70181_x -= 0.001;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateClient() {
        if (this.getBulletType() == ItemAmmunition.BulletType.rocket) {
            Entity viewer = NGTUtilClient.getMinecraft().func_175606_aa();
            double range = (double)NGTUtil.getChunkLoadDistance() - 32.0;
            if (viewer != null && viewer.func_70068_e((Entity)this) > range * range) {
                return;
            }
            int count = 15;
            Random random = this.func_130014_f_().field_73012_v;
            for (int j = 0; j < count; ++j) {
                double d0 = this.field_70165_t + random.nextDouble() * -this.field_70159_w;
                double d1 = this.field_70163_u + random.nextDouble() * -this.field_70181_x;
                double d2 = this.field_70161_v + random.nextDouble() * -this.field_70179_y;
                double dece = 0.5;
                double vari = 0.01;
                double vx = -this.field_70159_w * ((random.nextDouble() * 0.5 + 0.5) * dece) + random.nextGaussian() * vari;
                double vy = -this.field_70181_x * ((random.nextDouble() * 0.5 + 0.5) * dece) + random.nextGaussian() * vari;
                double vz = -this.field_70179_y * ((random.nextDouble() * 0.5 + 0.5) * dece) + random.nextGaussian() * vari;
                this.func_130014_f_().func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, d0, d1, d2, vx, vy, vz, new int[0]);
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public ItemAmmunition.BulletType getBulletType() {
        if (this.type == null) {
            byte type = (Byte)this.func_184212_Q().func_187225_a(AMMO_TYPE);
            if (type < 0) {
                return ItemAmmunition.BulletType.handgun_9mm;
            }
            this.type = ItemAmmunition.BulletType.getBulletType(type);
        }
        return this.type;
    }

    public void setBulletType(ItemAmmunition.BulletType par1) {
        this.func_184212_Q().func_187227_b(AMMO_TYPE, (Object)par1.id);
    }

    public void setCanBreakBlock(boolean par1) {
        byte b0 = (Byte)this.func_184212_Q().func_187225_a(BREAKABLE);
        byte b1 = (byte)(par1 ? b0 & 0xFFFFFFFE : b0 | 1);
        this.func_184212_Q().func_187227_b(BREAKABLE, (Object)b1);
    }

    public boolean getCanBreakBlock() {
        byte b0 = (Byte)this.func_184212_Q().func_187225_a(BREAKABLE);
        return (b0 & 1) == 0;
    }

    protected void onHitEntity(Entity entity) {
        if (entity.equals((Object)this.field_70250_c)) {
            return;
        }
        float damage = this.getBulletType().damage;
        if (entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.field_70250_c), damage)) {
            // empty if block
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.type == ItemAmmunition.BulletType.cannon_40cm || this.type == ItemAmmunition.BulletType.rocket) {
                boolean doMobGriefing = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                this.field_70170_p.func_72885_a((Entity)this, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 12.0f, false, doMobGriefing);
            }
            this.func_70106_y();
        }
    }

    protected void onLanding(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = this.func_130014_f_().func_180495_p(pos);
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        boolean doMobGriefing = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        ItemAmmunition.BulletType type = this.getBulletType();
        if (type == ItemAmmunition.BulletType.cannon_40cm || type == ItemAmmunition.BulletType.rocket) {
            if (!this.field_70170_p.field_72995_K) {
                float hardness = state.func_185887_b(this.field_70170_p, pos);
                if (block != Blocks.field_150350_a && doMobGriefing) {
                    if (hardness >= 0.0f && hardness < 500.0f) {
                        this.field_70170_p.func_175698_g(pos);
                    }
                    this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 12.0f, false, doMobGriefing);
                }
                this.func_70106_y();
            }
        } else if (type == ItemAmmunition.BulletType.cannon_Atomic) {
            if (!this.field_70170_p.field_72995_K) {
                float hardness = state.func_185887_b(this.field_70170_p, pos);
                if (block == Blocks.field_150350_a || !(hardness > 0.0f) || hardness < 500.0f) {
                    // empty if block
                }
                BlockUtil.setBlock((World)this.func_130014_f_(), (int)x, (int)y, (int)z, (Block)RTMBlock.effect, (int)2, (int)3);
                this.func_130014_f_().func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 10.0f, 1.0f, false);
                this.func_70106_y();
            }
        } else if (this.landingBlock != null && this.getCanBreakBlock()) {
            if (!RTMCore.gunBreakBlock) {
                BlockUtil.playBlockBreakSound((World)this.func_130014_f_(), (BlockPos)pos, (Block)this.landingBlock, (int)meta);
            } else if (this.isBreakableBlock(this.getBulletType(), state, x, y, z, doMobGriefing)) {
                NGTCore.proxy.breakBlock(this.field_70170_p, x, y, z, meta);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_175698_g(pos);
                    this.func_70106_y();
                }
            } else if (this.landingBlock == Blocks.field_150335_W) {
                if (!this.field_70170_p.field_72995_K) {
                    ((BlockTNT)this.landingBlock).func_180692_a(this.field_70170_p, pos, block.func_176203_a(1), null);
                    this.field_70170_p.func_175698_g(pos);
                    this.func_70106_y();
                }
            } else {
                BlockUtil.playBlockBreakSound((World)this.func_130014_f_(), (BlockPos)pos, (Block)this.landingBlock, (int)meta);
            }
        }
        this.setCanBreakBlock(false);
    }

    protected boolean isBreakableBlock(ItemAmmunition.BulletType bullet, IBlockState block, int x, int y, int z, boolean doMobGriefing) {
        Material mat = block.func_185904_a();
        if (bullet == ItemAmmunition.BulletType.handgun_9mm) {
            if (mat == Material.field_151584_j || mat == Material.field_151585_k || mat == Material.field_151582_l || mat == Material.field_151594_q || mat == Material.field_151593_r || mat == Material.field_151592_s || mat == Material.field_151591_t || mat == Material.field_151589_v || mat == Material.field_151597_y || mat == Material.field_151596_z || mat == Material.field_151570_A || mat == Material.field_151568_F) {
                return doMobGriefing;
            }
        } else if (bullet == ItemAmmunition.BulletType.rifle_12_7mm) {
            BlockPos blockPos = new BlockPos(x, y, z);
            if (block.func_185887_b(this.field_70170_p, blockPos) < 5.0f && block.func_177230_c().func_149638_a((Entity)this) <= 6.0f) {
                return doMobGriefing;
            }
        } else if (mat == Material.field_151575_d || mat == Material.field_151584_j || mat == Material.field_151585_k || mat == Material.field_151582_l || mat == Material.field_151594_q || mat == Material.field_151593_r || mat == Material.field_151592_s || mat == Material.field_151591_t || mat == Material.field_151589_v || mat == Material.field_151588_w || mat == Material.field_151598_x || mat == Material.field_151597_y || mat == Material.field_151596_z || mat == Material.field_151570_A || mat == Material.field_151568_F) {
            return doMobGriefing;
        }
        return false;
    }

    protected ItemStack func_184550_j() {
        return null;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }
}

