/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity;

import java.util.List;
import jp.ngt.rtm.block.tileentity.TileEntityMovingMachine;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Rotations;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMMBoundingBox
extends Entity {
    private static final DataParameter<Rotations> AABB_F = EntityDataManager.func_187226_a(EntityMMBoundingBox.class, (DataSerializer)DataSerializers.field_187199_i);
    private static final DataParameter<Rotations> AABB_L = EntityDataManager.func_187226_a(EntityMMBoundingBox.class, (DataSerializer)DataSerializers.field_187199_i);
    private TileEntityMovingMachine movingMachine;
    private boolean checkCollision;
    private AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public EntityMMBoundingBox(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityMMBoundingBox(World world, TileEntityMovingMachine tile, boolean p3) {
        this(world);
        this.movingMachine = tile;
        this.checkCollision = p3;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(AABB_F, (Object)new Rotations(-1.0f, 0.0f, 0.0f));
        this.func_184212_Q().func_187214_a(AABB_L, (Object)new Rotations(0.0f, 0.0f, 0.0f));
    }

    public AxisAlignedBB func_70114_g(Entity par1) {
        return par1 instanceof EntityMMBoundingBox ? null : par1.func_174813_aQ();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    public void setAABB(AxisAlignedBB par1) {
        this.func_174826_a(par1);
        this.func_184212_Q().func_187227_b(AABB_F, (Object)new Rotations((float)(par1.field_72340_a - 0.5), (float)par1.field_72338_b, (float)(par1.field_72339_c - 0.5)));
        this.func_184212_Q().func_187227_b(AABB_L, (Object)new Rotations((float)(par1.field_72336_d - 0.5), (float)par1.field_72337_e, (float)(par1.field_72334_f - 0.5)));
    }

    private AxisAlignedBB getAABB() {
        if (this.func_184212_Q() == null) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        Rotations roF = (Rotations)this.func_184212_Q().func_187225_a(AABB_F);
        Rotations roL = (Rotations)this.func_184212_Q().func_187225_a(AABB_L);
        if (roF.func_179415_b() == -1.0f) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return new AxisAlignedBB((double)roF.func_179415_b(), (double)roF.func_179416_c(), (double)roF.func_179413_d(), (double)roL.func_179415_b(), (double)roL.func_179416_c(), (double)roL.func_179413_d());
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.movingMachine == null) {
            this.func_70106_y();
        }
    }

    private void applyCollisionToEntities(double dx, double dy, double dz) {
        this.aabb = this.getAABB();
        double d0 = (double)0.42f + (dy < 0.0 ? -dy : 0.0);
        this.aabb = this.aabb.func_72317_d(this.field_70165_t, this.field_70163_u + d0, this.field_70161_v);
        List list = this.field_70170_p.func_72839_b((Entity)this, this.aabb);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity instanceof EntityMMBoundingBox) continue;
            this.moveEntity(entity, dx, dy, dz);
        }
    }

    private void moveEntity(Entity entity, double dx, double dy, double dz) {
        AxisAlignedBB entityBB = entity.func_174813_aQ();
        AxisAlignedBB myBB = this.func_174813_aQ();
        double y0 = myBB.field_72337_e - entityBB.field_72338_b;
        boolean flag = false;
        if (this.inY(entity, dy)) {
            if (this.onY(entity, dy)) {
                if (this.inXAndZ(entity)) {
                    double y1 = myBB.field_72337_e - (entityBB.field_72338_b + dy);
                    if (y1 != 0.0) {
                        dy += y1;
                    }
                    entity.field_70143_R = 0.0f;
                    entity.field_70181_x = 0.0;
                    entity.field_70122_E = true;
                    flag = true;
                }
            } else if (this.inXOrZ(entity)) {
                dy = 0.0;
                dx = myBB.func_72316_a(entityBB, dx);
                dz = myBB.func_72322_c(entityBB, dz);
                flag = true;
            }
            if (flag) {
                double d0 = entityBB.field_72338_b + dy + entity.func_70033_W();
                if (this.field_70170_p.field_72995_K) {
                    entity.func_70107_b(entity.field_70165_t + dx, d0, entity.field_70161_v + dz);
                } else if (!(entity instanceof EntityPlayer)) {
                    entity.func_70107_b(entity.field_70165_t + dx, d0, entity.field_70161_v + dz);
                    entity.field_70133_I = true;
                }
            }
        }
    }

    private boolean inY(Entity entity, double moveY) {
        AxisAlignedBB entityBB = entity.func_174813_aQ();
        AxisAlignedBB myBB = this.func_174813_aQ();
        if (moveY > 0.0) {
            return entityBB.field_72338_b <= myBB.field_72337_e && entityBB.field_72337_e > myBB.field_72338_b;
        }
        return entityBB.field_72338_b <= myBB.field_72337_e - moveY && entityBB.field_72337_e > myBB.field_72338_b;
    }

    private boolean onY(Entity entity, double moveY) {
        AxisAlignedBB entityBB = entity.func_174813_aQ();
        AxisAlignedBB myBB = this.func_174813_aQ();
        double d0 = 0.21;
        if (moveY > 0.0) {
            return entityBB.field_72338_b >= myBB.field_72337_e - moveY - d0 && entityBB.field_72338_b <= myBB.field_72337_e;
        }
        return entityBB.field_72338_b >= myBB.field_72337_e - d0 && entityBB.field_72338_b <= myBB.field_72337_e - moveY;
    }

    private boolean inXAndZ(Entity entity) {
        return entity.field_70165_t >= this.aabb.field_72340_a && entity.field_70165_t < this.aabb.field_72336_d && entity.field_70161_v >= this.aabb.field_72339_c && entity.field_70161_v < this.aabb.field_72334_f;
    }

    private boolean inXOrZ(Entity entity) {
        return entity.field_70165_t >= this.aabb.field_72340_a && entity.field_70165_t < this.aabb.field_72336_d || entity.field_70161_v >= this.aabb.field_72339_c && entity.field_70161_v < this.aabb.field_72334_f;
    }

    public boolean func_70097_a(DamageSource damage, float par2) {
        return false;
    }

    public void moveMM(double x, double y, double z) {
        this.applyCollisionToEntities(x, y, z);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.func_174826_a(this.getAABB().func_72317_d(x, y, z));
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    public void func_70024_g(double par1, double par3, double par5) {
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.field_70169_q = this.field_70165_t = x;
        this.field_70167_r = this.field_70163_u = y;
        this.field_70166_s = this.field_70161_v = z;
        this.moveMM(0.0, 0.0, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int count, boolean pb) {
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleMMMovement(World world, int[] ids, double moveX, double moveY, double moveZ) {
        for (int pass = 0; pass < 2; ++pass) {
            block5: for (int i = 0; i < ids.length; ++i) {
                EntityMMBoundingBox entity = (EntityMMBoundingBox)world.func_73045_a(ids[i]);
                if (entity == null) continue;
                switch (pass) {
                    case 0: {
                        entity.func_70107_b(entity.field_70165_t + moveX, entity.field_70163_u + moveY, entity.field_70161_v + moveZ);
                        continue block5;
                    }
                    case 1: {
                        entity.moveMM(moveX, moveY, moveZ);
                    }
                }
            }
        }
    }
}

