/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.ai;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.item.ItemUtil;
import jp.ngt.rtm.entity.ai.EntityAIDrivingWithSignal;
import jp.ngt.rtm.entity.npc.EntityMotorman;
import jp.ngt.rtm.entity.train.util.EnumNotch;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class EntityAIDrivingWithDiagram
extends EntityAIDrivingWithSignal {
    private List<TrainDiagram> diagram = new ArrayList<TrainDiagram>();

    public EntityAIDrivingWithDiagram(EntityMotorman par1) {
        super(par1);
        this.func_75248_a(1);
    }

    @Override
    public boolean func_75250_a() {
        if (this.motorman.hasDiagram()) {
            return super.func_75250_a();
        }
        return false;
    }

    @Override
    public void func_75249_e() {
        String[] sArray;
        super.func_75249_e();
        this.diagram.clear();
        for (String s : sArray = ItemUtil.bookToStrings((ItemStack)this.motorman.getDiagram())) {
            String[] sArray2 = s.split(" ");
            int t = 0;
            String com = "";
            int pX = 0;
            int pY = 0;
            int pZ = 0;
            try {
                t = Integer.valueOf(sArray2[0]);
                com = sArray2[1];
                pX = Integer.valueOf(sArray2[2]);
                pY = Integer.valueOf(sArray2[3]);
                pZ = Integer.valueOf(sArray2[4]);
            }
            catch (NumberFormatException e) {
                this.diagram.clear();
                this.diagram.add(new TrainDiagram(0, "finish", 0, 0, 0));
                NGTLog.sendChatMessageToAll((String)"Illegal format", (Object[])new Object[0]);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            this.diagram.add(new TrainDiagram(t, com, pX, pY, pZ));
            NGTLog.debug((String)("add diagram : " + s));
        }
        this.diagram.add(new TrainDiagram(0, "finish", 0, 0, 0));
    }

    @Override
    public void func_75246_d() {
        this.runTrain();
    }

    private void runTrain() {
        TrainDiagram td = this.diagram.get(0);
        if (td.command.equals("finish") || td.command.length() == 0) {
            return;
        }
        int worldTime = (int)(this.motorman.field_70170_p.func_72820_D() % 24000L);
        int signalLevel = this.train.getSignal();
        if (td.command.equals("start")) {
            if (worldTime >= td.time - 2 && worldTime <= td.time + 2 && signalLevel >= 0 && signalLevel < 5) {
                this.train.setNotch(4);
                this.diagram.remove(0);
                NGTLog.debug((String)"motorman start train");
            }
            return;
        }
        float distance = this.getDistanceTrain((Entity)this.train, td.pointX, td.pointZ);
        float margin = td.time - worldTime;
        float prevSpeed = this.train.getSpeed();
        float ac1 = 0.0f;
        int notch = 0;
        int notchS = 0;
        if (signalLevel > 0) {
            notchS = EnumNotch.getNotchFromSignal((int)signalLevel).id;
        }
        if (td.command.equals("set_speed")) {
            float speed = (float)td.pointX / 72.0f;
            ac1 = (speed - prevSpeed) / margin;
            notch = EnumNotch.getSuitableNotchFromAcceleration((float)ac1).id;
        } else if (td.command.equals("pass")) {
            ac1 = 2.0f * (distance - prevSpeed * margin) / (margin * margin);
            if (ac1 > 0.0f) {
                float sp0 = prevSpeed + ac1 * margin;
                notch = EnumNotch.getSuitableNotchFromSpeed((float)sp0).id;
            } else if (ac1 < 0.0f) {
                notch = EnumNotch.getSuitableNotchFromAcceleration((float)ac1).id;
            }
        } else if (td.command.equals("stop")) {
            if (distance <= 360.0f) {
                ac1 = -prevSpeed / margin;
                if (0.5f * prevSpeed * margin < distance) {
                    ac1 += 7.5E-4f;
                }
                notch = EnumNotch.getSuitableNotchFromAcceleration((float)ac1).id;
            } else {
                notch = (ac1 = 2.0f * ((distance -= 360.0f) - prevSpeed * (margin -= 600.0f)) / (margin * margin)) >= 0.0f ? (ac1 < EnumNotch.accelerate_1.acceleration && prevSpeed >= EnumNotch.accelerate_4.max_speed ? EnumNotch.inertia.id : EnumNotch.accelerate_4.id) : (ac1 > EnumNotch.brake_1.acceleration ? EnumNotch.inertia.id : EnumNotch.getSuitableNotchFromAcceleration((float)ac1).id);
            }
            if (worldTime >= td.time - 2 && worldTime <= td.time + 2) {
                notch = -4;
                NGTLog.debug((String)"motorman stop train");
            }
        }
        if (signalLevel > 0) {
            notch = notch <= notchS ? notch : notchS;
        }
        this.train.setNotch(notch);
        if (worldTime >= td.time - 2 && worldTime <= td.time + 2) {
            this.diagram.remove(0);
        }
    }

    private float getDistanceTrain(Entity entity, double par1, double par2) {
        float f1 = (float)(entity.field_70165_t - par1);
        float f3 = (float)(entity.field_70161_v - par2);
        return (float)Math.sqrt(f1 * f1 + f3 * f3);
    }

    public class TrainDiagram {
        public final int time;
        public final String command;
        public final int pointX;
        public final int pointY;
        public final int pointZ;

        public TrainDiagram(int par1Time, String par2Command, int par3X, int par4Y, int par5Z) {
            this.time = par1Time;
            this.command = par2Command;
            this.pointX = par3X;
            this.pointY = par4Y;
            this.pointZ = par5Z;
        }
    }
}

