/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.npc;

import java.util.HashMap;
import java.util.Map;
import jp.ngt.rtm.entity.ai.EntityAIRangedAttackWithItem;
import jp.ngt.rtm.entity.ai.EntityAITravelByTrain;
import jp.ngt.rtm.entity.npc.EntityNPC;
import jp.ngt.rtm.item.ItemGun;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class Role {
    private static Map<String, Role> nameMap = new HashMap<String, Role>();
    public static final Role PASSENGER = new RolePassenger("passenger");
    public static final Role ATTENDANT = new RoleAttendant("attendant");
    public static final Role MANNEQUIN = new Role("mannequin");
    public static final Role GUARD = new RoleGuard("guard");
    public static final Role MOTORMAN = new Role("motorman");
    public static final Role SALESPERSON = new RoleSalesperson("salesperson");

    public Role(String name) {
        nameMap.put(name, this);
    }

    public static Role getRole(String name) {
        return nameMap.containsKey(name) ? nameMap.get(name) : MANNEQUIN;
    }

    public void init(EntityNPC entity) {
        entity.func_70661_as().func_75499_g();
        entity.func_70624_b(null);
        entity.field_70714_bg.field_75782_a.clear();
        entity.field_70715_bh.field_75782_a.clear();
    }

    public void onInventoryChanged(EntityNPC entity) {
    }

    public static class RoleSalesperson
    extends Role {
        public RoleSalesperson(String name) {
            super(name);
        }

        @Override
        public void init(EntityNPC entity) {
            super.init(entity);
            entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPlayer.class, 4.0f));
            entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
        }
    }

    public static class RoleGuard
    extends Role {
        private EntityAIBase aiRangedAttack;
        private EntityAIBase aiLeapAtTarget;
        private EntityAIBase aiCollideAttack;

        public RoleGuard(String name) {
            super(name);
        }

        @Override
        public void init(EntityNPC entity) {
            this.aiRangedAttack = new EntityAIRangedAttackWithItem(entity, 0.6749999523162842, 20, 30, 20.0f);
            this.aiLeapAtTarget = new EntityAILeapAtTarget((EntityLiving)entity, 0.45f);
            this.aiCollideAttack = new EntityAIAttackMelee((EntityCreature)entity, 0.6749999523162842, true);
            super.init(entity);
            entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
            entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)entity, (double)0.45f));
            entity.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPlayer.class, 4.0f));
            entity.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
            entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)entity));
            entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)entity));
            entity.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)entity, true, new Class[0]));
            entity.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityLiving.class, 0, false, false, IMob.field_82192_a));
        }

        @Override
        public void onInventoryChanged(EntityNPC entity) {
            entity.field_70714_bg.func_85156_a(this.aiRangedAttack);
            entity.field_70714_bg.func_85156_a(this.aiLeapAtTarget);
            entity.field_70714_bg.func_85156_a(this.aiCollideAttack);
            ItemStack item = entity.getHeldItem();
            if (item != null && item.func_77973_b() instanceof ItemGun) {
                entity.field_70714_bg.func_75776_a(3, this.aiRangedAttack);
            } else {
                entity.field_70714_bg.func_75776_a(2, this.aiLeapAtTarget);
                entity.field_70714_bg.func_75776_a(3, this.aiCollideAttack);
            }
        }
    }

    public static class RoleAttendant
    extends Role {
        public RoleAttendant(String name) {
            super(name);
        }

        @Override
        public void init(EntityNPC entity) {
            super.init(entity);
            entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
            entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)entity, (double)0.45f));
            entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPlayer.class, 4.0f));
            entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
        }
    }

    public static class RolePassenger
    extends Role {
        public RolePassenger(String name) {
            super(name);
        }

        @Override
        public void init(EntityNPC entity) {
            super.init(entity);
            entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
            entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITravelByTrain(entity, 0.45f));
            entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)entity, (double)0.45f));
            entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPlayer.class, 4.0f));
            entity.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
        }
    }
}

