/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train;

import java.util.List;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.protection.Lockable;
import jp.ngt.ngtlib.util.PermissionManager;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.entity.EntityBumpingPost;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.parts.EntityVehiclePart;
import jp.ngt.rtm.entity.train.util.BogieController;
import jp.ngt.rtm.entity.train.util.TrainState;
import jp.ngt.rtm.entity.vehicle.VehicleTrackerEntry;
import jp.ngt.rtm.modelpack.cfg.TrainConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetTrain;
import jp.ngt.rtm.rail.TileEntityLargeRailBase;
import jp.ngt.rtm.rail.TileEntityLargeRailCore;
import jp.ngt.rtm.rail.TileEntityLargeRailSwitchCore;
import jp.ngt.rtm.rail.util.RailMap;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class EntityBogie
extends Entity
implements Lockable {
    public static final DataParameter<Integer> TRAIN_ID = EntityDataManager.func_187226_a(EntityBogie.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Byte> BOGIE_STATE = EntityDataManager.func_187226_a(EntityBogie.class, (DataSerializer)DataSerializers.field_187191_a);
    private EntityTrainBase parentTrain;
    public boolean isActivated = false;
    public float movingYaw;
    private boolean tracked;
    private TileEntityLargeRailCore currentRailObj;
    private RailMap currentRailMap;
    private final double[] posBuf = new double[3];
    private final float[] rotationBuf = new float[4];
    private int split = -1;
    private int prevPosIndex;
    private float jointDelay;
    private boolean reverbSound;
    private int jointIndex;
    public float rotationRoll;
    public float prevRotationRoll;
    @SideOnly(value=Side.CLIENT)
    private int carPosRotationInc;
    @SideOnly(value=Side.CLIENT)
    private float carYaw;
    @SideOnly(value=Side.CLIENT)
    private float carPitch;
    @SideOnly(value=Side.CLIENT)
    private float carRoll;

    public EntityBogie(World world) {
        super(world);
        this.field_70158_ak = true;
        this.field_70156_m = true;
        this.setBogieSize(2.75f, 1.1875f);
    }

    public EntityBogie(World world, byte id, EntityTrainBase parent) {
        this(world);
        this.setBogieId(id);
        this.parentTrain = parent;
    }

    public void setBogieSize(float width, float height) {
        this.func_70105_a(width, height);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TRAIN_ID, (Object)0);
        this.func_184212_Q().func_187214_a(BOGIE_STATE, (Object)0);
    }

    public boolean func_70039_c(NBTTagCompound nbt) {
        return false;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    public AxisAlignedBB func_70114_g(Entity par1) {
        return par1 instanceof EntityVehiclePart ? null : par1.func_174813_aQ();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public double func_70033_W() {
        return 0.0;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public BogieController.MotionState updateBogiePos(float speed, float trainLength, EntityBogie frontBogie) {
        double pz;
        double py;
        if (this.updateCollision()) {
            return BogieController.MotionState.STOP;
        }
        this.movingYaw = NGTMath.wrapAngle((float)(this.field_70177_z + (this.isFront() ? 0.0f : 180.0f)));
        double px = this.field_70165_t + (double)NGTMath.sin((float)this.movingYaw) * (double)speed;
        if (!this.resetRailObj(px, py = this.field_70163_u, pz = this.field_70161_v + (double)NGTMath.cos((float)this.movingYaw) * (double)speed)) {
            return BogieController.MotionState.FLY;
        }
        RailMap rm = this.currentRailMap;
        int pIndex = 0;
        if (frontBogie == null || this.prevPosIndex == -1) {
            pIndex = rm.getNearlestPoint(this.split, px, pz);
        } else {
            int indexInc = (int)((speed + 0.25f) * 32.0f);
            int indexNeg = this.prevPosIndex - indexInc;
            int indexPos = this.prevPosIndex + indexInc;
            int indexMin = indexNeg < 0 ? 0 : indexNeg;
            int indexMax = indexPos > this.split ? this.split : indexPos;
            double[] fp = frontBogie.getPosBuf();
            double dif = Double.MAX_VALUE;
            double tlSq = trainLength * trainLength;
            for (int i = indexMin; i < indexMax; ++i) {
                double[] pxz = rm.getRailPos(this.split, i);
                double lenTemp = EntityBogie.getDistanceSq(pxz[1], py, pxz[0], fp[0], fp[1], fp[2]);
                double difTemp = Math.abs(lenTemp - tlSq);
                if (!(difTemp < dif)) continue;
                dif = difTemp;
                pIndex = i;
            }
        }
        this.prevPosIndex = pIndex;
        double[] posZX = rm.getRailPos(this.split, pIndex);
        py = rm.getRailHeight(this.split, pIndex) + this.func_70033_W();
        float railYaw = NGTMath.wrapAngle((float)rm.getRailRotation(this.split, pIndex));
        float movYaw = EntityBogie.fixBogieYaw(this.movingYaw, railYaw);
        float yaw = EntityBogie.fixBogieYaw(this.field_70177_z, movYaw);
        float pitch = EntityBogie.fixBogiePitch(rm.getRailPitch(this.split, pIndex), railYaw, yaw);
        float cant = rm.getCant(this.split, pIndex);
        if (Math.abs(NGTMath.wrapAngle((float)(railYaw - yaw))) > 90.0f) {
            cant *= -1.0f;
        }
        if (this.field_70165_t == posZX[1] && this.field_70161_v == posZX[0]) {
            return BogieController.MotionState.MOVE;
        }
        this.posBuf[0] = posZX[1];
        this.posBuf[1] = py;
        this.posBuf[2] = posZX[0];
        this.rotationBuf[0] = yaw;
        this.rotationBuf[1] = pitch;
        this.rotationBuf[2] = movYaw;
        this.rotationBuf[3] = cant;
        if (this.jointDelay > 0.0f) {
            this.jointDelay -= speed;
            if (this.jointDelay <= 0.0f) {
                this.playJointSound();
            }
        }
        return BogieController.MotionState.MOVE;
    }

    private static double getDistanceSq(double x0, double y0, double z0, double x1, double y1, double z1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double dz = z1 - z0;
        return dx * dx + dy * dy + dz * dz;
    }

    private boolean resetRailObj(double px, double py, double pz) {
        TileEntityLargeRailCore coreObj = this.getRail(px, py, pz);
        if (coreObj == null) {
            return false;
        }
        if (this.currentRailObj != coreObj) {
            this.currentRailObj = coreObj;
            if (coreObj instanceof TileEntityLargeRailSwitchCore) {
                TileEntityLargeRailSwitchCore switchObj = (TileEntityLargeRailSwitchCore)coreObj;
                this.currentRailMap = switchObj.getSwitch().getNearestPoint(this).getActiveRailMap(this.field_70170_p);
            } else {
                this.currentRailMap = coreObj.getRailMap(this);
            }
            this.split = (int)(this.currentRailMap.getLength() * 32.0);
            this.prevPosIndex = -1;
            this.onChangeRail(coreObj);
        }
        return true;
    }

    private TileEntityLargeRailCore getRail(double px, double py, double pz) {
        TileEntityLargeRailCore coreObj;
        TileEntityLargeRailBase railObj = TileEntityLargeRailBase.getRailFromCoordinates(this.field_70170_p, px, py + 2.0, pz, 0);
        if (railObj != null && (coreObj = railObj.getRailCore()) != null) {
            return coreObj;
        }
        return null;
    }

    protected void onChangeRail(TileEntityLargeRailCore newRail) {
        this.reverbSound = newRail.isReberbSound();
        TrainConfig cfg = (TrainConfig)((ModelSetTrain)this.getTrain().getResourceState().getResourceSet()).getConfig();
        if (!cfg.muteJointSound) {
            this.jointIndex = 0;
            this.playJointSound();
        }
    }

    protected boolean reverseJointArray() {
        boolean b0 = this.getTrain().getTrainDirection() == 0;
        boolean b1 = this.getBogieId() == 0;
        return b0 ^ b1;
    }

    protected void playJointSound() {
        EntityTrainBase train = this.getTrain();
        TrainConfig cfg = (TrainConfig)((ModelSetTrain)train.getResourceState().getResourceSet()).getConfig();
        if (!cfg.muteJointSound) {
            float pitch = train.getSpeed() / cfg.maxSpeed[4] * 0.5f + 1.0f;
            String sound = this.reverbSound ? "rtm:sounds/train/joint_reverb.ogg" : "rtm:sounds/train/joint.ogg";
            RTMCore.proxy.playSound(this, sound, 1.0f, pitch);
            int size = cfg.jointDelay[this.getBogieId()].length;
            if (this.jointIndex < size - 1) {
                int index0 = this.reverseJointArray() ? size - this.jointIndex - 1 : this.jointIndex;
                ++this.jointIndex;
                int index1 = this.reverseJointArray() ? size - this.jointIndex - 1 : this.jointIndex;
                float fcur = cfg.jointDelay[this.getBogieId()][index0];
                float fnex = cfg.jointDelay[this.getBogieId()][index1];
                this.jointDelay = Math.abs(fnex - fcur);
            }
        }
    }

    public double[] getPosBuf() {
        return this.posBuf;
    }

    public void moveBogie(EntityTrainBase train, double x, double y, double z, BogieController.UpdateFlag flag) {
        this.func_70107_b(x, y, z);
        switch (flag) {
            case ALL: {
                this.func_70101_b(this.rotationBuf[0], this.rotationBuf[1]);
                this.movingYaw = this.rotationBuf[2];
                this.rotationRoll = this.rotationBuf[3];
                break;
            }
            case YAW: {
                float movYaw = EntityBogie.fixBogieYaw(this.movingYaw, train.field_70177_z);
                float yaw = EntityBogie.fixBogieYaw(this.field_70177_z, movYaw);
                this.field_70177_z = yaw % 360.0f;
                this.movingYaw = movYaw;
                break;
            }
        }
    }

    public final void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (!this.tracked) {
                this.tracked = VehicleTrackerEntry.trackingVehicle(this);
            }
        } else {
            boolean bl = false;
        }
        if (this.getTrain() == null) {
            this.func_70106_y();
        }
    }

    public void onBogieUpdate() {
        super.func_70071_h_();
        this.prevRotationRoll = this.rotationRoll;
        if (this.field_70170_p.field_72995_K) {
            this.updatePosAndRotationClient();
            if (this.field_70170_p.func_175667_e(this.func_180425_c())) {
                this.func_145775_I();
            }
        }
    }

    public void func_70106_y() {
        if (this.func_130014_f_().field_72995_K && this.getTrain() != null && this.getTrain().getVehicleState(TrainState.TrainStateType.ChunkLoader) > 0) {
            return;
        }
        super.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    protected void updatePosAndRotationClient() {
        EntityTrainBase train;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.carPosRotationInc > 0) {
            float d0 = 1.0f / (float)this.carPosRotationInc;
            this.field_70177_z += NGTMath.wrapAngle((float)((float)((double)this.carYaw - (double)this.field_70177_z))) * d0;
            this.field_70125_A = (float)((double)this.field_70125_A + ((double)this.carPitch - (double)this.field_70125_A) * (double)d0);
            this.rotationRoll = (float)((double)this.rotationRoll + ((double)this.carRoll - (double)this.rotationRoll) * (double)d0);
            --this.carPosRotationInc;
        }
        if ((train = this.getTrain()) != null) {
            float[][] pos = ((TrainConfig)((ModelSetTrain)train.getResourceState().getResourceSet()).getConfig()).getBogiePos();
            byte bogieIndex = this.getBogieId();
            Vec3 v31 = PooledVec3.create((double)pos[bogieIndex][0], (double)pos[bogieIndex][1], (double)pos[bogieIndex][2]);
            v31 = v31.rotateAroundX(train.field_70125_A);
            v31 = v31.rotateAroundY(train.field_70177_z);
            double newX = train.field_70165_t + v31.getX();
            double newY = train.field_70163_u + v31.getY();
            double newZ = train.field_70161_v + v31.getZ();
            this.func_70107_b(newX, newY, newZ);
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_70097_a(DamageSource par1, float par2) {
        if (this.getTrain() == null || this.getTrain().field_70128_L) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return true;
        }
        return this.getTrain().func_70097_a(par1, par2);
    }

    private boolean updateCollision() {
        double range = this.field_70130_N * 2.0f;
        List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t - range, this.field_70163_u - 1.1875, this.field_70161_v - range, this.field_70165_t + range, this.field_70163_u + 1.1875, this.field_70161_v + range));
        return this.collideWithEntities(list);
    }

    private boolean collideWithEntities(List<Entity> list) {
        EntityTrainBase train = this.getTrain();
        EntityBogie nearestBogie = null;
        double distanceSq = Double.MAX_VALUE;
        for (Entity entity : list) {
            if (entity instanceof EntityBogie) {
                double d0;
                if (!this.collideWithBogie((EntityBogie)entity) || !((d0 = this.func_70068_e(entity)) < distanceSq)) continue;
                nearestBogie = (EntityBogie)entity;
                distanceSq = d0;
                continue;
            }
            if (entity instanceof EntityBumpingPost) {
                this.collideWithBumpingPost((EntityBumpingPost)entity);
                continue;
            }
            if (!(entity instanceof EntityLivingBase)) continue;
            this.collideWithLiving((EntityLivingBase)entity);
        }
        if (nearestBogie != null) {
            this.connectBogie(nearestBogie);
            return true;
        }
        return false;
    }

    private boolean collideWithBogie(EntityBogie bogie) {
        EntityTrainBase train = this.getTrain();
        EntityTrainBase train2 = bogie.getTrain();
        if (train2 != null && !train.equals(train2)) {
            float sp1;
            if (train.getFormation() != null && train.getFormation().containBogie(bogie)) {
                return false;
            }
            if (!train.inConnectableRange(train2)) {
                return false;
            }
            RailMap rm0 = TileEntityLargeRailBase.getRailMapFromCoordinates(this.field_70170_p, this, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            RailMap rm1 = TileEntityLargeRailBase.getRailMapFromCoordinates(this.field_70170_p, bogie, bogie.field_70165_t, bogie.field_70163_u, bogie.field_70161_v);
            if (rm0 == null || !rm0.canConnect(rm1)) {
                return false;
            }
            if (this.isActivated || bogie.isActivated) {
                return true;
            }
            float speed0 = train.getSpeed();
            float speed1 = train2.getSpeed();
            boolean b0 = train.getTrainDirection() == this.getBogieId();
            boolean b1 = train2.getTrainDirection() == bogie.getBogieId();
            float sp0 = b0 ? speed0 : -speed0;
            float f = sp1 = b1 ? -speed1 : speed1;
            if (sp0 - sp1 >= 0.0f) {
                train2.setSpeed(b0 ^ b1 ? speed0 : -speed0);
                train.setSpeed(b0 ^ b1 ? speed1 : -speed1);
            }
        }
        return false;
    }

    private void connectBogie(EntityBogie bogie) {
        this.getTrain().connectTrain(this, bogie);
        this.isActivated = false;
        bogie.isActivated = false;
    }

    private boolean collideWithBumpingPost(EntityBumpingPost entity) {
        EntityTrainBase train = this.getTrain();
        double dis = NGTMath.pow((double)1.75, (int)2);
        double dsq = this.func_70068_e((Entity)entity);
        if (train.getTrainDirection() == this.getBogieId() && dsq <= dis) {
            train.stopTrain(true);
            if (train.getFirstPassenger() instanceof EntityPlayer) {
                // empty if block
            }
        }
        return false;
    }

    private boolean collideWithLiving(EntityLivingBase entity) {
        EntityTrainBase train = this.getTrain();
        if (!entity.equals((Object)train.getFirstPassenger()) && !entity.func_184218_aH()) {
            float speed = train.getSpeed();
            double dis = NGTMath.pow((double)(this.field_70130_N / 2.0f + 0.375f), (int)2);
            if (speed > 0.0f && this.func_70068_e((Entity)entity) < dis) {
                double d2 = entity.field_70165_t - this.field_70165_t;
                double d3 = entity.field_70161_v - this.field_70161_v;
                double d4 = d2 * d2 + d3 * d3;
                entity.func_70024_g(d2 / d4 * 10.0, 0.3, d3 / d4 * 10.0);
                EntityDamageSource dmgSource = new EntityDamageSource("train", (Entity)train);
                float damage = speed * 7.2f;
                entity.func_70097_a((DamageSource)dmgSource, damage);
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double par1, double par3, double par5, float par7, float par8, int par9, boolean par10) {
        this.carPosRotationInc = par9;
        this.carYaw = par7;
        this.carPitch = par8;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRoll(float par1) {
        this.carRoll = par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
    }

    public void func_70091_d(MoverType type, double par1, double par3, double par5) {
    }

    public void func_70024_g(double par1, double par3, double par5) {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.getTrain() != null) {
            if (PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "driveTrain")) {
                return this.getTrain().interactTrain(this, player);
            }
        } else if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == RTMItem.paddle) {
            return true;
        }
        return true;
    }

    public void setTrain(EntityTrainBase train) {
        this.func_184212_Q().func_187227_b(TRAIN_ID, (Object)train.func_145782_y());
    }

    public EntityTrainBase getTrain() {
        if (this.parentTrain == null || this.parentTrain.field_70128_L) {
            int id = (Integer)this.func_184212_Q().func_187225_a(TRAIN_ID);
            Entity entity = this.field_70170_p.func_73045_a(id);
            if (entity instanceof EntityTrainBase) {
                this.parentTrain = (EntityTrainBase)entity;
            }
            if (this.parentTrain == null || this.parentTrain.field_70128_L) {
                return null;
            }
        }
        return this.parentTrain;
    }

    private byte getBogieState() {
        return (Byte)this.func_184212_Q().func_187225_a(BOGIE_STATE);
    }

    private void setBogieState(int par1) {
        this.func_184212_Q().func_187227_b(BOGIE_STATE, (Object)((byte)par1));
    }

    public boolean isFront() {
        byte state = this.getBogieState();
        return state >> 4 == 1;
    }

    public void setFront(boolean par1) {
        int i = par1 ? 1 : 0;
        int state = this.getBogieState();
        state = state & 0xF | i << 4;
        this.setBogieState(state);
    }

    public byte getBogieId() {
        byte state = this.getBogieState();
        return (byte)((state & 0xF) - 1);
    }

    public void setBogieId(int par1) {
        int state = this.getBogieState();
        state = state & 0xF0 | par1 + 1;
        this.setBogieState(state);
    }

    public static float fixBogieYaw(float yaw1, float yaw2) {
        float f0 = Math.abs(yaw1 - yaw2);
        f0 = f0 > 180.0f ? 360.0f - f0 : f0;
        return NGTMath.wrapAngle((float)(f0 > 90.0f ? yaw2 + 180.0f : yaw2));
    }

    public static float fixBogiePitch(float railPitch, float railYaw, float bogieYaw) {
        float f0 = Math.abs(bogieYaw - railYaw);
        return NGTMath.wrapAngle((float)(f0 > 45.0f ? -railPitch : railPitch));
    }

    public Object getTarget(World world, int x, int y, int z) {
        return this.getTrain();
    }

    public boolean lock(EntityPlayer player, String code) {
        return true;
    }

    public boolean unlock(EntityPlayer player, String code) {
        return true;
    }

    public int getProhibitedAction() {
        return 1;
    }
}

