/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train.parts;

import javax.annotation.Nullable;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.ngtlib.util.PermissionManager;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMItem;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.entity.EntityBullet;
import jp.ngt.rtm.entity.FirearmController;
import jp.ngt.rtm.entity.train.parts.EntityCargoWithModel;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.item.ItemAmmunition;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.cfg.FirearmConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetFirearm;
import jp.ngt.rtm.network.PacketNotice;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityArtillery
extends EntityCargoWithModel<ModelSetFirearm> {
    public static final DataParameter<Integer> AMMO = EntityDataManager.func_187226_a(EntityArtillery.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> B_PITCH = EntityDataManager.func_187226_a(EntityArtillery.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> B_YAW = EntityDataManager.func_187226_a(EntityArtillery.class, (DataSerializer)DataSerializers.field_187193_c);
    private int recoilCount;
    private int ammoCount;
    public final FirearmController controller = new FirearmController();

    public EntityArtillery(World par1) {
        super(par1);
        this.func_70105_a(3.0f, 2.5f);
    }

    public EntityArtillery(World par1, ItemStack itemStack, int x, int y, int z) {
        super(par1, itemStack, x, y, z);
    }

    public EntityArtillery(World par1, EntityVehicleBase par2, ItemStack par3, float[] par4Pos, byte id) {
        super(par1, par2, par3, par4Pos, id);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(AMMO, (Object)-1);
        this.func_184212_Q().func_187214_a(B_PITCH, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(B_YAW, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setBarrelYaw(nbt.func_74760_g("barrelYaw"));
        this.setBarrelPitch(nbt.func_74760_g("barrelPitch"));
        this.setAmmo(nbt.func_74762_e("ammo"));
    }

    @Override
    protected void readCargoFromNBT(NBTTagCompound nbt) {
        super.readCargoFromNBT(nbt);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("barrelYaw", this.getBarrelYaw());
        nbt.func_74776_a("barrelPitch", this.getBarrelPitch());
        nbt.func_74768_a("ammo", this.hasAmmo());
    }

    @Override
    protected void writeCargoToNBT(NBTTagCompound nbt) {
        super.writeCargoToNBT(nbt);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.recoilCount > 0) {
            --this.recoilCount;
        }
        if (this.ammoCount > 0) {
            if (this.recoilCount <= 0) {
                ItemAmmunition.BulletType type = ItemAmmunition.BulletType.getBulletType(this.hasAmmo());
                boolean b = this.func_130014_f_().field_72995_K ? this.fireOnClient(type) : this.fireOnServer(type);
                this.recoilCount = ((FirearmConfig)((ModelSetFirearm)this.getResourceState().getResourceSet()).getConfig()).rateOfFire;
                --this.ammoCount;
            }
        } else if (!this.func_130014_f_().field_72995_K && this.ammoCount == 0 && this.hasAmmo() >= 0) {
            this.setAmmo(-1);
        }
        if (this.func_184188_bt().isEmpty()) {
            this.controller.onUpdate(this);
        } else {
            Entity ridden = (Entity)this.func_184188_bt().get(0);
            float yaw = NGTMath.wrapAngle((float)(-ridden.field_70177_z - this.field_70177_z));
            this.setBarrelYaw(yaw);
            this.setBarrelPitch(ridden.field_70125_A);
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            FirearmConfig cfg = (FirearmConfig)((ModelSetFirearm)this.getResourceState().getResourceSet()).getConfig();
            Vec3 v31 = PooledVec3.create((double)cfg.playerPos[0], (double)cfg.playerPos[1], (double)cfg.playerPos[2]);
            v31 = v31.rotateAroundX(this.field_70125_A);
            v31 = v31.rotateAroundY(this.field_70177_z);
            Vec3 v32 = v31.add(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            passenger.func_70107_b(v32.getX(), v32.getY() + passenger.func_70033_W(), v32.getZ());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateYawAndPitch(EntityPlayer player) {
        FirearmConfig cfg = (FirearmConfig)((ModelSetFirearm)this.getResourceState().getResourceSet()).getConfig();
        float speed = 0.0f;
        float riderYaw = NGTMath.wrapAngle((float)(-player.field_70177_z - this.field_70177_z));
        float yaw = this.getBarrelYaw();
        speed = cfg.rotationSpeedY;
        if ((yaw += (riderYaw - yaw) * speed) > cfg.yaw[0]) {
            yaw = cfg.yaw[0];
        }
        if (yaw < cfg.yaw[1]) {
            yaw = cfg.yaw[1];
        }
        player.field_70177_z = player.field_70126_B = -yaw - this.field_70177_z;
        float riderPitch = player.field_70125_A;
        float pitch = this.getBarrelPitch();
        speed = cfg.rotationSpeedX;
        if ((pitch += (riderPitch - pitch) * speed) > -cfg.pitch[1]) {
            pitch = -cfg.pitch[1];
        }
        if (pitch < -cfg.pitch[0]) {
            pitch = -cfg.pitch[0];
        }
        player.field_70125_A = player.field_70127_C = pitch;
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        if (this.func_184207_aI()) {
            return true;
        }
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null) {
            int type = this.getAmmoType(itemstack.func_77952_i());
            if (itemstack.func_77973_b() instanceof ItemAmmunition && type >= 0) {
                if (!(this.field_70170_p.field_72995_K || this.hasAmmo() >= 0 && this.hasAmmo() != type || -this.ammoCount >= ((FirearmConfig)((ModelSetFirearm)this.getResourceState().getResourceSet()).getConfig()).magazineSize)) {
                    this.setAmmo(type);
                    SoundEvent sound = SoundEvents.field_187577_bU;
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, SoundCategory.BLOCKS, 1.0f, 0.8f, false);
                    itemstack.func_190918_g(1);
                    --this.ammoCount;
                }
                return true;
            }
            if (itemstack.func_77973_b() == RTMItem.paddle) {
                if (!this.field_70170_p.field_72995_K && this.hasAmmo() >= 0) {
                    this.fire(player, ItemAmmunition.BulletType.getBulletType(this.hasAmmo()), -this.ammoCount);
                }
                return true;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public void onFireKeyDown(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            int type;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != RTMItem.bullet || (type = this.getAmmoType(stack.func_77952_i())) < 0) continue;
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                if (stack.func_190916_E() <= 0) {
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
            if (!this.func_130014_f_().field_72995_K) {
                this.fire(player, ItemAmmunition.BulletType.getBulletType(type), 1);
            }
            return;
        }
    }

    public boolean fire(@Nullable EntityPlayer player, ItemAmmunition.BulletType type, int count) {
        if (player != null && !PermissionManager.INSTANCE.hasPermission((ICommandSender)player, "useCannon")) {
            return false;
        }
        this.setAmmo(type.id);
        int max = ((FirearmConfig)((ModelSetFirearm)this.getResourceState().getResourceSet()).getConfig()).magazineSize;
        if (count > max) {
            count = max;
        }
        this.ammoCount = count;
        RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketNotice(1, "fire," + count, (Entity)this));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onFirePacket(String msg) {
        this.ammoCount = Integer.valueOf(msg.split(",")[1]);
    }

    protected boolean fireOnServer(ItemAmmunition.BulletType type) {
        FirearmConfig cfg = (FirearmConfig)((ModelSetFirearm)this.getResourceState().getResourceSet()).getConfig();
        Vec3 vMuzzle = PooledVec3.create((double)(cfg.muzzlePos[0] - cfg.modelPartsX.pos[0]), (double)(cfg.muzzlePos[1] - cfg.modelPartsX.pos[1]), (double)(cfg.muzzlePos[2] - cfg.modelPartsX.pos[2]));
        vMuzzle = vMuzzle.rotateAroundX(-this.getBarrelPitch());
        vMuzzle = vMuzzle.add((double)(cfg.modelPartsX.pos[0] - cfg.modelPartsY.pos[0]), (double)(cfg.modelPartsX.pos[1] - cfg.modelPartsY.pos[1]), (double)(cfg.modelPartsX.pos[2] - cfg.modelPartsY.pos[2]));
        vMuzzle = vMuzzle.rotateAroundY(this.getBarrelYaw());
        vMuzzle = vMuzzle.add((double)(cfg.modelPartsY.pos[0] - cfg.modelPartsN.pos[0]), (double)(cfg.modelPartsY.pos[1] - cfg.modelPartsN.pos[1]), (double)(cfg.modelPartsY.pos[2] - cfg.modelPartsN.pos[2]));
        vMuzzle = vMuzzle.rotateAroundY(this.field_70177_z);
        vMuzzle = vMuzzle.add(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3 vBolt = PooledVec3.create((double)(cfg.modelPartsBarrel.pos[0] - cfg.modelPartsX.pos[0]), (double)(cfg.modelPartsBarrel.pos[1] - cfg.modelPartsX.pos[1]), (double)(cfg.modelPartsBarrel.pos[2] - cfg.modelPartsX.pos[2]));
        vBolt = vBolt.rotateAroundX(-this.getBarrelPitch());
        vBolt = vBolt.add((double)(cfg.modelPartsX.pos[0] - cfg.modelPartsY.pos[0]), (double)(cfg.modelPartsX.pos[1] - cfg.modelPartsY.pos[1]), (double)(cfg.modelPartsX.pos[2] - cfg.modelPartsY.pos[2]));
        vBolt = vBolt.rotateAroundY(this.getBarrelYaw());
        vBolt = vBolt.add((double)(cfg.modelPartsY.pos[0] - cfg.modelPartsN.pos[0]), (double)(cfg.modelPartsY.pos[1] - cfg.modelPartsN.pos[1]), (double)(cfg.modelPartsY.pos[2] - cfg.modelPartsN.pos[2]));
        vBolt = vBolt.rotateAroundY(this.field_70177_z);
        vBolt = vBolt.add(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        double mX = vMuzzle.getX() - vBolt.getX();
        double mY = vMuzzle.getY() - vBolt.getY();
        double mZ = vMuzzle.getZ() - vBolt.getZ();
        EntityBullet entity = new EntityBullet(this.field_70170_p, (Entity)this, type, vMuzzle.getX(), vMuzzle.getY(), vMuzzle.getZ(), mX, mY, mZ);
        this.field_70170_p.func_72838_d((Entity)entity);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean fireOnClient(ItemAmmunition.BulletType type) {
        FirearmConfig cfg = (FirearmConfig)((ModelSetFirearm)this.getResourceState().getResourceSet()).getConfig();
        Vec3 vMuzzle = PooledVec3.create((double)(cfg.muzzlePos[0] - cfg.modelPartsX.pos[0]), (double)(cfg.muzzlePos[1] - cfg.modelPartsX.pos[1]), (double)(cfg.muzzlePos[2] - cfg.modelPartsX.pos[2]));
        vMuzzle = vMuzzle.rotateAroundX(-this.getBarrelPitch());
        vMuzzle = vMuzzle.add((double)(cfg.modelPartsX.pos[0] - cfg.modelPartsY.pos[0]), (double)(cfg.modelPartsX.pos[1] - cfg.modelPartsY.pos[1]), (double)(cfg.modelPartsX.pos[2] - cfg.modelPartsY.pos[2]));
        vMuzzle = vMuzzle.rotateAroundY(this.getBarrelYaw());
        vMuzzle = vMuzzle.add((double)(cfg.modelPartsY.pos[0] - cfg.modelPartsN.pos[0]), (double)(cfg.modelPartsY.pos[1] - cfg.modelPartsN.pos[1]), (double)(cfg.modelPartsY.pos[2] - cfg.modelPartsN.pos[2]));
        vMuzzle = vMuzzle.rotateAroundY(this.field_70177_z);
        vMuzzle = vMuzzle.add(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (type == ItemAmmunition.BulletType.rocket) {
            this.field_70170_p.func_184134_a(vMuzzle.getX(), vMuzzle.getY(), vMuzzle.getZ(), SoundEvents.field_187631_bo, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        } else if (type == ItemAmmunition.BulletType.cannon_40cm || type == ItemAmmunition.BulletType.cannon_Atomic) {
            for (int i = 0; i < 6; ++i) {
                double xRand = this.field_70170_p.field_73012_v.nextDouble() * 2.0 - 1.0;
                double yRand = this.field_70170_p.field_73012_v.nextDouble() * 2.0 - 1.0;
                double zRand = this.field_70170_p.field_73012_v.nextDouble() * 2.0 - 1.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, vMuzzle.getX() + xRand, vMuzzle.getY() + yRand, vMuzzle.getZ() + zRand, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_184134_a(vMuzzle.getX() + xRand, vMuzzle.getY() + yRand, vMuzzle.getZ() + zRand, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        } else {
            RTMCore.proxy.playSound((Entity)this, "rtm:sounds/item/gun.ogg", RTMCore.gunSoundVol, 1.0f);
        }
        return true;
    }

    public float getRecoil() {
        return (float)this.recoilCount / (float)((FirearmConfig)((ModelSetFirearm)this.getResourceState().getResourceSet()).getConfig()).rateOfFire;
    }

    public float getBarrelYaw() {
        return ((Float)this.func_184212_Q().func_187225_a(B_YAW)).floatValue();
    }

    public void setBarrelYaw(float par1) {
        if (!this.func_130014_f_().field_72995_K) {
            par1 = MathHelper.func_76142_g((float)par1);
            FirearmConfig cfg = (FirearmConfig)((ModelSetFirearm)this.getResourceState().getResourceSet()).getConfig();
            if (par1 > cfg.yaw[0]) {
                par1 = cfg.yaw[0];
            }
            if (par1 < cfg.yaw[1]) {
                par1 = cfg.yaw[1];
            }
            this.func_184212_Q().func_187227_b(B_YAW, (Object)Float.valueOf(par1));
        }
    }

    public float getBarrelPitch() {
        return ((Float)this.func_184212_Q().func_187225_a(B_PITCH)).floatValue();
    }

    public void setBarrelPitch(float par1) {
        if (!this.func_130014_f_().field_72995_K) {
            par1 = MathHelper.func_76142_g((float)par1);
            FirearmConfig cfg = (FirearmConfig)((ModelSetFirearm)this.getResourceState().getResourceSet()).getConfig();
            if (par1 > -cfg.pitch[1]) {
                par1 = -cfg.pitch[1];
            }
            if (par1 < -cfg.pitch[0]) {
                par1 = -cfg.pitch[0];
            }
            this.func_184212_Q().func_187227_b(B_PITCH, (Object)Float.valueOf(par1));
        }
    }

    public void setAmmo(int par1) {
        this.func_184212_Q().func_187227_b(AMMO, (Object)par1);
    }

    public int hasAmmo() {
        return (Integer)this.func_184212_Q().func_187225_a(AMMO);
    }

    public int getAmmoType(int par1) {
        int i0 = par1 / 4;
        if (par1 % 4 == 0 && (i0 == 0 || i0 == 5)) {
            return i0;
        }
        return -1;
    }

    @Override
    protected ResourceType getSubType() {
        return RTMResource.FIREARM;
    }

    @Override
    public void updateResourceState() {
        super.updateResourceState();
        this.setBarrelYaw(0.0f);
        this.setBarrelPitch(0.0f);
    }
}

