/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train.parts;

import jp.ngt.rtm.entity.train.parts.EntityVehiclePart;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class EntityCargo
extends EntityVehiclePart {
    private static final DataParameter<Byte> CARGO_ID = EntityDataManager.func_187226_a(EntityCargo.class, (DataSerializer)DataSerializers.field_187191_a);
    protected ItemStack itemCargo;

    public EntityCargo(World par1) {
        super(par1);
        this.field_70158_ak = true;
        this.field_70156_m = true;
    }

    public EntityCargo(World par1, ItemStack itemStack, int x, int y, int z) {
        this(par1);
        this.setItem(itemStack);
        this.isIndependent = true;
    }

    public EntityCargo(World par1, EntityVehicleBase par2, ItemStack itemStack, float[] par4Pos, byte id) {
        super(par1, par2, par4Pos);
        this.setItem(itemStack);
        this.setCargoId(id);
        this.isIndependent = false;
    }

    private void setItem(ItemStack stack) {
        if (stack.func_190916_E() > 1) {
            stack.func_190920_e(1);
        }
        this.itemCargo = stack;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CARGO_ID, (Object)0);
    }

    protected byte getCargoId() {
        return (Byte)this.func_184212_Q().func_187225_a(CARGO_ID);
    }

    protected void setCargoId(byte id) {
        this.func_184212_Q().func_187227_b(CARGO_ID, (Object)id);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        NBTTagCompound itemNBT = nbt.func_74775_l("ContainerItem");
        this.itemCargo = new ItemStack(itemNBT);
        this.setCargoId(nbt.func_74771_c("cargoId"));
        this.readCargoFromItem();
        super.func_70037_a(nbt);
    }

    protected abstract void readCargoFromNBT(NBTTagCompound var1);

    public void readCargoFromItem() {
        NBTTagCompound itemNBT = this.itemCargo.func_77978_p();
        if (itemNBT != null) {
            this.readCargoFromNBT(itemNBT);
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        this.writeCargoToItem();
        NBTTagCompound itemNBT = new NBTTagCompound();
        this.itemCargo.func_77955_b(itemNBT);
        nbt.func_74782_a("ContainerItem", (NBTBase)itemNBT);
        nbt.func_74774_a("cargoId", this.getCargoId());
        super.func_70014_b(nbt);
    }

    protected abstract void writeCargoToNBT(NBTTagCompound var1);

    public void writeCargoToItem() {
        if (!this.itemCargo.func_77942_o()) {
            this.itemCargo.func_77982_d(new NBTTagCompound());
        }
        this.writeCargoToNBT(this.itemCargo.func_77978_p());
    }

    @Override
    public void onLoadVehicle() {
    }

    public boolean func_70097_a(DamageSource par1, float par2) {
        if (this.func_180431_b(par1) || this.field_70128_L) {
            return false;
        }
        if (!par1.func_94541_c() && par1.func_76346_g() instanceof EntityPlayer) {
            if (!this.field_70170_p.field_72995_K && (this.isIndependent || this.getVehicle() == null)) {
                this.func_70106_y();
                this.dropCargoItem();
            }
            return true;
        }
        return false;
    }

    protected void dropCargoItem() {
        this.func_70099_a(this.itemCargo, 1.0f);
    }
}

