/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train.parts;

import java.util.List;
import jp.ngt.ngtlib.item.ItemUtil;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.RTMResource;
import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.entity.train.parts.CargoPos;
import jp.ngt.rtm.entity.train.parts.EntityCargoWithModel;
import jp.ngt.rtm.entity.train.parts.EntityFloor;
import jp.ngt.rtm.entity.vehicle.EntityVehicleBase;
import jp.ngt.rtm.item.ItemCargo;
import jp.ngt.rtm.item.ItemCrowbar;
import jp.ngt.rtm.modelpack.ResourceType;
import jp.ngt.rtm.modelpack.cfg.ContainerConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetContainer;
import jp.ngt.rtm.modelpack.modelset.ResourceSet;
import jp.ngt.rtm.modelpack.state.ResourceState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityContainer
extends EntityCargoWithModel<ModelSetContainer>
implements IInventory {
    private ItemStack[] containerSlots = ItemUtil.getEmptyArray((int)42);

    public EntityContainer(World world) {
        super(world);
        this.func_70105_a(3.0f, 2.5f);
    }

    public EntityContainer(World world, ItemStack itemStack, int x, int y, int z) {
        super(world, itemStack, x, y, z);
    }

    public EntityContainer(World world, EntityVehicleBase par2, ItemStack itemStack, float[] par4Pos, byte id) {
        super(world, par2, itemStack, par4Pos, id);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    protected void readCargoFromNBT(NBTTagCompound nbt) {
        super.readCargoFromNBT(nbt);
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt2 = tagList.func_150305_b(i);
            byte b0 = nbt2.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.containerSlots.length) continue;
            this.containerSlots[b0] = ItemUtil.readFromNBT((NBTTagCompound)nbt2);
        }
    }

    @Override
    protected void writeCargoToNBT(NBTTagCompound nbt) {
        super.writeCargoToNBT(nbt);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.containerSlots.length; ++i) {
            if (this.containerSlots[i].func_190926_b()) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("Slot", (byte)i);
            ItemUtil.writeToNBT((NBTTagCompound)nbt1, (ItemStack)this.containerSlots[i]);
            tagList.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("Items", (NBTBase)tagList);
    }

    private NBTTagCompound getCargoNBT() {
        if (!this.itemCargo.func_77942_o()) {
            this.itemCargo.func_77982_d(new NBTTagCompound());
        }
        return this.itemCargo.func_77978_p();
    }

    @Override
    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity instanceof EntityFloor || entity instanceof EntityVehicleBase || entity instanceof EntityBogie) {
            return null;
        }
        return entity.func_174813_aQ();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    protected void dropCargoItem() {
        this.writeCargoToNBT(this.getCargoNBT());
        this.func_70099_a(this.itemCargo, 1.0f);
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (this.isIndependent && itemstack != null) {
            if (itemstack.func_77973_b() instanceof ItemCargo && itemstack.func_77952_i() == 0) {
                double d0 = 1.5;
                double d1 = 256.0;
                List list = this.func_130014_f_().func_72839_b((Entity)player, new AxisAlignedBB(this.field_70165_t - d0, this.field_70163_u, this.field_70161_v - d0, this.field_70165_t + d0, this.field_70163_u + d1, this.field_70161_v + d0));
                EntityContainer topEntity = this;
                for (Entity entity : list) {
                    if (!(entity instanceof EntityContainer) || !(entity.field_70163_u > topEntity.field_70163_u)) continue;
                    topEntity = (EntityContainer)entity;
                }
                Object set = topEntity.getResourceState().getResourceSet();
                EntityContainer cargo = new EntityContainer(this.field_70170_p, itemstack.func_77946_l(), 0, 0, 0);
                cargo.func_70080_a(topEntity.field_70165_t, topEntity.field_70163_u + (double)((ContainerConfig)((ResourceSet)set).getConfig()).containerHeight, topEntity.field_70161_v, topEntity.field_70177_z, 0.0f);
                cargo.readCargoFromItem();
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)cargo);
                    ResourceState st2 = ((ItemCargo)itemstack.func_77973_b()).getModelState(itemstack);
                    cargo.getResourceState().readFromNBT(st2.writeToNBT());
                    cargo.updateResourceState();
                }
                itemstack.func_190918_g(1);
                return true;
            }
            if (itemstack.func_77973_b() instanceof ItemCrowbar) {
                this.func_70097_a(DamageSource.field_82728_o, 0.0f);
                return true;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.itemCargo != null) {
            player.openGui((Object)RTMCore.instance, (int)RTMCore.guiIdItemContainer, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
        return true;
    }

    @Override
    public Vec3 getPartVec() {
        if (this.getResourceState() == null) {
            this.needsUpdatePos = true;
            return Vec3.ZERO;
        }
        ContainerConfig cfg = (ContainerConfig)((ModelSetContainer)this.getResourceState().getResourceSet()).getConfig();
        CargoPos cp = CargoPos.getCargoPos(cfg.containerLength);
        float zPos = cp.zPos[this.getCargoId()];
        if (zPos == 20.0f) {
            zPos = 0.0f;
        }
        Vec3 vec = super.getPartVec();
        return PooledVec3.create((double)vec.getX(), (double)vec.getY(), (double)zPos);
    }

    public int func_70302_i_() {
        return this.containerSlots.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containerSlots[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (!this.containerSlots[par1].func_190926_b()) {
            if (this.containerSlots[par1].func_190916_E() <= par2) {
                ItemStack itemstack = this.containerSlots[par1];
                this.containerSlots[par1] = ItemStack.field_190927_a;
                return itemstack;
            }
            ItemStack itemstack = this.containerSlots[par1].func_77979_a(par2);
            if (this.containerSlots[par1].func_190916_E() == 0) {
                this.containerSlots[par1] = ItemStack.field_190927_a;
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int par1) {
        if (!this.containerSlots[par1].func_190926_b()) {
            ItemStack itemstack = this.containerSlots[par1];
            this.containerSlots[par1] = ItemStack.field_190927_a;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int par1, ItemStack itemStack) {
        this.containerSlots[par1] = itemStack;
        if (itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
    }

    public String func_70005_c_() {
        return "Inventory_Container";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1024;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_70068_e((Entity)player) < 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            this.readCargoFromNBT(this.getCargoNBT());
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            this.writeCargoToNBT(this.getCargoNBT());
        }
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Override
    protected ResourceType getSubType() {
        return RTMResource.CONTAINER;
    }

    public boolean func_191420_l() {
        return false;
    }
}

