/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train.util;

import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.math.PooledVec3;
import jp.ngt.ngtlib.math.Vec3;
import jp.ngt.rtm.entity.train.EntityBogie;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.entity.train.util.TrainState;
import jp.ngt.rtm.modelpack.cfg.TrainConfig;
import jp.ngt.rtm.modelpack.modelset.ModelSetTrain;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class BogieController {
    private EntityBogie[] bogies = new EntityBogie[2];
    private int tickCount;

    public EntityBogie getBogie(EntityTrainBase train, int bogieId) {
        if (this.bogies[bogieId] == null) {
            if (train.field_70170_p.field_72995_K) {
                this.setupBogieOnClient(train, bogieId);
            } else {
                this.setupBogieOnServer(train, bogieId);
            }
        }
        return this.bogies[bogieId];
    }

    private EntityBogie getBogie(EntityTrainBase train, boolean isFront) {
        boolean b0 = this.getBogie(train, 0).isFront();
        return !(b0 ^ isFront) ? this.getBogie(train, 0) : this.getBogie(train, 1);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean setupBogieOnClient(EntityTrainBase train, int bogieId) {
        Entity entity = train.field_70170_p.func_73045_a(train.getBogieEntityId(bogieId));
        if (entity instanceof EntityBogie) {
            this.bogies[bogieId] = (EntityBogie)entity;
            return true;
        }
        return false;
    }

    private boolean setupBogieOnServer(EntityTrainBase train, int bogieId) {
        double z;
        double y;
        float trainYaw = NGTMath.wrapAngle((float)train.field_70177_z);
        float bogieYaw = bogieId == 0 ? trainYaw : NGTMath.wrapAngle((float)(trainYaw + 180.0f));
        float[][] bPosArray = ((TrainConfig)((ModelSetTrain)train.getResourceState().getResourceSet()).getConfig()).getBogiePos();
        float bPos = bPosArray[bogieId][2];
        double x = train.field_70165_t + (double)(NGTMath.sin((float)trainYaw) * bPos);
        if (train.field_70170_p.func_175667_e(new BlockPos(x, y = train.field_70163_u, z = train.field_70161_v + (double)(NGTMath.cos((float)trainYaw) * bPos)))) {
            EntityBogie bogie = new EntityBogie(train.field_70170_p, (byte)bogieId, train);
            bogie.func_70080_a(x, y, z, bogieYaw, 0.0f);
            if (train.field_70170_p.func_72838_d((Entity)bogie)) {
                boolean isFront = train.getTrainDirection() == bogieId;
                bogie.setFront(isFront);
                bogie.setTrain(train);
                train.setBogieEntityId(bogieId, bogie.func_145782_y());
                this.bogies[bogieId] = bogie;
                return true;
            }
        }
        return false;
    }

    public void updateBogies(EntityTrainBase train) {
        this.updateBogie(train, 0);
        this.updateBogie(train, 1);
        if (this.tickCount >= 100) {
            this.tickCount = 0;
        }
        ++this.tickCount;
    }

    private void updateBogie(EntityTrainBase train, int id) {
        if (train.func_130014_f_().field_72995_K && (this.getBogie((EntityTrainBase)train, (int)id).field_70128_L || this.tickCount >= 100 && train.getVehicleState(TrainState.TrainStateType.ChunkLoader) > 0)) {
            this.setupBogieOnClient(train, id);
        }
        this.getBogie(train, id).onBogieUpdate();
    }

    public void setDead(EntityTrainBase train) {
        if (this.getBogie(train, 0) != null) {
            this.getBogie(train, 0).func_70106_y();
            this.bogies[0] = null;
        }
        if (this.getBogie(train, 1) != null) {
            this.getBogie(train, 1).func_70106_y();
            this.bogies[1] = null;
        }
    }

    public MotionState moveTrainWithBogie(EntityTrainBase train, EntityTrainBase prevTrain, float speed, boolean forceMove) {
        if (speed == 0.0f && !forceMove) {
            this.updateBogiePos(train, 0, UpdateFlag.NONE);
            this.updateBogiePos(train, 1, UpdateFlag.NONE);
            return MotionState.STOP;
        }
        EntityBogie frontBogie = this.getBogie(prevTrain, true);
        EntityBogie backBogie = this.getBogie(prevTrain, false);
        float[][] bogiePos = ((TrainConfig)((ModelSetTrain)train.getResourceState().getResourceSet()).getConfig()).getBogiePos();
        float lengthF = bogiePos[0][2];
        float lengthB = bogiePos[1][2];
        float trainLength = MathHelper.func_76135_e((float)(lengthF - lengthB));
        MotionState updateFlagFront = MotionState.NULL;
        MotionState updateFlagBack = MotionState.NULL;
        if (prevTrain == null) {
            updateFlagFront = frontBogie.updateBogiePos(speed, 0.0f, null);
        } else {
            float[][] bogiePos2 = ((TrainConfig)((ModelSetTrain)prevTrain.getResourceState().getResourceSet()).getConfig()).getBogiePos();
            double disTrain = train.getDefaultDistanceToConnectedTrain(prevTrain);
            double lenBF = Math.abs(bogiePos2[1 - prevTrain.getTrainDirection()][2]);
            double lenBB = Math.abs(bogiePos[train.getTrainDirection()][2]);
            float disBogie = (float)(disTrain - lenBF - lenBB);
            EntityBogie prevBogie = prevTrain.getBogie(1 - prevTrain.getTrainDirection());
            updateFlagFront = frontBogie.updateBogiePos(speed, disBogie, prevBogie);
        }
        if (updateFlagFront == MotionState.MOVE && (updateFlagBack = backBogie.updateBogiePos(speed, trainLength, frontBogie)) == MotionState.MOVE) {
            this.updateTrainPos(train, lengthF, lengthB);
            return MotionState.MOVE;
        }
        if (updateFlagFront == MotionState.FLY || updateFlagBack == MotionState.FLY) {
            return MotionState.FLY;
        }
        return MotionState.STOP;
    }

    private void updateTrainPos(EntityTrainBase train, float lf, float lb) {
        double d0 = Math.abs(lf) / Math.abs(lf - lb);
        double[] fp = this.getBogie(train, 0).getPosBuf();
        double[] bp = this.getBogie(train, 1).getPosBuf();
        double x = fp[0] + (bp[0] - fp[0]) * d0;
        double y = (fp[1] + bp[1]) * 0.5;
        double z = fp[2] + (bp[2] - fp[2]) * d0;
        double x0 = fp[0] - bp[0];
        double y0 = fp[1] - bp[1];
        double z0 = fp[2] - bp[2];
        float yaw = NGTMath.wrapAngle((float)((float)NGTMath.toDegrees((double)Math.atan2(x0, z0))));
        float pitch = NGTMath.wrapAngle((float)((float)NGTMath.toDegrees((double)Math.atan2(y0, Math.sqrt(x0 * x0 + z0 * z0)))));
        float roll = (this.getBogie((EntityTrainBase)train, (int)0).rotationRoll + -this.getBogie((EntityTrainBase)train, (int)1).rotationRoll) * 0.5f;
        Vec3 vec = PooledVec3.create((double)0.0, (double)1.1875, (double)0.0);
        vec = vec.rotateAroundZ(-roll);
        vec = vec.rotateAroundY(yaw);
        train.func_70080_a(x += vec.getX(), y += vec.getY() - 1.1875, z += vec.getZ(), yaw, pitch);
        train.updateRoll(roll);
        this.updateBogiePos(train, 0, UpdateFlag.ALL);
        this.updateBogiePos(train, 1, UpdateFlag.ALL);
    }

    public void updateBogiePos(EntityTrainBase train, int bogieIndex, UpdateFlag flag) {
        float[][] pos = ((TrainConfig)((ModelSetTrain)train.getResourceState().getResourceSet()).getConfig()).getBogiePos();
        Vec3 v31 = PooledVec3.create((double)pos[bogieIndex][0], (double)pos[bogieIndex][1], (double)pos[bogieIndex][2]);
        v31 = v31.rotateAroundX(train.field_70125_A);
        v31 = v31.rotateAroundY(train.field_70177_z);
        this.getBogie(train, bogieIndex).moveBogie(train, train.field_70165_t + v31.getX(), train.field_70163_u + v31.getY(), train.field_70161_v + v31.getZ(), flag);
    }

    public static enum UpdateFlag {
        ALL,
        YAW,
        NONE;

    }

    public static enum MotionState {
        MOVE,
        STOP,
        FLY,
        NULL;

    }
}

