/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.entity.train.util;

import jp.ngt.rtm.modelpack.cfg.TrainConfig;

public enum EnumNotch {
    accelerate_5(5, 1.8f, 0.002f),
    accelerate_4(4, 1.44f, 0.002f),
    accelerate_3(3, 1.08f, 0.002f),
    accelerate_2(2, 0.72f, 0.002f),
    accelerate_1(1, 0.36f, 0.002f),
    inertia(0, 0.0f, 0.0f),
    brake_1(-1, 0.0f, -5.0E-4f),
    brake_2(-2, 0.0f, -0.001f),
    brake_3(-3, 0.0f, -0.0015f),
    brake_4(-4, 0.0f, -0.002f),
    brake_5(-5, 0.0f, -0.0025f),
    brake_6(-6, 0.0f, -0.003f),
    brake_7(-7, 0.0f, -0.0035f),
    emergency_brake(-8, 0.0f, -0.01f);

    public final int id;
    public final float max_speed;
    public final float acceleration;

    private EnumNotch(int par1, float par2, float par3) {
        this.id = par1;
        this.max_speed = par2;
        this.acceleration = par3;
    }

    public static EnumNotch getNotch(int par1) {
        for (EnumNotch notch : EnumNotch.values()) {
            if (notch.id != par1) continue;
            return notch;
        }
        return inertia;
    }

    public static EnumNotch getNotchFromSignal(int par1) {
        switch (par1) {
            case 1: {
                return accelerate_5;
            }
            case 2: {
                return accelerate_4;
            }
            case 3: {
                return accelerate_3;
            }
            case 4: {
                return accelerate_2;
            }
            case 5: {
                return brake_4;
            }
        }
        return inertia;
    }

    public static float getAcceleration(int par1, float par2) {
        EnumNotch notch = EnumNotch.getNotch(par1);
        if (par1 > 0 && par2 >= notch.max_speed) {
            return 0.0f;
        }
        return notch.acceleration;
    }

    public static EnumNotch getSuitableNotchFromSpeed(float par1) {
        if (par1 >= EnumNotch.accelerate_5.max_speed) {
            return accelerate_5;
        }
        for (EnumNotch notch : EnumNotch.values()) {
            if (!(notch.max_speed >= par1) || !(notch.max_speed - 0.3f < par1)) continue;
            return notch;
        }
        return inertia;
    }

    public static EnumNotch getSuitableNotchFromAcceleration(float par1) {
        if (par1 > 0.0f) {
            return accelerate_4;
        }
        for (EnumNotch notch : EnumNotch.values()) {
            if (!(notch.acceleration <= par1) || !(notch.acceleration + 5.0E-4f > par1)) continue;
            return notch;
        }
        return inertia;
    }

    public static float getAcceleration(int notch, float prevSpeed, TrainConfig cfg) {
        if (notch == 0) {
            return 0.0f;
        }
        if (notch > 0) {
            if (prevSpeed >= cfg.maxSpeed[--notch]) {
                return 0.0f;
            }
            return cfg.accelerateion;
        }
        float decceleration = EnumNotch.getNotch((int)notch).acceleration;
        float absSpeed = Math.abs(prevSpeed);
        if (absSpeed + decceleration < 0.0f) {
            return -absSpeed;
        }
        return decceleration;
    }
}

